/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class GraphOptionsDialog
extends JDialog
implements ActionListener {
    private JButton ok_button;
    private JButton cancel_button;
    private JRadioButton sample_size_auto_button;
    private JRadioButton sample_size_default_button;
    private JRadioButton sample_size_manual_button;
    private JTextField sample_size_min_field;
    private JTextField sample_size_max_field;
    private JCheckBox sample_size_ignore_box;
    private JRadioButton temp_auto_button;
    private JRadioButton temp_default_button;
    private JRadioButton temp_manual_button;
    private JLabel temp_default_label;
    private JTextField temp_min_field;
    private JTextField temp_max_field;
    private JCheckBox temp_ignore_box;
    private JRadioButton wvap_auto_button;
    private JRadioButton wvap_default_button;
    private JRadioButton wvap_manual_button;
    private JLabel wvap_default_label;
    private JTextField wvap_min_field;
    private JTextField wvap_max_field;
    private JCheckBox wvap_ignore_box;
    private DateChooserPanel start_date_panel;
    private DateChooserPanel end_date_panel;
    private JButton reset_dates_button;
    private JSlider line_thickness_slider;
    private JCheckBox show_data_points_box;
    private boolean ok_button_pressed;
    private Color text_background_color;
    private NarcsGlobals globals = new NarcsGlobals();
    private final int SAMPLE_SIZE = 0;
    private final int STAT_TEMP = 1;
    private final int STAT_WVAP = 2;

    public GraphOptionsDialog(JFrame jFrame, int n) {
        super(jFrame, "Change Graph Settings", true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.ok_button = new JButton("OK");
        this.cancel_button = new JButton("Cancel");
        jPanel.add(this.ok_button);
        jPanel.add(this.cancel_button);
        this.getRootPane().setDefaultButton(this.ok_button);
        this.getContentPane().add((Component)jPanel, "South");
        this.ok_button.addActionListener(this);
        this.cancel_button.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new StackLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 3, 5, 5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Sample Size"));
        jPanel4.setLayout(new StackLayout());
        this.sample_size_auto_button = new JRadioButton("Automatic:  (min to max)");
        this.sample_size_default_button = new JRadioButton("Default:  (0 to max)");
        this.sample_size_manual_button = new JRadioButton("Manual: ");
        this.sample_size_min_field = new JTextField("" + this.globals.getSampleSizeManualMin(), 5);
        this.sample_size_max_field = new JTextField("" + this.globals.getSampleSizeManualMax(), 5);
        this.text_background_color = this.sample_size_min_field.getBackground();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sample_size_auto_button);
        buttonGroup.add(this.sample_size_default_button);
        buttonGroup.add(this.sample_size_manual_button);
        this.sample_size_ignore_box = new JCheckBox("Ignore values outside of min/max");
        jPanel4.add(new JLabel("Min/Max Data Range:"));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(new JLabel("    "));
        jPanel5.add(this.sample_size_auto_button);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.add(new JLabel("    "));
        jPanel6.add(this.sample_size_default_button);
        jPanel4.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        jPanel7.add(new JLabel("    "));
        jPanel7.add(this.sample_size_manual_button);
        jPanel7.add(this.sample_size_min_field);
        jPanel7.add(this.sample_size_max_field);
        jPanel4.add(jPanel7);
        jPanel4.add(this.sample_size_ignore_box);
        if (this.globals.getSampleSizeMinMaxOption() == 0) {
            this.sample_size_auto_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(false);
        } else if (this.globals.getSampleSizeMinMaxOption() == 1) {
            this.sample_size_default_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(true);
        } else {
            this.sample_size_manual_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(true);
        }
        this.sample_size_ignore_box.setSelected(this.globals.getSampleSizeIgnoreExtremes());
        this.sample_size_auto_button.addActionListener(this);
        this.sample_size_default_button.addActionListener(this);
        this.sample_size_manual_button.addActionListener(this);
        jPanel3.add(jPanel4);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createTitledBorder("Temperature"));
        jPanel8.setLayout(new StackLayout());
        this.temp_auto_button = new JRadioButton("Automatic:  (min to max)");
        this.temp_default_button = new JRadioButton("Default:  ");
        this.temp_manual_button = new JRadioButton("Manual: ");
        this.temp_default_label = new JLabel("(" + this.globals.getTempDefaultMin() + " to " + this.globals.getTempDefaultMax() + ")");
        this.temp_min_field = new JTextField("" + this.globals.getTempManualMin(), 5);
        this.temp_max_field = new JTextField("" + this.globals.getTempManualMax(), 5);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.temp_auto_button);
        buttonGroup2.add(this.temp_default_button);
        buttonGroup2.add(this.temp_manual_button);
        this.temp_ignore_box = new JCheckBox("Ignore values outside of min/max");
        jPanel8.add(new JLabel("Min/Max Data Range:"));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(0));
        jPanel9.add(new JLabel("    "));
        jPanel9.add(this.temp_auto_button);
        jPanel8.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout(0));
        jPanel10.add(new JLabel("    "));
        jPanel10.add(this.temp_default_button);
        jPanel10.add(this.temp_default_label);
        jPanel8.add(jPanel10);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new FlowLayout(0));
        jPanel11.add(new JLabel("    "));
        jPanel11.add(this.temp_manual_button);
        jPanel11.add(this.temp_min_field);
        jPanel11.add(this.temp_max_field);
        jPanel8.add(jPanel11);
        jPanel8.add(this.temp_ignore_box);
        if (this.globals.getTempMinMaxOption() == 0) {
            this.temp_auto_button.setSelected(true);
            this.temp_ignore_box.setEnabled(false);
        } else if (this.globals.getTempMinMaxOption() == 1) {
            this.temp_default_button.setSelected(true);
            this.temp_ignore_box.setEnabled(true);
        } else {
            this.temp_manual_button.setSelected(true);
            this.temp_ignore_box.setEnabled(true);
        }
        this.temp_ignore_box.setSelected(this.globals.getTempIgnoreExtremes());
        this.temp_auto_button.addActionListener(this);
        this.temp_default_button.addActionListener(this);
        this.temp_manual_button.addActionListener(this);
        jPanel3.add(jPanel8);
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(BorderFactory.createTitledBorder("Moisture"));
        jPanel12.setLayout(new StackLayout());
        this.wvap_auto_button = new JRadioButton("Automatic:  (min to max)");
        this.wvap_default_button = new JRadioButton("Default: ");
        this.wvap_manual_button = new JRadioButton("Manual: ");
        this.wvap_default_label = new JLabel("(" + this.globals.getWvapDefaultMin() + " to " + this.globals.getWvapDefaultMax() + ")");
        this.wvap_min_field = new JTextField("" + this.globals.getWvapManualMin(), 5);
        this.wvap_max_field = new JTextField("" + this.globals.getWvapManualMax(), 5);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.wvap_auto_button);
        buttonGroup3.add(this.wvap_default_button);
        buttonGroup3.add(this.wvap_manual_button);
        this.wvap_ignore_box = new JCheckBox("Ignore values outside of min/max");
        jPanel12.add(new JLabel("Min/Max Data Range:"));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new FlowLayout(0));
        jPanel13.add(new JLabel("    "));
        jPanel13.add(this.wvap_auto_button);
        jPanel12.add(jPanel13);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new FlowLayout(0));
        jPanel14.add(new JLabel("    "));
        jPanel14.add(this.wvap_default_button);
        jPanel14.add(this.wvap_default_label);
        jPanel12.add(jPanel14);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new FlowLayout(0));
        jPanel15.add(new JLabel("    "));
        jPanel15.add(this.wvap_manual_button);
        jPanel15.add(this.wvap_min_field);
        jPanel15.add(this.wvap_max_field);
        jPanel12.add(jPanel15);
        jPanel12.add(this.wvap_ignore_box);
        if (this.globals.getWvapMinMaxOption() == 0) {
            this.wvap_auto_button.setSelected(true);
            this.wvap_ignore_box.setEnabled(false);
        } else if (this.globals.getWvapMinMaxOption() == 1) {
            this.wvap_default_button.setSelected(true);
            this.wvap_ignore_box.setEnabled(true);
        } else {
            this.wvap_manual_button.setSelected(true);
            this.wvap_ignore_box.setEnabled(true);
        }
        this.wvap_ignore_box.setSelected(this.globals.getWvapIgnoreExtremes());
        this.wvap_auto_button.addActionListener(this);
        this.wvap_default_button.addActionListener(this);
        this.wvap_manual_button.addActionListener(this);
        jPanel3.add(jPanel12);
        jPanel2.add(jPanel3);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new StackLayout());
        jPanel16.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.line_thickness_slider = new JSlider(0, 0, 10, 0);
        this.line_thickness_slider.setMajorTickSpacing(1);
        this.line_thickness_slider.setPaintTicks(true);
        this.line_thickness_slider.setPaintLabels(true);
        this.line_thickness_slider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("A"));
        hashtable.put(new Integer(1), new JLabel("1"));
        hashtable.put(new Integer(5), new JLabel("5"));
        hashtable.put(new Integer(10), new JLabel("10"));
        this.line_thickness_slider.setLabelTable(hashtable);
        this.line_thickness_slider.setValue(this.globals.getLineThickness());
        JPanel jPanel17 = new JPanel();
        jPanel17.add(new JLabel("Line Thickness:"));
        jPanel17.add(this.line_thickness_slider);
        jPanel16.add(jPanel17);
        this.show_data_points_box = new JCheckBox("Show Data Points");
        this.show_data_points_box.setSelected(this.globals.getShowDataPoints());
        jPanel16.add(this.show_data_points_box);
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new StackLayout());
        jPanel18.setBorder(BorderFactory.createTitledBorder("Starting / Ending Dates"));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new GridLayout(1, 2));
        this.start_date_panel = new DateChooserPanel(this.globals.getEarliestDataDate(), this.globals.getLatestDataDate(), this.globals.getCurrentStartDate());
        this.start_date_panel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.end_date_panel = new DateChooserPanel(this.globals.getEarliestDataDate(), this.globals.getLatestDataDate(), this.globals.getCurrentEndDate());
        this.end_date_panel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        jPanel19.add(this.start_date_panel);
        jPanel19.add(this.end_date_panel);
        this.reset_dates_button = new JButton("Reset Dates");
        this.reset_dates_button.addActionListener(this);
        JPanel jPanel20 = new JPanel();
        jPanel20.add(this.reset_dates_button);
        jPanel18.add(jPanel19);
        jPanel18.add(jPanel20);
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel21.add(jPanel16);
        jPanel21.add(jPanel18);
        jPanel2.add(jPanel21);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == this.sample_size_auto_button) {
                this.sample_size_ignore_box.setEnabled(false);
            } else if (jRadioButton == this.sample_size_default_button) {
                this.sample_size_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.sample_size_manual_button) {
                this.sample_size_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.temp_auto_button) {
                this.temp_ignore_box.setEnabled(false);
            } else if (jRadioButton == this.temp_default_button) {
                this.temp_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.temp_manual_button) {
                this.temp_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.wvap_auto_button) {
                this.wvap_ignore_box.setEnabled(false);
            } else if (jRadioButton == this.wvap_default_button) {
                this.wvap_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.wvap_manual_button) {
                this.wvap_ignore_box.setEnabled(true);
            }
        } else if (actionEvent.getSource() instanceof JButton) {
            if ((JButton)actionEvent.getSource() == this.ok_button) {
                boolean bl = this.checkTextValues();
                if (bl) {
                    this.updateGlobalValues();
                    this.ok_button_pressed = true;
                    this.setVisible(false);
                }
            } else if ((JButton)actionEvent.getSource() == this.cancel_button) {
                this.ok_button_pressed = false;
                this.setVisible(false);
            } else if ((JButton)actionEvent.getSource() == this.reset_dates_button) {
                this.resetDates();
            }
        }
    }

    private boolean checkTextValues() {
        Float f;
        float f2;
        float f3;
        boolean bl = true;
        if (this.sample_size_manual_button.isSelected()) {
            f3 = -32768.0f;
            f2 = -32768.0f;
            try {
                f = new Float(this.sample_size_min_field.getText());
                f3 = f.floatValue();
                this.sample_size_min_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.sample_size_min_field.setBackground(Color.red);
                bl = false;
            }
            try {
                f = new Float(this.sample_size_max_field.getText());
                f2 = f.floatValue();
                this.sample_size_max_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.sample_size_max_field.setBackground(Color.red);
                bl = false;
            }
            if (bl && f3 >= f2) {
                this.sample_size_min_field.setBackground(Color.red);
                this.sample_size_max_field.setBackground(Color.red);
                bl = false;
            }
        }
        if (this.temp_manual_button.isSelected()) {
            f3 = -32768.0f;
            f2 = -32768.0f;
            try {
                f = new Float(this.temp_min_field.getText());
                f3 = f.floatValue();
                this.temp_min_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.temp_min_field.setBackground(Color.red);
                bl = false;
            }
            try {
                f = new Float(this.temp_max_field.getText());
                f2 = f.floatValue();
                this.temp_max_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.temp_max_field.setBackground(Color.red);
                bl = false;
            }
            if (bl && f3 >= f2) {
                this.temp_min_field.setBackground(Color.red);
                this.temp_max_field.setBackground(Color.red);
                bl = false;
            }
        }
        if (this.wvap_manual_button.isSelected()) {
            f3 = -32768.0f;
            f2 = -32768.0f;
            try {
                f = new Float(this.wvap_min_field.getText());
                f3 = f.floatValue();
                this.wvap_min_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.wvap_min_field.setBackground(Color.red);
                bl = false;
            }
            try {
                f = new Float(this.wvap_max_field.getText());
                f2 = f.floatValue();
                this.wvap_max_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.wvap_max_field.setBackground(Color.red);
                bl = false;
            }
            if (bl && f3 >= f2) {
                this.wvap_min_field.setBackground(Color.red);
                this.wvap_max_field.setBackground(Color.red);
                bl = false;
            }
        }
        return bl;
    }

    private void updateGlobalValues() {
        long l;
        float f;
        Float f2;
        if (this.sample_size_auto_button.isSelected()) {
            this.globals.setSampleSizeMinMaxOption(0);
        } else if (this.sample_size_default_button.isSelected()) {
            this.globals.setSampleSizeMinMaxOption(1);
        } else {
            this.globals.setSampleSizeMinMaxOption(2);
        }
        try {
            f2 = new Float(this.sample_size_min_field.getText());
            f = f2.floatValue();
            this.globals.setSampleSizeManualMin(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f2 = new Float(this.sample_size_max_field.getText());
            f = f2.floatValue();
            this.globals.setSampleSizeManualMax(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.globals.setSampleSizeIgnoreExtremes(this.sample_size_ignore_box.isSelected());
        if (this.temp_auto_button.isSelected()) {
            this.globals.setTempMinMaxOption(0);
        } else if (this.temp_default_button.isSelected()) {
            this.globals.setTempMinMaxOption(1);
        } else {
            this.globals.setTempMinMaxOption(2);
        }
        try {
            f2 = new Float(this.temp_min_field.getText());
            f = f2.floatValue();
            this.globals.setTempManualMin(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f2 = new Float(this.temp_max_field.getText());
            f = f2.floatValue();
            this.globals.setTempManualMax(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.globals.setTempIgnoreExtremes(this.temp_ignore_box.isSelected());
        if (this.wvap_auto_button.isSelected()) {
            this.globals.setWvapMinMaxOption(0);
        } else if (this.wvap_default_button.isSelected()) {
            this.globals.setWvapMinMaxOption(1);
        } else {
            this.globals.setWvapMinMaxOption(2);
        }
        try {
            f2 = new Float(this.wvap_min_field.getText());
            f = f2.floatValue();
            this.globals.setWvapManualMin(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f2 = new Float(this.wvap_max_field.getText());
            f = f2.floatValue();
            this.globals.setWvapManualMax(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.globals.setWvapIgnoreExtremes(this.wvap_ignore_box.isSelected());
        long l2 = this.start_date_panel.getSelectedDate();
        long l3 = this.end_date_panel.getSelectedDate();
        if (l2 > l3) {
            l = l2;
            l2 = l3;
            l3 = l;
        }
        l = this.globals.getEarliestDataDate();
        long l4 = this.globals.getLatestDataDate();
        l2 = Math.max(l2, l);
        l3 = Math.min(l3, l4);
        this.globals.setCurrentStartDate(l2);
        this.globals.setCurrentEndDate(l3);
        this.globals.setLineThickness(this.line_thickness_slider.getValue());
        this.globals.setShowDataPoints(this.show_data_points_box.isSelected());
    }

    public void resetDates() {
        this.start_date_panel.setDate(this.globals.getEarliestDataDate());
        this.end_date_panel.setDate(this.globals.getLatestDataDate());
    }

    public boolean okButtonPressed() {
        return this.ok_button_pressed;
    }
}

