/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImageSizeDialog
extends JDialog
implements ActionListener {
    private JButton saveButton;
    private JButton cancelButton;
    private JButton sizeButton0;
    private JButton sizeButton1;
    private JButton sizeButton2;
    private JButton sizeButton3;
    private JButton sizeButton4;
    private JButton sizeButton5;
    private JButton sizeButton6;
    private JLabel currentsizeLabel;
    private JTextField newwidthField;
    private JTextField newheightField;
    private JCheckBox aspectratioBox;
    private int current_width;
    private int current_height;
    private int most_recent_width;
    private int most_recent_height;
    private double aspect_ratio;

    public ImageSizeDialog(JFrame jFrame, Dimension dimension) {
        super(jFrame, "Select Image Size", true);
        this.getContentPane().setLayout(new BorderLayout());
        this.current_width = dimension.width;
        this.current_height = dimension.height;
        this.aspect_ratio = (double)dimension.height / (double)dimension.width;
        this.most_recent_width = dimension.width;
        this.most_recent_height = dimension.height;
        JPanel jPanel = new JPanel();
        this.saveButton = new JButton("Save...");
        jPanel.add(this.saveButton);
        this.cancelButton = new JButton("Cancel");
        jPanel.add(this.cancelButton);
        this.getContentPane().add("South", jPanel);
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.saveButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 3, 2, 2));
        this.sizeButton0 = new JButton("Current");
        this.sizeButton1 = new JButton("200 x 400");
        this.sizeButton2 = new JButton("400 x 600");
        this.sizeButton3 = new JButton("600 x 800");
        this.sizeButton4 = new JButton("800 x 1000");
        this.sizeButton5 = new JButton("1000 x 1200");
        this.sizeButton6 = new JButton("1200 x 1400");
        this.currentsizeLabel = new JLabel("" + this.current_width + " x " + this.current_height);
        this.currentsizeLabel.setForeground(Color.black);
        this.currentsizeLabel.setHorizontalAlignment(0);
        jPanel2.add(this.sizeButton0);
        jPanel2.add(this.currentsizeLabel);
        jPanel2.add(new JLabel(""));
        jPanel2.add(this.sizeButton1);
        jPanel2.add(this.sizeButton2);
        jPanel2.add(this.sizeButton3);
        jPanel2.add(this.sizeButton4);
        jPanel2.add(this.sizeButton5);
        jPanel2.add(this.sizeButton6);
        this.getContentPane().add("North", jPanel2);
        this.sizeButton0.addActionListener(this);
        this.sizeButton1.addActionListener(this);
        this.sizeButton2.addActionListener(this);
        this.sizeButton3.addActionListener(this);
        this.sizeButton4.addActionListener(this);
        this.sizeButton5.addActionListener(this);
        this.sizeButton6.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel("New Size: ");
        jLabel.setForeground(Color.black);
        jPanel4.add(jLabel);
        this.newwidthField = new JTextField("" + this.current_width, 6);
        jPanel4.add(this.newwidthField);
        jPanel4.add(new JLabel(" x "));
        this.newheightField = new JTextField("" + this.current_height, 6);
        jPanel4.add(this.newheightField);
        jPanel3.add(jPanel4);
        this.newwidthField.addActionListener(this);
        this.newheightField.addActionListener(this);
        this.aspectratioBox = new JCheckBox("Preserve Aspect Ratio", true);
        jPanel3.add(this.aspectratioBox);
        this.getContentPane().add("Center", jPanel3);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            if ((JButton)actionEvent.getSource() == this.saveButton) {
                this.setVisible(false);
            } else if ((JButton)actionEvent.getSource() == this.cancelButton) {
                this.newwidthField.setText("-1");
                this.newheightField.setText("-1");
                this.setVisible(false);
            } else if ((JButton)actionEvent.getSource() == this.sizeButton0) {
                this.setNewSize(this.current_width, this.current_height, false);
            } else if ((JButton)actionEvent.getSource() == this.sizeButton1) {
                this.setNewSize(200, 400, false);
            } else if ((JButton)actionEvent.getSource() == this.sizeButton2) {
                this.setNewSize(400, 600, false);
            } else if ((JButton)actionEvent.getSource() == this.sizeButton3) {
                this.setNewSize(600, 800, false);
            } else if ((JButton)actionEvent.getSource() == this.sizeButton4) {
                this.setNewSize(800, 1000, false);
            } else if ((JButton)actionEvent.getSource() == this.sizeButton5) {
                this.setNewSize(1000, 1200, false);
            } else if ((JButton)actionEvent.getSource() == this.sizeButton6) {
                this.setNewSize(1200, 1400, false);
            }
        } else if (actionEvent.getSource() instanceof JTextField) {
            if ((JTextField)actionEvent.getSource() == this.newwidthField) {
                try {
                    Integer n = new Integer(this.newwidthField.getText());
                    int n2 = n;
                    this.setNewSize(n2, this.most_recent_height, false);
                }
                catch (NumberFormatException numberFormatException) {
                    this.newwidthField.setText("" + this.most_recent_width);
                }
            } else if ((JTextField)actionEvent.getSource() == this.newheightField) {
                try {
                    Integer n = new Integer(this.newheightField.getText());
                    int n3 = n;
                    this.setNewSize(this.most_recent_width, n3, true);
                }
                catch (NumberFormatException numberFormatException) {
                    this.newheightField.setText("" + this.most_recent_height);
                }
            }
        }
    }

    private void setNewSize(int n, int n2, boolean bl) {
        if (this.aspectratioBox.isSelected()) {
            if (bl) {
                this.most_recent_height = n2;
                this.most_recent_width = (int)((double)n / this.aspect_ratio);
            } else {
                this.most_recent_width = n;
                this.most_recent_height = (int)((double)n * this.aspect_ratio);
            }
        } else {
            this.most_recent_width = n;
            this.most_recent_height = n2;
        }
        this.newwidthField.setText("" + this.most_recent_width);
        this.newheightField.setText("" + this.most_recent_height);
    }

    public Dimension getChosenSize() {
        Serializable serializable;
        int n = this.most_recent_width;
        int n2 = this.most_recent_height;
        try {
            serializable = new Integer(this.newwidthField.getText());
            int n3 = (Integer)serializable;
            serializable = new Integer(this.newheightField.getText());
            int n4 = (Integer)serializable;
            n = n3;
            n2 = n4;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        serializable = new Dimension(n, n2);
        return serializable;
    }
}

