/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LineSettingsDialog
extends JDialog
implements ActionListener {
    private JButton ok_button;
    private JButton cancel_button;
    private JButton reset_button;
    private JComboBox profile_list;
    private JTextField line_color_field;
    private JButton line_color_button;
    private JComboBox line_thickness_list;
    private JComboBox line_style_list;
    private boolean ok_button_pressed;
    private Vector profile_vector;
    private String[] profile_descriptions;
    private Color[] current_colors;
    private int[] current_thicknesses;
    private int[] current_styles;

    public LineSettingsDialog(JFrame jFrame, Vector vector) {
        super(jFrame, "Change Graph Lines", true);
        this.profile_vector = vector;
        this.extractProfileSettings();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 5));
        this.ok_button = new JButton("OK");
        this.cancel_button = new JButton("Cancel");
        this.reset_button = new JButton("Reset");
        jPanel.add(this.reset_button);
        jPanel.add(new JLabel(" "));
        jPanel.add(new JLabel(" "));
        jPanel.add(this.ok_button);
        jPanel.add(this.cancel_button);
        this.getRootPane().setDefaultButton(this.ok_button);
        this.getContentPane().add((Component)jPanel, "South");
        this.ok_button.addActionListener(this);
        this.cancel_button.addActionListener(this);
        this.reset_button.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new StackLayout());
        this.profile_list = new JComboBox<String>(this.profile_descriptions);
        this.profile_list.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.profile_list);
        jPanel2.add(jPanel3);
        this.line_color_field = new JTextField(3);
        this.line_color_field.setEditable(false);
        this.line_color_button = new JButton("Pick Color");
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel("Line Color:"));
        jPanel4.add(this.line_color_field);
        jPanel4.add(this.line_color_button);
        jPanel2.add(jPanel4);
        this.line_color_button.addActionListener(this);
        String[] stringArray = new String[]{"auto", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        this.line_thickness_list = new JComboBox<String>(stringArray);
        this.line_thickness_list.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(new JLabel("Line Thickness:"));
        jPanel5.add(this.line_thickness_list);
        jPanel2.add(jPanel5);
        String[] stringArray2 = new String[]{"Solid", "Short Dash", "Long Dash", "Dots", "Short Long", "Diamonds"};
        this.line_style_list = new JComboBox<String>(stringArray2);
        this.line_style_list.addActionListener(this);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(new JLabel("Line Style:"));
        jPanel6.add(this.line_style_list);
        jPanel2.add(jPanel6);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.setControls();
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox == this.profile_list) {
                this.setControls();
            } else if (jComboBox == this.line_thickness_list) {
                this.current_thicknesses[this.profile_list.getSelectedIndex()] = this.line_thickness_list.getSelectedIndex();
            } else if (jComboBox == this.line_style_list) {
                this.current_styles[this.profile_list.getSelectedIndex()] = this.line_style_list.getSelectedIndex();
            }
        } else if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.ok_button) {
                this.changeProfileSettings();
                this.ok_button_pressed = true;
                this.setVisible(false);
            } else if (jButton == this.cancel_button) {
                this.ok_button_pressed = false;
                this.setVisible(false);
            } else if (jButton == this.reset_button) {
                this.resetLineSettings();
            } else if (jButton == this.line_color_button) {
                this.pickColor();
            }
        }
    }

    private void extractProfileSettings() {
        this.profile_descriptions = new String[this.profile_vector.size()];
        this.current_colors = new Color[this.profile_vector.size()];
        this.current_thicknesses = new int[this.profile_vector.size()];
        this.current_styles = new int[this.profile_vector.size()];
        String[] stringArray = new String[]{"Bias", "Std Dev", "Sample Size"};
        String[] stringArray2 = new String[]{"Pass", "Fail", "Pass/Fail"};
        String[] stringArray3 = new String[]{"Sea", "Nonsea", "Sea/Nonsea"};
        String[] stringArray4 = new String[]{"Clear", "Cloudy", "Clear/Cloudy"};
        for (int i = 0; i < this.profile_vector.size(); ++i) {
            NarcsDataProfile narcsDataProfile = (NarcsDataProfile)this.profile_vector.elementAt(i);
            String string = narcsDataProfile.getLabel();
            int n = narcsDataProfile.getStatType();
            int n2 = narcsDataProfile.getQCType();
            int n3 = narcsDataProfile.getTerrainType();
            int n4 = narcsDataProfile.getCloudType();
            this.profile_descriptions[i] = string + "  " + "  " + stringArray2[n2] + "  " + stringArray3[n3] + "  " + stringArray4[n4] + "  " + stringArray[n];
            this.current_colors[i] = narcsDataProfile.getLineColor();
            this.current_thicknesses[i] = narcsDataProfile.getLineThickness();
            this.current_styles[i] = narcsDataProfile.getLineStyle();
        }
    }

    private void setControls() {
        int n = this.profile_list.getSelectedIndex();
        this.line_color_field.setBackground(this.current_colors[n]);
        this.line_thickness_list.setSelectedIndex(this.current_thicknesses[n]);
        this.line_style_list.setSelectedIndex(this.current_styles[n]);
    }

    private void pickColor() {
        Color color = this.line_color_field.getBackground();
        JFrame jFrame = new JFrame();
        Color color2 = JColorChooser.showDialog(jFrame, "Choose Line Color", color);
        this.line_color_field.setBackground(color2);
        this.current_colors[this.profile_list.getSelectedIndex()] = color2;
    }

    private void resetLineSettings() {
        for (int i = 0; i < this.profile_vector.size(); ++i) {
            NarcsDataProfile narcsDataProfile = (NarcsDataProfile)this.profile_vector.elementAt(i);
            this.current_colors[i] = narcsDataProfile.getDefaultLineColor();
            this.current_thicknesses[i] = narcsDataProfile.getDefaultLineThickness();
            this.current_styles[i] = narcsDataProfile.getDefaultLineStyle();
        }
        this.setControls();
    }

    private void changeProfileSettings() {
        for (int i = 0; i < this.profile_vector.size(); ++i) {
            NarcsDataProfile narcsDataProfile = (NarcsDataProfile)this.profile_vector.elementAt(i);
            narcsDataProfile.setLineColor(this.current_colors[i]);
            narcsDataProfile.setLineThickness(this.current_thicknesses[i]);
            narcsDataProfile.setLineStyle(this.current_styles[i]);
            this.profile_vector.setElementAt(narcsDataProfile, i);
        }
    }

    public boolean okButtonPressed() {
        return this.ok_button_pressed;
    }

    public Vector getProfiles() {
        return this.profile_vector;
    }
}

