/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NARCS
extends JFrame
implements ActionListener,
ChangeListener,
Printable {
    static final JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu file_menu;
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miClose;
    protected JMenuItem miSave;
    protected JMenuItem miPageSetup;
    protected JMenuItem miPrintPreview;
    protected JMenuItem miPrint;
    protected JMenuItem miQuit;
    protected JMenu graph_menu;
    protected JMenuItem miChangeLines;
    protected JMenu help_menu;
    protected JMenuItem miAbout;
    private JTabbedPane tabbed_pane;
    private SampleSizePanel sample_size_panel;
    private StatPanel[] stat_panel;
    private String file_name;
    private int header_length;
    private int num_records;
    private int num_level_blocks;
    private int[] level_type;
    private float[] level_pressure;
    private String[] level_description;
    private int num_data_groups;
    private int max_data_groups;
    private int[] data_group_order;
    private int[] data_group_id;
    private String[] data_group_description;
    private PageFormat page_format;
    private NarcsGlobals globals;
    private final String version = "1.4.0";
    private final String date = "Feburary 9, 2010";

    public static void main(String[] stringArray) {
        NARCS nARCS = new NARCS();
    }

    public NARCS() {
        this.setTitle("NPROVS Archive Summary (NARCS):  version 1.4.0");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.globals = new NarcsGlobals();
        this.addMenus();
        int n = (int)((double)dimension.width * 0.9);
        int n2 = (int)((double)dimension.height * 0.9);
        int n3 = 0;
        int n4 = 0;
        this.setBounds(n3, n4, n, n2);
        this.getContentPane().setLayout(new BorderLayout());
        this.tabbed_pane = new JTabbedPane();
        this.tabbed_pane.addChangeListener(this);
        this.getContentPane().add(this.tabbed_pane);
        this.setVisible(true);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NARCS.this.setVisible(false);
                NARCS.this.handleQuit();
            }
        };
        this.addWindowListener(windowAdapter);
        this.lookForDataFile();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.miOpen.getActionCommand())) {
            this.openFile();
        } else if (actionEvent.getActionCommand().equals(this.miSave.getActionCommand())) {
            this.saveImage();
        } else if (actionEvent.getActionCommand().equals(this.miPageSetup.getActionCommand())) {
            this.pageSetup();
        } else if (actionEvent.getActionCommand().equals(this.miPrintPreview.getActionCommand())) {
            this.printPreview();
        } else if (actionEvent.getActionCommand().equals(this.miPrint.getActionCommand())) {
            this.printImage();
        } else if (actionEvent.getActionCommand().equals(this.miQuit.getActionCommand())) {
            this.handleQuit();
        } else if (actionEvent.getActionCommand().equals(this.miChangeLines.getActionCommand())) {
            this.changeGraphLines();
        } else if (actionEvent.getActionCommand().equals(this.miAbout.getActionCommand())) {
            this.showAboutDialog();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabbed_pane) {
            int n = this.tabbed_pane.getSelectedIndex();
            if (n == 0) {
                this.sample_size_panel.panelSelected();
            } else {
                this.stat_panel[n - 1].panelSelected();
            }
        }
    }

    private void openFile() {
        this.file_name = "summary_file.dat";
        String string = System.getProperty("user.dir");
        JFileChooser jFileChooser = new JFileChooser();
        String string2 = System.getProperty("user.dir");
        jFileChooser.setCurrentDirectory(new File(string2));
        Dimension dimension = new Dimension(700, 400);
        jFileChooser.setMinimumSize(dimension);
        jFileChooser.setPreferredSize(dimension);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string3;
            this.file_name = jFileChooser.getSelectedFile().getName();
            string = jFileChooser.getCurrentDirectory().getPath();
            if (!string.endsWith(string3 = System.getProperty("file.separator"))) {
                string = string + string3;
            }
            try {
                this.file_name = string + this.file_name;
                this.readFileHeader();
            }
            catch (Exception exception) {
                String string4 = "An error occurred while trying to open the file: " + this.file_name;
                System.out.println(string4 + "\n");
                exception.printStackTrace();
            }
        }
    }

    private void readFileHeader() {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.tabbed_pane.removeChangeListener(this);
        if (this.tabbed_pane.getTabCount() > 0) {
            this.tabbed_pane.removeAll();
        }
        this.sample_size_panel = null;
        if (this.stat_panel != null) {
            for (int i = 0; i < this.stat_panel.length; ++i) {
                this.stat_panel[i] = null;
            }
        }
        this.stat_panel = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            FileInputStream fileInputStream = new FileInputStream(this.file_name);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            int n5 = dataInputStream.readInt();
            float f = (float)dataInputStream.readInt() / 10.0f;
            this.header_length = dataInputStream.readInt();
            dataInputStream.skipBytes(20);
            this.num_records = dataInputStream.readInt();
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            dataInputStream.skipBytes(32);
            this.num_level_blocks = dataInputStream.readInt();
            this.stat_panel = new StatPanel[this.num_level_blocks];
            this.level_type = new int[this.num_level_blocks];
            this.level_pressure = new float[this.num_level_blocks];
            this.level_description = new String[this.num_level_blocks];
            for (n4 = 0; n4 < this.num_level_blocks; ++n4) {
                this.level_type[n4] = dataInputStream.readInt();
                this.level_pressure[n4] = (float)dataInputStream.readInt() / 10.0f;
                this.level_description[n4] = "";
                for (n3 = 0; n3 < 36; ++n3) {
                    n2 = dataInputStream.readByte();
                    this.level_description[n4] = this.level_description[n4] + (char)n2;
                }
                this.level_description[n4] = this.level_description[n4].trim();
            }
            this.max_data_groups = dataInputStream.readInt();
            this.num_data_groups = dataInputStream.readInt();
            this.data_group_order = new int[this.num_data_groups];
            for (n4 = 0; n4 < this.max_data_groups; ++n4) {
                n3 = dataInputStream.readInt();
                if (n4 >= this.num_data_groups) continue;
                this.data_group_order[n4] = n3;
            }
            this.data_group_id = new int[this.num_data_groups];
            this.data_group_description = new String[this.num_data_groups];
            for (n4 = 0; n4 < this.num_data_groups; ++n4) {
                this.data_group_id[n4] = dataInputStream.readInt();
                n3 = dataInputStream.readInt();
                this.data_group_description[n4] = "";
                for (n2 = 0; n2 < 36; ++n2) {
                    char c = (char)dataInputStream.readByte();
                    this.data_group_description[n4] = this.data_group_description[n4] + c;
                }
                this.data_group_description[n4] = this.data_group_description[n4].trim();
            }
            boolean[] blArray = new boolean[this.num_data_groups];
            blArray[0] = true;
            for (n3 = 1; n3 < this.num_data_groups; ++n3) {
                blArray[n3] = false;
            }
            this.globals.setDataGroupSelections(blArray);
            dataInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file_name, "r");
            long l = this.header_length;
            int n8 = 99999999;
            int n9 = -99999999;
            for (n = 0; n < this.num_records; ++n) {
                randomAccessFile.seek(l);
                int n10 = randomAccessFile.readInt();
                int n11 = randomAccessFile.readInt();
                int n12 = randomAccessFile.readInt();
                int n13 = n11 * 10000 + n12;
                n8 = Math.min(n8, n13);
                n9 = Math.max(n9, n13);
                l += (long)n10;
            }
            randomAccessFile.close();
            this.globals.setEarliestDataDate(n8);
            this.globals.setLatestDataDate(n9);
            this.globals.setCurrentStartDate(n8);
            this.globals.setCurrentEndDate(n9);
            this.globals.initializeLineSettings(this.num_data_groups);
            this.sample_size_panel = new SampleSizePanel(this, this.file_name, this.header_length, this.num_records, this.num_level_blocks, this.num_data_groups, this.data_group_id, this.data_group_description);
            this.tabbed_pane.addTab("Sample Size", this.sample_size_panel);
            for (n = 0; n < this.num_level_blocks; ++n) {
                this.stat_panel[n] = new StatPanel(this, this.file_name, n, this.level_type[n], this.level_pressure[n], this.level_description[n], this.header_length, this.num_records, this.num_level_blocks, this.num_data_groups, this.data_group_id, this.data_group_description);
                this.tabbed_pane.addTab(this.level_description[n], this.stat_panel[n]);
            }
            this.tabbed_pane.addChangeListener(this);
            if (this.tabbed_pane.getTabCount() >= 6) {
                this.tabbed_pane.setSelectedIndex(5);
            }
            this.miSave.setEnabled(true);
            this.miPageSetup.setEnabled(true);
            this.miPrintPreview.setEnabled(true);
            this.miPrint.setEnabled(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        this.setCursor(cursor);
    }

    private void handleQuit() {
        System.exit(0);
    }

    private void saveImage() {
        String string = "nprovs_summary_stats.jpg";
        String string2 = null;
        String string3 = System.getProperty("user.dir");
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        ImageSizeDialog imageSizeDialog = new ImageSizeDialog(null, dimension);
        imageSizeDialog.setLocationRelativeTo(this);
        imageSizeDialog.setVisible(true);
        dimension = imageSizeDialog.getChosenSize();
        if (dimension.width != -1) {
            n = dimension.width;
            n2 = dimension.height;
            JFileChooser jFileChooser = new JFileChooser();
            String string4 = System.getProperty("user.dir");
            jFileChooser.setCurrentDirectory(new File(string4));
            dimension = new Dimension(700, 400);
            jFileChooser.setMinimumSize(dimension);
            jFileChooser.setPreferredSize(dimension);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new ImageFileFilter("jpg"));
            jFileChooser.setFileFilter(new ImageFileFilter("png"));
            int n3 = jFileChooser.showSaveDialog(this);
            if (n3 == 0) {
                String string5;
                String string6 = jFileChooser.getFileFilter().getDescription().substring(2);
                if (!string6.equals("jpg") && !string6.equals("png")) {
                    string6 = "png";
                }
                string2 = jFileChooser.getSelectedFile().getName();
                string3 = jFileChooser.getCurrentDirectory().getPath();
                if (!string3.endsWith(string5 = System.getProperty("file.separator"))) {
                    string3 = string3 + string5;
                }
                try {
                    Cursor cursor = this.getCursor();
                    this.setCursor(new Cursor(3));
                    string = string3 + string2;
                    if (!string.endsWith("." + string6)) {
                        string = string + "." + string6;
                    }
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    this.makeImage(graphics2D, 0, 0, n, n2);
                    File file = new File(string);
                    ImageIO.write((RenderedImage)bufferedImage, string6, file);
                    graphics2D.dispose();
                    this.setCursor(cursor);
                    JOptionPane.showMessageDialog(null, "The image has been saved.", "Image Saved", 1);
                }
                catch (Exception exception) {
                    String string7 = "An error occurred while trying to save the image: " + string;
                    System.out.println(string7 + "\n");
                    exception.printStackTrace();
                }
            }
        }
    }

    private void pageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.page_format == null) {
            this.page_format = printerJob.defaultPage();
            this.page_format.setOrientation(0);
        }
        this.page_format = printerJob.pageDialog(this.page_format);
    }

    private void printPreview() {
        PrintPreviewDialog printPreviewDialog = new PrintPreviewDialog(this.makeBook());
        printPreviewDialog.setVisible(true);
    }

    private void printImage() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.page_format == null) {
            this.page_format = printerJob.defaultPage();
            this.page_format.setOrientation(0);
        }
        printerJob.setPageable(this.makeBook());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.black);
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        this.makeImage(graphics2D, 0, 0, n2, n3);
        return 0;
    }

    private Book makeBook() {
        Object object;
        if (this.page_format == null) {
            object = PrinterJob.getPrinterJob();
            this.page_format = ((PrinterJob)object).defaultPage();
            this.page_format.setOrientation(0);
        }
        object = new Book();
        NARCS nARCS = this;
        ((Book)object).append(nARCS, this.page_format, 1);
        return object;
    }

    private void makeImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = this.tabbed_pane.getSelectedIndex();
        if (n5 == 0) {
            this.sample_size_panel.makeImage(graphics2D, n, n2, n3, n4);
        } else {
            this.stat_panel[n5 - 1].makeImage(graphics2D, n, n2, n3, n4);
        }
    }

    private void changeGraphLines() {
        int n = this.tabbed_pane.getSelectedIndex();
        if (n == 0) {
            this.sample_size_panel.changeGraphLines();
        } else {
            this.stat_panel[n - 1].changeGraphLines();
        }
    }

    private void showAboutDialog() {
        String[] stringArray = new String[]{"Developed by Michael Pettey (IMSG)", "for NOAA/NESDIS"};
        AboutBox aboutBox = new AboutBox("NPROVS Archive Statistical Summary (NARCS)", "1.4.0", "Feburary 9, 2010", stringArray);
        aboutBox.setVisible(true);
    }

    private void lookForDataFile() {
        try {
            String string = "summary_file.dat";
            File file = new File(string);
            if (file.exists()) {
                this.file_name = string;
                this.readFileHeader();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addMenus() {
        this.file_menu = new JMenu("File");
        this.miNew = new JMenuItem("New");
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miNew);
        this.miNew.addActionListener(this);
        this.miOpen = new JMenuItem("Open");
        this.miOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miOpen).setEnabled(true);
        this.miOpen.addActionListener(this);
        this.miClose = new JMenuItem("Close");
        this.miClose.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miClose);
        this.miClose.addActionListener(this);
        this.miSave = new JMenuItem("Save Image");
        this.miSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miSave);
        this.miSave.addActionListener(this);
        this.file_menu.addSeparator();
        this.miPageSetup = new JMenuItem("Page Setup");
        this.file_menu.add(this.miPageSetup);
        this.miPageSetup.addActionListener(this);
        this.miPrintPreview = new JMenuItem("Print Preview");
        this.file_menu.add(this.miPrintPreview);
        this.miPrintPreview.addActionListener(this);
        this.miPrint = new JMenuItem("Print");
        this.miPrint.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miPrint);
        this.miPrint.addActionListener(this);
        this.file_menu.addSeparator();
        this.miQuit = new JMenuItem("Quit");
        this.miQuit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miQuit).setEnabled(true);
        this.miQuit.addActionListener(this);
        mainMenuBar.add(this.file_menu);
        this.miNew.setEnabled(false);
        this.miClose.setEnabled(false);
        this.miSave.setEnabled(false);
        this.miPageSetup.setEnabled(false);
        this.miPrintPreview.setEnabled(false);
        this.miPrint.setEnabled(false);
        this.graph_menu = new JMenu("Graph");
        this.miChangeLines = new JMenuItem("Change Lines...");
        this.miChangeLines.addActionListener(this);
        this.graph_menu.add(this.miChangeLines).setEnabled(true);
        mainMenuBar.add(this.graph_menu);
        this.help_menu = new JMenu("Help");
        this.miAbout = new JMenuItem("About NARCS...");
        this.miAbout.addActionListener(this);
        this.help_menu.add(this.miAbout).setEnabled(true);
        mainMenuBar.add(this.help_menu);
        this.setJMenuBar(mainMenuBar);
    }
}

