/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.JPanel;

public class SampleSizeGraph
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int width;
    private int height;
    private Image offscreen_image;
    private Color[] colors;
    private String file_name;
    private boolean data_available;
    private boolean[] show_group;
    private boolean show_total;
    private boolean show_passed_qc;
    private long[] dates;
    private int[] num_00z;
    private int[] num_06z;
    private int[] num_12z;
    private int[] num_18z;
    private int[][] group_sample_size;
    private int[][] group_qc_sample_size;
    private int[][] total_counts;
    private int[][] total_qc_counts;
    private int min_count;
    private int max_count;
    private int number_of_x_points;
    private int[] from_record;
    private int[] to_record;
    private String[] date_string;
    private int mouse_start_x;
    private int mouse_start_y;
    private int mouse_end_x;
    private int mouse_end_y;
    private int[] date_x_locations;
    private int[] date_positions;
    private int[] current_dates;
    private int header_length;
    private int num_records;
    private int num_level_blocks;
    private int num_data_groups;
    private NarcsGlobals globals;

    public SampleSizeGraph(Color[] colorArray, String string, int n, int n2, int n3, int n4, boolean[] blArray, boolean bl, boolean bl2) {
        this.colors = colorArray;
        this.file_name = string;
        this.header_length = n;
        this.num_records = n2;
        this.num_level_blocks = n3;
        this.num_data_groups = n4;
        this.show_group = blArray;
        this.show_total = bl;
        this.show_passed_qc = bl2;
        this.globals = new NarcsGlobals();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.dates = null;
        this.num_00z = null;
        this.num_06z = null;
        this.num_12z = null;
        this.num_18z = null;
        this.group_sample_size = null;
        this.group_qc_sample_size = null;
        this.min_count = 0;
        this.max_count = 1000;
        this.offscreen_image = null;
        this.data_available = false;
        this.number_of_x_points = 0;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_start_x = mouseEvent.getX();
        this.mouse_start_y = mouseEvent.getY();
        this.mouse_end_x = mouseEvent.getX();
        this.mouse_end_y = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        int n = Math.abs(this.mouse_start_x - this.mouse_end_x);
        int n2 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        int n3 = Math.min(this.mouse_start_x, this.mouse_end_x);
        int n4 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n3, n4, n, n2);
        this.mouse_end_x = mouseEvent.getX();
        this.mouse_end_y = mouseEvent.getY();
        n = Math.abs(this.mouse_start_x - this.mouse_end_x);
        n2 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        n3 = Math.min(this.mouse_start_x, this.mouse_end_x);
        n4 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n3, n4, n, n2);
        graphics.dispose();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        int n3 = Math.abs(this.mouse_start_x - this.mouse_end_x);
        int n4 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        int n5 = Math.min(this.mouse_start_x, this.mouse_end_x);
        int n6 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n5, n6, n3, n4);
        graphics.dispose();
        if (n != this.mouse_start_x && n2 != this.mouse_start_y) {
            int n7 = Math.min(this.mouse_start_x, n);
            int n8 = Math.max(this.mouse_start_x, n);
            int n9 = Short.MIN_VALUE;
            int n10 = Short.MIN_VALUE;
            int n11 = 99999;
            int n12 = 99999;
            for (int i = 0; i < this.date_positions.length; ++i) {
                int n13;
                int n14 = Math.abs(this.date_positions[i] - n7);
                if (n14 < n11) {
                    n11 = n14;
                    n9 = i;
                }
                if ((n13 = Math.abs(this.date_positions[i] - n8)) >= n12) continue;
                n12 = n13;
                n10 = i;
            }
            n9 = Math.max(n9, 0);
            n10 = Math.min(n10, this.date_positions.length - 1);
            this.globals.setCurrentStartDate(this.current_dates[n9]);
            this.globals.setCurrentEndDate(this.current_dates[n10]);
            this.newTimeWindow();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.width = n3;
        this.height = n4;
        this.setPreferredSize(new Dimension(n3, n4));
        if (this.isVisible()) {
            this.offscreen_image = this.createImage(n3, n4);
            Graphics2D graphics2D = (Graphics2D)this.offscreen_image.getGraphics();
            this.drawGraph(graphics2D, 0, 0, n3, n4, true);
            graphics2D.dispose();
            this.paintComponent(this.getGraphics());
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing() && this.offscreen_image != null) {
            graphics.drawImage(this.offscreen_image, 0, 0, this.width, this.height, this);
        }
    }

    public void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawGraph(graphics2D, n, n2, n3, n4, false);
    }

    public void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        int n7 = 5;
        int n8 = (int)((float)n4 * 0.05f);
        int n9 = (int)((float)(n3 - n7 * 2) * 0.1f);
        int n10 = n3 - n7 * 2 - n9;
        int n11 = (int)((float)(n4 - n7 * 2 - n8) * 0.15f);
        int n12 = n6 = n4 - n7 * 2 - n8 - n11;
        int n13 = n10;
        int n14 = n + n7;
        int n15 = n2 + n7 + n8;
        int n16 = n + n7 + n9;
        int n17 = n2 + n7 + n8 + n6;
        int n18 = n + n16;
        int n19 = n2 + n15;
        float f = (float)n10 / (float)(this.number_of_x_points + 2);
        this.date_x_locations = new int[this.number_of_x_points];
        for (n5 = 0; n5 < this.number_of_x_points; ++n5) {
            this.date_x_locations[n5] = (int)((float)(n5 + 1) * f);
        }
        if (bl) {
            this.date_positions = new int[this.number_of_x_points];
            for (n5 = 0; n5 < this.number_of_x_points; ++n5) {
                this.date_positions[n5] = this.date_x_locations[n5] + n9;
            }
        }
        this.drawLegend(graphics2D, n, n2, n3, n8);
        this.drawMainGraph(graphics2D, n18, n19, n10, n6);
        this.drawYAxis(graphics2D, n14, n15, n9, n12);
        this.drawXAxis(graphics2D, n16, n17, n13, n11);
    }

    private void drawLegend(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        String string = " ";
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("Serif", 0, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n4 - 2 || fontMetrics.stringWidth(string) >= n3 - 4) continue;
            bl = true;
        }
        int n6 = n + (n3 - fontMetrics.stringWidth(string)) / 2;
        int n7 = n2 + n4 - 2;
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n6, n7);
    }

    private void drawYAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        String string = "SAMPLE SIZE";
        String[] stringArray = new String[]{"" + this.min_count, "" + (this.min_count + (int)((float)(this.max_count - this.min_count) * 0.25f)), "" + (this.min_count + (this.max_count - this.min_count) / 2), "" + (this.min_count + (int)((float)(this.max_count - this.min_count) * 0.75f)), "" + this.max_count};
        int n7 = (int)((float)(n3 - 4) * 0.15f);
        int n8 = (int)((float)(n3 - 4) * 0.8f);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n9 = 25;
        boolean bl = false;
        while (!bl && n9 > 5) {
            bl = true;
            graphics2D.setFont(new Font("SansSerif", 0, --n9));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.stringWidth("M") > n7) {
                bl = false;
            }
            if (fontMetrics.getHeight() * string.length() > n4 - 4) {
                bl = false;
            }
            for (n6 = 0; n6 < stringArray.length; ++n6) {
                if (fontMetrics.stringWidth(stringArray[n6]) <= n8) continue;
                bl = false;
            }
        }
        n6 = 0;
        int n10 = 0;
        graphics2D.setColor(Color.black);
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            n6 = n + (n3 - 2);
            n10 = n2 + (n4 - (int)((float)n5 / (float)(stringArray.length - 1) * (float)n4));
            graphics2D.drawLine(n6, n10, n6 + 2, n10);
            n6 = n + (n3 - 2 - fontMetrics.stringWidth(stringArray[n5]));
            graphics2D.drawString(stringArray[n5], n6, n10 += fontMetrics.getAscent() / 2);
        }
        for (n5 = 0; n5 < string.length(); ++n5) {
            char c = string.charAt(n5);
            n6 = n + 2 + (fontMetrics.stringWidth("M") - fontMetrics.stringWidth("" + c) / 2);
            n10 = n2 + n4 / 2 - fontMetrics.getHeight() * string.length() / 2;
            n10 = n10 + n5 * fontMetrics.getHeight() + fontMetrics.getAscent();
            graphics2D.drawString("" + c, n6, n10);
        }
    }

    private void drawXAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("SansSerif", 0, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            bl = true;
            for (int i = 0; i < this.number_of_x_points; ++i) {
                if (fontMetrics.stringWidth(this.date_string[i]) <= n4 - 10) continue;
                bl = false;
            }
        }
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966));
        graphics2D.setFont(font2);
        int n6 = -999;
        for (int i = 0; i < this.number_of_x_points; ++i) {
            int n7 = n + this.date_x_locations[i];
            int n8 = n2 + 7 + fontMetrics.stringWidth(this.date_string[i]);
            int n9 = n7 + fontMetrics.getAscent() / 2;
            if (n9 > n6) {
                graphics2D.drawString(this.date_string[i], n9, n8);
                n6 = n9 + fontMetrics.getAscent();
            }
            graphics2D.drawLine(n7, n2, n7, n2 + 5);
        }
        graphics2D.setFont(font);
    }

    private void drawMainGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics2D.setClip(n, n2, n3, n4);
        Stroke stroke = graphics2D.getStroke();
        int n5 = this.globals.getLineThickness();
        if (n5 == 0) {
            n5 = n4 / 200;
        }
        BasicStroke basicStroke = new BasicStroke(n5, 0, 1);
        graphics2D.setStroke(basicStroke);
        int n6 = (int)((float)n5 + (float)n5 / 4.0f);
        n6 = Math.max(n6, 4);
        boolean bl = this.globals.getShowDataPoints();
        if (this.data_available) {
            Point point;
            int n7;
            int n8;
            Vector<Cloneable> vector;
            Vector vector2;
            int n9;
            int n10;
            boolean bl2 = this.globals.getSampleSizeIgnoreExtremes();
            for (n10 = 0; n10 < 5; ++n10) {
                if (!this.show_group[n10]) continue;
                n9 = 0;
                vector2 = new Vector();
                vector = new Vector<Cloneable>();
                for (n8 = 0; n8 < this.number_of_x_points; ++n8) {
                    if (this.total_counts[n8][n10] > 0) {
                        n9 = 1;
                    }
                    float f = (float)(this.total_counts[n8][n10] - this.min_count) / (float)(this.max_count - this.min_count);
                    if (bl2 && (this.total_counts[n8][n10] < this.min_count || this.total_counts[n8][n10] > this.max_count)) {
                        f = -32768.0f;
                    }
                    int n11 = Short.MIN_VALUE;
                    n7 = Short.MIN_VALUE;
                    if (f != -32768.0f) {
                        n11 = n2 + (n4 - (int)((float)n4 * f));
                        n7 = n + this.date_x_locations[n8];
                    }
                    if (n7 != Short.MIN_VALUE && n11 != Short.MIN_VALUE) {
                        if (n9 == 0) continue;
                        if (bl) {
                            graphics2D.fillOval(n7 - n6, n11 - n6, n6 * 2, n6 * 2);
                        }
                        point = new Point(n7, n11);
                        vector.add(point);
                        continue;
                    }
                    vector2.add(vector);
                    vector = new Vector<Cloneable>();
                }
                vector2.add(vector);
                graphics2D.setColor(this.colors[n10]);
                for (n8 = 0; n8 < vector2.size(); ++n8) {
                    vector = (Vector<Cloneable>)vector2.elementAt(n8);
                    int[] nArray = new int[vector.size()];
                    int[] nArray2 = new int[vector.size()];
                    for (n7 = 0; n7 < vector.size(); ++n7) {
                        point = (Point)vector.elementAt(n7);
                        nArray[n7] = point.x;
                        nArray2[n7] = point.y;
                    }
                    graphics2D.drawPolyline(nArray, nArray2, vector.size());
                }
            }
            for (n10 = 5; n10 < this.num_data_groups + 5; ++n10) {
                if (!this.show_group[n10] || !this.show_total) continue;
                n9 = 0;
                vector2 = new Vector();
                vector = new Vector();
                graphics2D.setColor(this.globals.getGroupColor(n10 - 5));
                for (n8 = 0; n8 < this.number_of_x_points; ++n8) {
                    if (this.total_counts[n8][n10] > 0) {
                        n9 = 1;
                    }
                    float f = (float)(this.total_counts[n8][n10] - this.min_count) / (float)(this.max_count - this.min_count);
                    if (bl2 && (this.total_counts[n8][n10] < this.min_count || this.total_counts[n8][n10] > this.max_count)) {
                        f = -32768.0f;
                    }
                    int n12 = Short.MIN_VALUE;
                    n7 = Short.MIN_VALUE;
                    if (f != -32768.0f) {
                        n12 = n2 + (n4 - (int)((float)n4 * f));
                        n7 = n + this.date_x_locations[n8];
                    }
                    if (n7 != Short.MIN_VALUE && n12 != Short.MIN_VALUE) {
                        if (n9 == 0) continue;
                        if (bl) {
                            graphics2D.fillOval(n7 - n6, n12 - n6, n6 * 2, n6 * 2);
                        }
                        point = new Point(n7, n12);
                        vector.add(point);
                        continue;
                    }
                    vector2.add(vector);
                    vector = new Vector();
                }
                vector2.add(vector);
                graphics2D.setColor(this.globals.getGroupColor(n10 - 5));
                for (n8 = 0; n8 < vector2.size(); ++n8) {
                    vector = (Vector<Cloneable>)vector2.elementAt(n8);
                    int[] nArray = new int[vector.size()];
                    int[] nArray3 = new int[vector.size()];
                    for (n7 = 0; n7 < vector.size(); ++n7) {
                        point = (Point)vector.elementAt(n7);
                        nArray[n7] = point.x;
                        nArray3[n7] = point.y;
                    }
                    graphics2D.drawPolyline(nArray, nArray3, vector.size());
                }
            }
            float[] fArray = new float[]{6.0f, 3.0f};
            basicStroke = new BasicStroke(n5, 0, 1, 5.0f, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
            for (n9 = 5; n9 < this.num_data_groups + 5; ++n9) {
                Point point2;
                int n13;
                int n14;
                if (!this.show_group[n9] || !this.show_passed_qc) continue;
                boolean bl3 = false;
                vector = new Vector<Cloneable>();
                Vector<Point> vector3 = new Vector<Point>();
                graphics2D.setColor(this.globals.getGroupColor(n9 - 5));
                for (n14 = 0; n14 < this.number_of_x_points; ++n14) {
                    if (this.total_qc_counts[n14][n9] > 0) {
                        bl3 = true;
                    }
                    float f = (float)(this.total_qc_counts[n14][n9] - this.min_count) / (float)(this.max_count - this.min_count);
                    if (bl2 && (this.total_qc_counts[n14][n9] < this.min_count || this.total_qc_counts[n14][n9] > this.max_count)) {
                        f = -32768.0f;
                    }
                    int n15 = Short.MIN_VALUE;
                    n13 = Short.MIN_VALUE;
                    if (f != -32768.0f) {
                        n15 = n2 + (n4 - (int)((float)n4 * f));
                        n13 = n + this.date_x_locations[n14];
                    }
                    if (n13 != Short.MIN_VALUE && n15 != Short.MIN_VALUE) {
                        if (!bl3) continue;
                        if (bl) {
                            graphics2D.fillOval(n13 - n6, n15 - n6, n6 * 2, n6 * 2);
                        }
                        point2 = new Point(n13, n15);
                        vector3.add(point2);
                        continue;
                    }
                    vector.add(vector3);
                    vector3 = new Vector<Point>();
                }
                vector.add(vector3);
                graphics2D.setColor(this.globals.getGroupColor(n9 - 5));
                for (n14 = 0; n14 < vector.size(); ++n14) {
                    vector3 = (Vector<Point>)vector.elementAt(n14);
                    int[] nArray = new int[vector3.size()];
                    int[] nArray4 = new int[vector3.size()];
                    for (n13 = 0; n13 < vector3.size(); ++n13) {
                        point2 = (Point)vector3.elementAt(n13);
                        nArray[n13] = point2.x;
                        nArray4[n13] = point2.y;
                    }
                    graphics2D.drawPolyline(nArray, nArray4, vector3.size());
                }
            }
        }
        graphics2D.setStroke(stroke);
        graphics2D.setClip(null);
    }

    private void readData() {
        try {
            this.dates = new long[this.num_records];
            this.num_00z = new int[this.num_records];
            this.num_06z = new int[this.num_records];
            this.num_12z = new int[this.num_records];
            this.num_18z = new int[this.num_records];
            this.group_sample_size = new int[this.num_data_groups][this.num_records];
            this.group_qc_sample_size = new int[this.num_data_groups][this.num_records];
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file_name, "r");
            long l = this.header_length;
            for (int i = 0; i < this.num_records; ++i) {
                randomAccessFile.seek(l);
                int n = randomAccessFile.readInt();
                int n2 = randomAccessFile.readInt();
                int n3 = randomAccessFile.readInt();
                this.dates[i] = n2 * 10000 + n3;
                int n4 = randomAccessFile.readInt();
                n4 = randomAccessFile.readInt();
                this.num_00z[i] = randomAccessFile.readInt();
                this.num_06z[i] = randomAccessFile.readInt();
                this.num_12z[i] = randomAccessFile.readInt();
                this.num_18z[i] = randomAccessFile.readInt();
                int n5 = randomAccessFile.readInt();
                for (int j = 0; j < n5; ++j) {
                    long l2 = l + 40L + (long)(j * (40 + this.num_level_blocks * 216));
                    randomAccessFile.seek(l2);
                    int n6 = randomAccessFile.readInt();
                    if (n6 == Short.MIN_VALUE) continue;
                    this.group_sample_size[n6][i] = randomAccessFile.readInt();
                    this.group_qc_sample_size[n6][i] = randomAccessFile.readInt();
                }
                l += (long)n;
            }
            randomAccessFile.close();
            this.data_available = true;
            this.calculateDateIntervals();
            this.combineDateStats();
            this.findMinMax();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void changeGraphLines() {
    }

    public void changeSettings(boolean[] blArray, boolean bl, boolean bl2) {
        this.show_group = blArray;
        this.show_total = bl;
        this.show_passed_qc = bl2;
        this.updateGraph();
    }

    public void newTimeWindow() {
        this.data_available = false;
        this.updateGraph();
    }

    public void updateGraph() {
        if (!this.data_available && this.file_name != null) {
            this.readData();
        }
        if (this.data_available && this.isVisible() && this.isValid()) {
            this.offscreen_image = this.createImage(this.width, this.height);
            Graphics2D graphics2D = (Graphics2D)this.offscreen_image.getGraphics();
            this.drawGraph(graphics2D, 0, 0, this.width, this.height, true);
            graphics2D.dispose();
            this.paintComponent(this.getGraphics());
        }
    }

    private void calculateDateIntervals() {
        block21: {
            int n;
            int n2;
            block22: {
                block20: {
                    long l = this.globals.getCurrentStartDate();
                    long l2 = this.globals.getCurrentEndDate();
                    n2 = 0;
                    for (n = this.dates.length - 1; n > 0 && l < this.dates[n]; --n) {
                    }
                    while (n2 < this.dates.length - 1 && l2 > this.dates[n2]) {
                        ++n2;
                    }
                    int n3 = n2 - n + 1;
                    if (this.globals.getTimeWindowOption() != 0) break block20;
                    this.number_of_x_points = n3;
                    this.from_record = new int[this.number_of_x_points];
                    this.to_record = new int[this.number_of_x_points];
                    this.date_string = new String[this.number_of_x_points];
                    this.current_dates = new int[this.number_of_x_points];
                    for (int i = 0; i < this.number_of_x_points; ++i) {
                        this.from_record[i] = n + i;
                        this.to_record[i] = n + i;
                        int n4 = (int)(this.dates[n + i] / 10000L);
                        int n5 = (int)(this.dates[n + i] % 10000L / 100L);
                        int n6 = (int)(this.dates[n + i] % 100L);
                        String string = "" + n4 % 100;
                        if (n4 % 100 < 10) {
                            string = "0" + string;
                        }
                        this.date_string[i] = "" + n5 + "/" + n6 + "/" + string;
                        this.current_dates[i] = n4 * 10000 + n5 * 100 + n6;
                    }
                    break block21;
                }
                if (this.globals.getTimeWindowOption() != 1) break block22;
                Calendar calendar = Calendar.getInstance();
                int n7 = (int)(this.dates[n] / 10000L);
                int n8 = (int)(this.dates[n] % 10000L / 100L) - 1;
                int n9 = (int)(this.dates[n] % 100L);
                calendar.set(n7, n8, n9);
                while (calendar.get(7) != 1) {
                    calendar.add(5, -1);
                }
                Calendar calendar2 = Calendar.getInstance();
                n7 = (int)(this.dates[n2] / 10000L);
                n8 = (int)(this.dates[n2] % 10000L / 100L) - 1;
                n9 = (int)(this.dates[n2] % 100L);
                calendar2.set(n7, n8, n9);
                while (calendar2.get(7) != 7) {
                    calendar2.add(5, 1);
                }
                this.number_of_x_points = 0;
                Calendar calendar3 = Calendar.getInstance();
                n7 = (int)(this.dates[n] / 10000L);
                n8 = (int)(this.dates[n] % 10000L / 100L) - 1;
                n9 = (int)(this.dates[n] % 100L);
                calendar3.set(n7, n8, n9);
                while (!calendar3.after(calendar2)) {
                    ++this.number_of_x_points;
                    calendar3.add(5, 7);
                }
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.date_string = new String[this.number_of_x_points];
                this.current_dates = new int[this.number_of_x_points];
                calendar3 = (Calendar)calendar.clone();
                int n10 = 0;
                while (calendar3.before(calendar2)) {
                    int n11 = calendar3.get(1);
                    int n12 = calendar3.get(2) + 1;
                    int n13 = calendar3.get(5);
                    int n14 = n11 * 10000 + n12 * 100 + n13;
                    String string = "" + n11 % 100;
                    if (n11 % 100 < 10) {
                        string = "0" + string;
                    }
                    calendar3.add(5, 6);
                    int n15 = calendar3.get(1);
                    int n16 = calendar3.get(2) + 1;
                    int n17 = calendar3.get(5);
                    int n18 = n15 * 10000 + n16 * 100 + n17;
                    String string2 = "" + n15 % 100;
                    if (n15 % 100 < 10) {
                        string2 = "0" + string2;
                    }
                    this.date_string[n10] = "" + n12 + "/" + n13 + "/" + string;
                    this.current_dates[n10] = n11 * 10000 + n12 * 100 + n13;
                    this.from_record[n10] = Short.MIN_VALUE;
                    this.to_record[n10] = Short.MIN_VALUE;
                    for (int i = 0; i < this.dates.length; ++i) {
                        if (this.dates[i] < (long)n14 || this.dates[i] > (long)n18) continue;
                        if (this.from_record[n10] == Short.MIN_VALUE) {
                            this.from_record[n10] = i;
                        }
                        this.to_record[n10] = i;
                    }
                    ++n10;
                    calendar3.add(5, 1);
                }
                break block21;
            }
            if (this.globals.getTimeWindowOption() != 2) break block21;
            int n19 = (int)(this.dates[n] / 100L);
            int n20 = (int)(this.dates[n2] / 100L);
            if (n19 == n20) {
                this.number_of_x_points = 1;
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.from_record[0] = n;
                this.to_record[0] = n2;
                this.date_string = new String[1];
                int n21 = n19 / 100;
                int n22 = n19 % 100;
                this.date_string[0] = "" + n22 + "/" + n21;
                this.current_dates = new int[1];
                this.current_dates[0] = n21 * 10000 + n22 * 100 + 1;
            } else {
                int n23;
                int n24;
                this.number_of_x_points = 0;
                int n25 = n19;
                while (n25 <= n20) {
                    n24 = n25 / 100;
                    n23 = n25 % 100;
                    if (++n23 > 12) {
                        n23 = 1;
                        ++n24;
                    }
                    n25 = n24 * 100 + n23;
                    ++this.number_of_x_points;
                }
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.date_string = new String[this.number_of_x_points];
                this.current_dates = new int[this.number_of_x_points];
                n25 = n19;
                n24 = 0;
                while (n25 <= n20) {
                    n23 = n25 / 100;
                    int n26 = n25 % 100;
                    this.from_record[n24] = Short.MIN_VALUE;
                    this.to_record[n24] = Short.MIN_VALUE;
                    for (int i = n; i <= n2; ++i) {
                        int n27 = (int)(this.dates[i] / 100L);
                        if (n27 != n25) continue;
                        if (this.from_record[n24] == Short.MIN_VALUE) {
                            this.from_record[n24] = i;
                        }
                        this.to_record[n24] = i;
                    }
                    this.date_string[n24] = "" + n26 + "/" + n23;
                    this.current_dates[n24] = n23 * 10000 + n26 * 100 + 1;
                    ++n24;
                    if (++n26 > 12) {
                        n26 = 1;
                        ++n23;
                    }
                    n25 = n23 * 100 + n26;
                }
            }
        }
    }

    private void combineDateStats() {
        this.total_counts = new int[this.number_of_x_points][5 + this.num_data_groups];
        this.total_qc_counts = new int[this.number_of_x_points][5 + this.num_data_groups];
        for (int i = 0; i < this.number_of_x_points; ++i) {
            int n;
            for (n = 0; n < 5 + this.num_data_groups; ++n) {
                this.total_counts[i][n] = 0;
                this.total_qc_counts[i][n] = 0;
            }
            for (n = this.from_record[i]; n <= this.to_record[i]; ++n) {
                this.total_counts[i][0] = this.total_counts[i][0] + this.num_00z[n] + this.num_06z[n] + this.num_12z[n] + this.num_18z[n];
                this.total_counts[i][1] = this.total_counts[i][1] + this.num_00z[n];
                this.total_counts[i][2] = this.total_counts[i][2] + this.num_06z[n];
                this.total_counts[i][3] = this.total_counts[i][3] + this.num_12z[n];
                this.total_counts[i][4] = this.total_counts[i][4] + this.num_18z[n];
                for (int j = 0; j < this.num_data_groups; ++j) {
                    this.total_counts[i][j + 5] = this.total_counts[i][j + 5] + this.group_sample_size[j][n];
                    this.total_qc_counts[i][j + 5] = this.total_qc_counts[i][j + 5] + this.group_qc_sample_size[j][n];
                }
            }
        }
    }

    private void findMinMax() {
        if (this.data_available) {
            if (this.globals.getSampleSizeMinMaxOption() == 2) {
                this.min_count = this.globals.getSampleSizeManualMin();
                this.max_count = this.globals.getSampleSizeManualMax();
            } else {
                int n;
                this.min_count = 9999999;
                this.max_count = -9999999;
                boolean[] blArray = new boolean[this.num_data_groups + 5];
                for (n = 0; n < blArray.length; ++n) {
                    blArray[n] = false;
                }
                for (n = 0; n < this.number_of_x_points; ++n) {
                    int n2;
                    for (n2 = 0; n2 < 5; ++n2) {
                        if (!this.show_group[n2] || !blArray[n2] && this.total_counts[n][n2] <= 0) continue;
                        blArray[n2] = true;
                        this.min_count = Math.min(this.min_count, this.total_counts[n][n2]);
                        this.max_count = Math.max(this.max_count, this.total_counts[n][n2]);
                    }
                    for (n2 = 5; n2 < this.num_data_groups + 5; ++n2) {
                        if (!this.show_group[n2]) continue;
                        if (this.show_total && (blArray[n2] || this.total_counts[n][n2] > 0)) {
                            blArray[n2] = true;
                            this.min_count = Math.min(this.min_count, this.total_counts[n][n2]);
                            this.max_count = Math.max(this.max_count, this.total_counts[n][n2]);
                        }
                        if (!this.show_passed_qc || !blArray[n2] && this.total_qc_counts[n][n2] <= 0) continue;
                        blArray[n2] = true;
                        this.min_count = Math.min(this.min_count, this.total_qc_counts[n][n2]);
                        this.max_count = Math.max(this.max_count, this.total_qc_counts[n][n2]);
                    }
                }
                if (this.min_count == 9999999) {
                    this.min_count = 0;
                }
                if (this.max_count == -9999999) {
                    this.max_count = 100;
                }
                if (this.globals.getSampleSizeMinMaxOption() == 1) {
                    this.min_count = 0;
                }
            }
        }
    }
}

