/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SampleSizePanel
extends JPanel
implements ActionListener {
    private NARCS parent;
    private SampleSizeGraph graph;
    private JRadioButton daily_button;
    private JRadioButton weekly_button;
    private JRadioButton monthly_button;
    private JCheckBox total_box;
    private JCheckBox passed_qc_box;
    private JCheckBox[] data_group_box;
    private JButton graph_options_button;
    private int[] data_group_id;
    private String[] data_group_description;
    private boolean ignore_events;
    private Color[] colors;
    private NarcsGlobals globals;

    public SampleSizePanel(NARCS nARCS, String string, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) {
        this.parent = nARCS;
        this.data_group_id = nArray;
        this.data_group_description = stringArray;
        this.globals = new NarcsGlobals();
        this.colors = new Color[5];
        this.colors[0] = Color.black;
        this.colors[1] = new Color(200, 200, 200);
        this.colors[2] = new Color(150, 150, 150);
        this.colors[3] = new Color(50, 50, 50);
        this.colors[4] = new Color(100, 100, 100);
        this.ignore_events = false;
        this.addControls(string, n, n2, n3, n4);
    }

    private void addControls(String string, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5;
        this.setLayout(new BorderLayout());
        this.data_group_box = new JCheckBox[n4 + 5];
        this.data_group_box[0] = new JCheckBox("Radiosonde");
        this.data_group_box[1] = new JCheckBox("     00z");
        this.data_group_box[2] = new JCheckBox("     06z");
        this.data_group_box[3] = new JCheckBox("     12z");
        this.data_group_box[4] = new JCheckBox("     18z");
        for (n5 = 0; n5 < n4; ++n5) {
            this.data_group_box[n5 + 5] = new JCheckBox(this.data_group_description[n5]);
        }
        for (n5 = 0; n5 < this.data_group_box.length; ++n5) {
            this.data_group_box[n5].addActionListener(this);
            Color color = Color.black;
            color = n5 < 5 ? this.colors[n5] : this.globals.getGroupColor(n5 - 5);
            this.data_group_box[n5].setForeground(color);
            this.data_group_box[n5].setBackground(Color.white);
            if (n5 != 0 && n5 != 5) continue;
            this.data_group_box[n5].setSelected(true);
        }
        this.data_group_box[0].setSelected(true);
        boolean[] blArray = this.globals.getDataGroupSelections();
        for (int i = 0; i < blArray.length; ++i) {
            this.data_group_box[i + 5].setSelected(blArray[i]);
        }
        ScrollingPanel scrollingPanel = new ScrollingPanel();
        scrollingPanel.setBackground(Color.white);
        scrollingPanel.setLayout(new StackLayout());
        for (int i = 0; i < this.data_group_box.length; ++i) {
            scrollingPanel.add(this.data_group_box[i]);
        }
        this.add((Component)scrollingPanel, "East");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.graph_options_button = new JButton("Graph Options");
        this.graph_options_button.addActionListener(this);
        jPanel.add(this.graph_options_button);
        jPanel.add(new JLabel("          "));
        this.daily_button = new JRadioButton("Daily");
        this.weekly_button = new JRadioButton("Weekly");
        this.monthly_button = new JRadioButton("Monthly");
        this.daily_button.addActionListener(this);
        this.weekly_button.addActionListener(this);
        this.monthly_button.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.daily_button);
        buttonGroup.add(this.weekly_button);
        buttonGroup.add(this.monthly_button);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel2.setLayout(new GridLayout(1, 3));
        jPanel2.add(this.daily_button);
        jPanel2.add(this.weekly_button);
        jPanel2.add(this.monthly_button);
        jPanel.add(jPanel2);
        jPanel.add(new JLabel("          "));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel3.setLayout(new GridLayout(1, 2));
        this.total_box = new JCheckBox("Total Sample Size");
        this.total_box.setSelected(true);
        this.total_box.addActionListener(this);
        jPanel3.add(this.total_box);
        this.passed_qc_box = new JCheckBox("Passed QC");
        this.passed_qc_box.setSelected(false);
        this.passed_qc_box.addActionListener(this);
        jPanel3.add(this.passed_qc_box);
        jPanel.add(jPanel3);
        this.add((Component)jPanel, "South");
        boolean[] blArray2 = new boolean[this.data_group_box.length];
        for (bl = false; bl < this.data_group_box.length; bl += 1) {
            blArray2[bl] = this.data_group_box[bl].isSelected();
        }
        bl = this.total_box.isSelected();
        boolean bl2 = this.passed_qc_box.isSelected();
        this.graph = new SampleSizeGraph(this.colors, string, n, n2, n3, n4, blArray2, bl, bl2);
        this.add((Component)this.graph, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.ignore_events) {
            if (actionEvent.getActionCommand().equals(this.graph_options_button.getActionCommand())) {
                this.changeGraphSettings();
            } else if (actionEvent.getActionCommand().equals(this.total_box.getActionCommand()) || actionEvent.getActionCommand().equals(this.passed_qc_box.getActionCommand())) {
                this.updateGraph();
            } else if (actionEvent.getActionCommand().equals(this.daily_button.getActionCommand()) || actionEvent.getActionCommand().equals(this.weekly_button.getActionCommand()) || actionEvent.getActionCommand().equals(this.monthly_button.getActionCommand())) {
                this.changeTimeWindow();
            } else {
                int n;
                boolean bl = false;
                boolean bl2 = false;
                for (n = 0; n < this.data_group_box.length; ++n) {
                    if (!actionEvent.getActionCommand().equals(this.data_group_box[n].getActionCommand())) continue;
                    bl = true;
                    bl2 = this.data_group_box[n].isSelected();
                }
                if (bl) {
                    if ((actionEvent.getModifiers() & 2) != 0) {
                        for (n = 0; n < this.data_group_box.length; ++n) {
                            this.ignore_events = true;
                            this.data_group_box[n].setSelected(bl2);
                            this.ignore_events = false;
                        }
                    }
                    boolean[] blArray = new boolean[this.data_group_box.length - 5];
                    for (int i = 0; i < this.data_group_box.length - 5; ++i) {
                        blArray[i] = this.data_group_box[i + 5].isSelected();
                    }
                    this.globals.setDataGroupSelections(blArray);
                    this.updateGraph();
                }
            }
        }
    }

    public void panelSelected() {
        this.ignore_events = true;
        if (this.globals.getTimeWindowOption() == 0) {
            this.daily_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 1) {
            this.weekly_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 2) {
            this.monthly_button.setSelected(true);
        }
        boolean[] blArray = this.globals.getDataGroupSelections();
        for (int i = 0; i < blArray.length; ++i) {
            this.data_group_box[i + 5].setSelected(blArray[i]);
        }
        this.ignore_events = false;
        this.updateGraph();
        this.changeTimeWindow();
    }

    private void updateGraph() {
        boolean bl;
        boolean[] blArray = new boolean[this.data_group_box.length];
        for (bl = false; bl < this.data_group_box.length; bl += 1) {
            blArray[bl] = this.data_group_box[bl].isSelected();
        }
        bl = this.total_box.isSelected();
        boolean bl2 = this.passed_qc_box.isSelected();
        this.graph.changeSettings(blArray, bl, bl2);
    }

    private void changeTimeWindow() {
        int n = 0;
        if (this.weekly_button.isSelected()) {
            n = 1;
        } else if (this.monthly_button.isSelected()) {
            n = 2;
        }
        this.globals.setTimeWindowOption(n);
        this.graph.newTimeWindow();
    }

    public void changeGraphSettings() {
        GraphOptionsDialog graphOptionsDialog = new GraphOptionsDialog(this.parent, 0);
        if (graphOptionsDialog.okButtonPressed()) {
            this.graph.newTimeWindow();
        }
    }

    public void changeGraphLines() {
        this.graph.changeGraphLines();
    }

    public void makeImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(Color.black);
        int n6 = (int)((float)n3 * 0.15f);
        int n7 = n3 - n6;
        int n8 = n + n7;
        graphics2D.setClip(n8, n2, n6, n4);
        int n9 = 46;
        graphics2D.setFont(new Font("Sans-Serif", 0, n9));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        boolean bl = false;
        while (!bl && n9 > 5) {
            bl = true;
            graphics2D.setFont(new Font("Sans-Serif", 0, --n9));
            fontMetrics = graphics2D.getFontMetrics();
            for (n5 = 0; n5 < this.data_group_box.length; ++n5) {
                String string;
                if (!this.data_group_box[n5].isSelected() || fontMetrics.stringWidth(string = this.data_group_box[n5].getText()) <= n6 - 4) continue;
                bl = false;
            }
        }
        n5 = n8 + 2;
        int n10 = n2 + (int)((float)n4 * 0.05f) + fontMetrics.getAscent();
        for (int i = 0; i < this.data_group_box.length; ++i) {
            if (!this.data_group_box[i].isSelected()) continue;
            String string = this.data_group_box[i].getText();
            Color color = this.data_group_box[i].getForeground();
            graphics2D.setColor(color);
            graphics2D.drawString(string, n5, n10 += fontMetrics.getHeight());
        }
        graphics2D.setClip(null);
        graphics2D.setClip(n, n2, n7, n4);
        this.graph.drawGraph(graphics2D, n, n2, n7, n4);
        graphics2D.setClip(null);
    }
}

