/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class StatGraph
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int width;
    private int height;
    private Image offscreen_image;
    private String file_name;
    private int level;
    private String level_description;
    private int level_type;
    private String[] group_description;
    private boolean data_available;
    private boolean show_bias;
    private boolean show_stddev;
    private boolean show_samplesize;
    private boolean[] show_group;
    private long[] dates;
    private NarcsDataProfile[][][][][] data_profile;
    private int min_count;
    private int max_count;
    private float min_stat;
    private float max_stat;
    private int min_max_option;
    private float default_min;
    private float default_max;
    private float manual_min;
    private float manual_max;
    private boolean ignore_extreme_values;
    private int number_of_x_points;
    private int[] from_record;
    private int[] to_record;
    private String[] date_string;
    private int mouse_start_x;
    private int mouse_start_y;
    private int mouse_end_x;
    private int mouse_end_y;
    private int[] date_x_locations;
    private int[] date_positions;
    private int[] current_dates;
    private int header_length;
    private int num_records;
    private int num_level_blocks;
    private int num_data_groups;
    private NarcsGlobals globals;
    private final int PASSED_QC = 0;
    private final int FAILED_QC = 1;
    private final int PASSED_AND_FAILED_QC = 2;
    private final int SEA = 0;
    private final int NONSEA = 1;
    private final int UNDEFINED = 2;
    private final int SEA_AND_NONSEA = 2;
    private final int CLEAR = 0;
    private final int CLOUDY = 1;
    private final int CLEAR_AND_CLOUDY = 2;
    private final int BIAS = 0;
    private final int STDDEV = 1;
    private final int SAMPLE_SIZE = 2;

    public StatGraph(String string, int n, String string2, int n2, int n3, int n4, int n5, int n6, String[] stringArray) {
        this.file_name = string;
        this.level = n;
        this.level_description = string2;
        this.level_type = n2;
        this.header_length = n3;
        this.num_records = n4;
        this.num_level_blocks = n5;
        this.num_data_groups = n6;
        this.group_description = stringArray;
        this.globals = new NarcsGlobals();
        if (n2 == 0) {
            this.min_max_option = this.globals.getTempMinMaxOption();
            this.default_min = this.globals.getTempDefaultMin();
            this.default_max = this.globals.getTempDefaultMax();
            this.manual_min = this.globals.getTempManualMin();
            this.manual_max = this.globals.getTempManualMax();
            this.ignore_extreme_values = this.globals.getTempIgnoreExtremes();
        } else {
            this.level_description = this.level_description + "  (pct error)";
            this.min_max_option = this.globals.getWvapMinMaxOption();
            this.default_min = this.globals.getWvapDefaultMin();
            this.default_max = this.globals.getWvapDefaultMax();
            this.manual_min = this.globals.getWvapManualMin();
            this.manual_max = this.globals.getWvapManualMax();
            this.ignore_extreme_values = this.globals.getWvapIgnoreExtremes();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.offscreen_image = null;
        this.data_available = false;
        this.number_of_x_points = 0;
        this.dates = null;
        this.min_count = 0;
        this.max_count = 100;
        this.min_stat = -10.0f;
        this.max_stat = 10.0f;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_start_x = mouseEvent.getX();
        this.mouse_start_y = mouseEvent.getY();
        this.mouse_end_x = mouseEvent.getX();
        this.mouse_end_y = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        int n = Math.abs(this.mouse_start_x - this.mouse_end_x);
        int n2 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        int n3 = Math.min(this.mouse_start_x, this.mouse_end_x);
        int n4 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n3, n4, n, n2);
        this.mouse_end_x = mouseEvent.getX();
        this.mouse_end_y = mouseEvent.getY();
        n = Math.abs(this.mouse_start_x - this.mouse_end_x);
        n2 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        n3 = Math.min(this.mouse_start_x, this.mouse_end_x);
        n4 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n3, n4, n, n2);
        graphics.dispose();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        int n3 = Math.abs(this.mouse_start_x - this.mouse_end_x);
        int n4 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        int n5 = Math.min(this.mouse_start_x, this.mouse_end_x);
        int n6 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n5, n6, n3, n4);
        graphics.dispose();
        if (n != this.mouse_start_x && n2 != this.mouse_start_y) {
            int n7 = Math.min(this.mouse_start_x, n);
            int n8 = Math.max(this.mouse_start_x, n);
            int n9 = Short.MIN_VALUE;
            int n10 = Short.MIN_VALUE;
            int n11 = 99999;
            int n12 = 99999;
            for (int i = 0; i < this.date_positions.length; ++i) {
                int n13;
                int n14 = Math.abs(this.date_positions[i] - n7);
                if (n14 < n11) {
                    n11 = n14;
                    n9 = i;
                }
                if ((n13 = Math.abs(this.date_positions[i] - n8)) >= n12) continue;
                n12 = n13;
                n10 = i;
            }
            n9 = Math.max(n9, 0);
            n10 = Math.min(n10, this.date_positions.length - 1);
            this.globals.setCurrentStartDate(this.current_dates[n9]);
            this.globals.setCurrentEndDate(this.current_dates[n10]);
            this.newTimeWindow();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.width = n3;
        this.height = n4;
        this.setPreferredSize(new Dimension(n3, n4));
        if (this.isVisible()) {
            this.offscreen_image = this.createImage(n3, n4);
            Graphics2D graphics2D = (Graphics2D)this.offscreen_image.getGraphics();
            this.drawGraph(graphics2D, 0, 0, n3, n4, true);
            graphics2D.dispose();
            this.paintComponent(this.getGraphics());
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing() && this.offscreen_image != null) {
            graphics.drawImage(this.offscreen_image, 0, 0, this.width, this.height, this);
        }
    }

    public void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawGraph(graphics2D, n, n2, n3, n4, false);
    }

    public void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        int n7 = 5;
        int n8 = (int)((float)n4 * 0.05f);
        int n9 = (int)((float)(n3 - n7 * 2) * 0.1f);
        int n10 = n3 - n7 * 2 - n9;
        int n11 = (int)((float)(n4 - n7 * 2 - n8) * 0.15f);
        int n12 = n6 = n4 - n7 * 2 - n8 - n11;
        int n13 = n10;
        int n14 = n + n7;
        int n15 = n2 + n7 + n8;
        int n16 = n + n7 + n9;
        int n17 = n2 + n7 + n8 + n6;
        int n18 = n + n16;
        int n19 = n2 + n15;
        float f = (float)n10 / (float)(this.number_of_x_points + 2);
        this.date_x_locations = new int[this.number_of_x_points];
        for (n5 = 0; n5 < this.number_of_x_points; ++n5) {
            this.date_x_locations[n5] = (int)((float)(n5 + 1) * f);
        }
        if (bl) {
            this.date_positions = new int[this.number_of_x_points];
            for (n5 = 0; n5 < this.number_of_x_points; ++n5) {
                this.date_positions[n5] = this.date_x_locations[n5] + n9;
            }
        }
        this.drawTitle(graphics2D, n, n2, n3, n8);
        this.drawMainGraph(graphics2D, n18, n19, n10, n6);
        this.drawYAxis(graphics2D, n14, n15, n9, n12);
        this.drawXAxis(graphics2D, n16, n17, n13, n11);
    }

    private void drawTitle(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("Serif", 0, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n4 - 2 || fontMetrics.stringWidth(this.level_description) >= n3 - 4) continue;
            bl = true;
        }
        int n6 = n + (n3 - fontMetrics.stringWidth(this.level_description)) / 2;
        int n7 = n2 + n4 - 2;
        graphics2D.setColor(Color.black);
        graphics2D.drawString(this.level_description, n6, n7);
    }

    private void drawYAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        char c;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl = this.show_bias || this.show_stddev;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (bl && this.show_samplesize) {
            n11 = n10 = (int)((float)n3 * 0.1f);
            n13 = n12 = (int)((float)n3 * 0.4f);
        } else if (this.show_samplesize) {
            n10 = (int)((float)n3 * 0.2f);
            n12 = n3 - n10;
        } else {
            n11 = (int)((float)n3 * 0.2f);
            n13 = n3 - n11;
        }
        if (!bl && !this.show_samplesize) {
            bl = true;
        }
        String string = "";
        String string2 = "";
        String[] stringArray = new String[]{};
        if (bl) {
            if (this.show_bias && this.show_stddev) {
                string = "STD DEV / BIAS";
            } else if (this.show_bias) {
                string = "BIAS";
            } else if (this.show_stddev) {
                string = "STD DEV";
            }
            stringArray = new String[]{"" + this.oneDigit(this.min_stat), "" + this.oneDigit(this.min_stat + (this.max_stat - this.min_stat) * 0.25f), "" + this.oneDigit(this.min_stat + (this.max_stat - this.min_stat) * 0.5f), "" + this.oneDigit(this.min_stat + (this.max_stat - this.min_stat) * 0.75f), "" + this.oneDigit(this.max_stat)};
        }
        String[] stringArray2 = new String[]{};
        if (this.show_samplesize) {
            string2 = "SAMPLE SIZE";
            stringArray2 = new String[]{"" + this.min_count, "" + (this.min_count + (int)((float)(this.max_count - this.min_count) * 0.25f)), "" + (this.min_count + (this.max_count - this.min_count) / 2), "" + (this.min_count + (int)((float)(this.max_count - this.min_count) * 0.75f)), "" + this.max_count};
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n14 = 25;
        boolean bl2 = false;
        while (!bl2 && n14 > 5) {
            bl2 = true;
            graphics2D.setFont(new Font("SansSerif", 0, --n14));
            fontMetrics = graphics2D.getFontMetrics();
            if (bl) {
                if (fontMetrics.getHeight() * string.length() > n4 - 4) {
                    bl2 = false;
                }
                if (fontMetrics.stringWidth("M") > n11) {
                    bl2 = false;
                }
                for (n9 = 0; n9 < stringArray.length; ++n9) {
                    if (fontMetrics.stringWidth(stringArray[n9]) <= n13) continue;
                    bl2 = false;
                }
            }
            if (!this.show_samplesize) continue;
            if (fontMetrics.getHeight() * string2.length() > n4 - 4) {
                bl2 = false;
            }
            if (fontMetrics.stringWidth("M") > n10) {
                bl2 = false;
            }
            for (n9 = 0; n9 < stringArray2.length; ++n9) {
                if (fontMetrics.stringWidth(stringArray2[n9]) <= n12) continue;
                bl2 = false;
            }
        }
        if (this.show_samplesize) {
            graphics2D.setColor(Color.black);
            n9 = 0;
            n8 = 0;
            n7 = n;
            n6 = n + n10 + n11;
            for (n5 = 0; n5 < string2.length(); ++n5) {
                c = string2.charAt(n5);
                n9 = n7 + (fontMetrics.stringWidth("M") - fontMetrics.stringWidth("" + c) / 2);
                n8 = n2 + n4 / 2 - fontMetrics.getHeight() * string2.length() / 2;
                n8 = n8 + n5 * fontMetrics.getHeight() + fontMetrics.getAscent();
                graphics2D.drawString("" + c, n9, n8);
            }
            for (n5 = 0; n5 < stringArray2.length; ++n5) {
                n9 = n + (n3 - 2);
                n8 = n2 + (n4 - (int)((float)n5 / (float)(stringArray2.length - 1) * (float)n4));
                graphics2D.drawLine(n9, n8, n9 + 2, n8);
                n9 = n6 + (n12 - fontMetrics.stringWidth(stringArray2[n5]));
                graphics2D.drawString(stringArray2[n5], n9, n8 += fontMetrics.getAscent() / 2);
            }
        }
        if (bl) {
            graphics2D.setColor(Color.black);
            n9 = 0;
            n8 = 0;
            n7 = n + n10;
            n6 = n + n10 + n11 + n12;
            for (n5 = 0; n5 < string.length(); ++n5) {
                c = string.charAt(n5);
                n9 = n7 + (fontMetrics.stringWidth("M") - fontMetrics.stringWidth("" + c) / 2);
                n8 = n2 + n4 / 2 - fontMetrics.getHeight() * string.length() / 2;
                n8 = n8 + n5 * fontMetrics.getHeight() + fontMetrics.getAscent();
                graphics2D.drawString("" + c, n9, n8);
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                n9 = n + (n3 - 2);
                n8 = n2 + (n4 - (int)((float)n5 / (float)(stringArray.length - 1) * (float)n4));
                graphics2D.drawLine(n9, n8, n9 + 2, n8);
                n9 = n6 + (n13 - fontMetrics.stringWidth(stringArray[n5]));
                graphics2D.drawString(stringArray[n5], n9, n8 += fontMetrics.getAscent() / 2);
            }
        }
    }

    private void drawXAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("SansSerif", 0, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            bl = true;
            for (int i = 0; i < this.number_of_x_points; ++i) {
                if (fontMetrics.stringWidth(this.date_string[i]) <= n4 - 10) continue;
                bl = false;
            }
        }
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966));
        graphics2D.setFont(font2);
        int n6 = -999;
        for (int i = 0; i < this.number_of_x_points; ++i) {
            int n7 = n + this.date_x_locations[i];
            int n8 = n2 + 7 + fontMetrics.stringWidth(this.date_string[i]);
            int n9 = n7 + fontMetrics.getAscent() / 2;
            if (n9 > n6) {
                graphics2D.drawString(this.date_string[i], n9, n8);
                n6 = n9 + fontMetrics.getAscent();
            }
            graphics2D.drawLine(n7, n2, n7, n2 + 5);
        }
        graphics2D.setFont(font);
    }

    private void drawMainGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics2D.setClip(n, n2, n3, n4);
        if (this.data_available) {
            int n5;
            int n6;
            Stroke stroke = graphics2D.getStroke();
            for (n6 = 0; n6 < this.num_data_groups; ++n6) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        for (n5 = 0; n5 < 3; ++n5) {
                            for (int k = 0; k < 3; ++k) {
                                if (!this.data_profile[n6][i][j][n5][k].isVisible()) continue;
                                this.plotDataProfile(graphics2D, n, n2, n3, n4, this.data_profile[n6][i][j][n5][k]);
                            }
                        }
                    }
                }
            }
            if (this.show_bias || this.show_stddev) {
                graphics2D.setColor(Color.gray);
                n6 = 2;
                float[] fArray = new float[]{5.0f};
                BasicStroke basicStroke = new BasicStroke(n6, 0, 1, 5.0f, fArray, 0.0f);
                graphics2D.setStroke(basicStroke);
                n5 = n2 + this.getY(0.0f, this.min_stat, this.max_stat, n4);
                graphics2D.drawLine(n, n5, n + n3, n5);
                graphics2D.setStroke(stroke);
            }
        }
        graphics2D.setClip(null);
    }

    private void plotDataProfile(Graphics2D graphics2D, int n, int n2, int n3, int n4, NarcsDataProfile narcsDataProfile) {
        Point point;
        int n5;
        int n6;
        Stroke stroke = graphics2D.getStroke();
        int n7 = narcsDataProfile.getLineThickness();
        if (n7 == 0) {
            n7 = n4 / 200;
        }
        this.globals.setLineStyle(graphics2D, narcsDataProfile.getLineStyle(), n7);
        int n8 = (int)((float)n7 + (float)n7 / 4.0f);
        n8 = Math.max(n8, 4);
        boolean bl = this.globals.getShowDataPoints();
        float f = this.min_stat;
        float f2 = this.max_stat;
        if (narcsDataProfile.getStatType() == 2) {
            f = this.min_count;
            f2 = this.max_count;
        }
        Vector vector = new Vector();
        Vector<Point> vector2 = new Vector<Point>();
        graphics2D.setColor(narcsDataProfile.getLineColor());
        for (n6 = 0; n6 < this.number_of_x_points; ++n6) {
            int n9 = Short.MIN_VALUE;
            float f3 = narcsDataProfile.getValue(n6);
            if (this.ignore_extreme_values) {
                if (f3 >= f && f3 <= f2) {
                    n9 = n2 + this.getY(f3, f, f2, n4);
                }
            } else if (f3 != -32768.0f) {
                n9 = n2 + this.getY(f3, f, f2, n4);
            }
            if ((n5 = n + this.date_x_locations[n6]) == Short.MIN_VALUE || n9 == Short.MIN_VALUE) {
                vector.add(vector2);
                vector2 = new Vector<Point>();
                continue;
            }
            if (bl) {
                graphics2D.fillOval(n5 - n8, n9 - n8, n8 * 2, n8 * 2);
            }
            point = new Point(n5, n9);
            vector2.add(point);
        }
        vector.add(vector2);
        for (n6 = 0; n6 < vector.size(); ++n6) {
            vector2 = (Vector<Point>)vector.elementAt(n6);
            int[] nArray = new int[vector2.size()];
            int[] nArray2 = new int[vector2.size()];
            for (n5 = 0; n5 < vector2.size(); ++n5) {
                point = (Point)vector2.elementAt(n5);
                nArray[n5] = point.x;
                nArray2[n5] = point.y;
            }
            graphics2D.drawPolyline(nArray, nArray2, vector2.size());
        }
        graphics2D.setStroke(stroke);
    }

    public void drawLegend(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        int n9 = 0;
        for (int i = 0; i < this.num_data_groups; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        for (int i3 = 0; i3 < 3; ++i3) {
                            if (!this.data_profile[i][j][k][i2][i3].isVisible()) continue;
                            ++n9;
                        }
                    }
                }
            }
        }
        String[] stringArray = new String[]{"  Bias  ", "  StdDev  ", "  Count  "};
        String[] stringArray2 = new String[]{"P  ", "F  ", "P/F  "};
        String[] stringArray3 = new String[]{"S  ", "NS  ", "S/NS  "};
        String[] stringArray4 = new String[]{"Clr", "Cld", "Clr/Cld"};
        String[] stringArray5 = new String[n9];
        int n10 = -1;
        for (int i = 0; i < this.num_data_groups; ++i) {
            for (n8 = 0; n8 < 3; ++n8) {
                for (n7 = 0; n7 < 3; ++n7) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        for (n5 = 0; n5 < 3; ++n5) {
                            if (!this.data_profile[i][n8][n7][n6][n5].isVisible()) continue;
                            stringArray5[++n10] = this.data_profile[i][n8][n7][n6][n5].getLabel() + stringArray[n8] + stringArray2[n7] + stringArray3[n6] + stringArray4[n5];
                        }
                    }
                }
            }
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        n8 = 25;
        n7 = 0;
        while (n7 == 0 && n8 > 5) {
            graphics2D.setFont(new Font("Serif", 0, --n8));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() * 3 * n9 >= n4) continue;
            n6 = 1;
            for (n5 = 0; n5 < n9; ++n5) {
                if (fontMetrics.stringWidth(stringArray5[n5]) < n3) continue;
                n6 = 0;
            }
            n7 = n6;
        }
        n10 = -1;
        for (n6 = 0; n6 < this.num_data_groups; ++n6) {
            for (n5 = 0; n5 < 3; ++n5) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            if (!this.data_profile[n6][n5][i][j][k].isVisible()) continue;
                            int n11 = n + 2;
                            int n12 = n2 + fontMetrics.getHeight() + fontMetrics.getHeight() * 3 * ++n10;
                            graphics2D.setColor(Color.black);
                            graphics2D.drawString(stringArray5[n10], n11, n12);
                            n12 += fontMetrics.getHeight();
                            Color color = this.data_profile[n6][n5][i][j][k].getLineColor();
                            int n13 = this.data_profile[n6][n5][i][j][k].getLineThickness();
                            int n14 = this.data_profile[n6][n5][i][j][k].getLineStyle();
                            graphics2D.setColor(color);
                            Stroke stroke = graphics2D.getStroke();
                            this.globals.setLineStyle(graphics2D, n14, n13);
                            graphics2D.drawLine(n + 2, n12, n + (n3 - 4), n12);
                            graphics2D.setStroke(stroke);
                        }
                    }
                }
            }
        }
    }

    public void changeGraphLines() {
        if (this.data_available) {
            int n;
            Vector<NarcsDataProfile> vector = new Vector<NarcsDataProfile>();
            for (int i = 0; i < this.num_data_groups; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        for (n = 0; n < 3; ++n) {
                            for (int i2 = 0; i2 < 3; ++i2) {
                                if (!this.data_profile[i][j][k][n][i2].isVisible()) continue;
                                vector.add(this.data_profile[i][j][k][n][i2]);
                            }
                        }
                    }
                }
            }
            JFrame jFrame = new JFrame();
            LineSettingsDialog lineSettingsDialog = new LineSettingsDialog(jFrame, vector);
            if (lineSettingsDialog.okButtonPressed()) {
                Vector vector2 = lineSettingsDialog.getProfiles();
                for (n = 0; n < vector2.size(); ++n) {
                    NarcsDataProfile narcsDataProfile = (NarcsDataProfile)vector2.elementAt(n);
                    int n2 = narcsDataProfile.getGroupNumber();
                    int n3 = narcsDataProfile.getStatType();
                    int n4 = narcsDataProfile.getQCType();
                    int n5 = narcsDataProfile.getTerrainType();
                    int n6 = narcsDataProfile.getCloudType();
                    this.data_profile[n2][n3][n4][n5][n6] = narcsDataProfile;
                    this.globals.updateLineSettings(n2, n3, n4, n5, n6, narcsDataProfile.getLineColor(), narcsDataProfile.getLineThickness(), narcsDataProfile.getLineStyle());
                }
                this.updateGraph();
            }
        }
    }

    public void newTimeWindow() {
        this.data_available = false;
        this.updateGraph();
    }

    public void updateGraph() {
        this.show_bias = this.globals.getShowBias();
        this.show_stddev = this.globals.getShowStdDev();
        this.show_samplesize = this.globals.getShowSampleSize();
        this.show_group = this.globals.getDataGroupSelections();
        if (this.level_type == 0) {
            this.min_max_option = this.globals.getTempMinMaxOption();
            this.default_min = this.globals.getTempDefaultMin();
            this.default_max = this.globals.getTempDefaultMax();
            this.manual_min = this.globals.getTempManualMin();
            this.manual_max = this.globals.getTempManualMax();
            this.ignore_extreme_values = this.globals.getTempIgnoreExtremes();
        } else {
            this.min_max_option = this.globals.getWvapMinMaxOption();
            this.default_min = this.globals.getWvapDefaultMin();
            this.default_max = this.globals.getWvapDefaultMax();
            this.manual_min = this.globals.getWvapManualMin();
            this.manual_max = this.globals.getWvapManualMax();
            this.ignore_extreme_values = this.globals.getWvapIgnoreExtremes();
        }
        if (!this.data_available && this.file_name != null) {
            this.readData();
        }
        if (this.data_available) {
            this.decideWhichProfilesToDisplay();
            this.findMinMax();
            if (this.isVisible() && this.isValid()) {
                this.offscreen_image = this.createImage(this.width, this.height);
                Graphics2D graphics2D = (Graphics2D)this.offscreen_image.getGraphics();
                this.drawGraph(graphics2D, 0, 0, this.width, this.height, true);
                graphics2D.dispose();
                this.paintComponent(this.getGraphics());
            }
        }
    }

    private void readData() {
        try {
            int n;
            int n2;
            this.dates = new long[this.num_records];
            int[][][][][] nArray = new int[this.num_data_groups][this.num_records][2][3][3];
            float[][][][][] fArray = new float[this.num_data_groups][this.num_records][2][3][3];
            float[][][][][] fArray2 = new float[this.num_data_groups][this.num_records][2][3][3];
            for (int i = 0; i < this.num_data_groups; ++i) {
                for (int j = 0; j < this.num_records; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        for (n2 = 0; n2 < 3; ++n2) {
                            for (n = 0; n < 3; ++n) {
                                nArray[i][j][k][n2][n] = 0;
                                fArray[i][j][k][n2][n] = 0.0f;
                                fArray2[i][j][k][n2][n] = 0.0f;
                            }
                        }
                    }
                }
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file_name, "r");
            long l = this.header_length;
            for (n2 = 0; n2 < this.num_records; ++n2) {
                randomAccessFile.seek(l);
                n = randomAccessFile.readInt();
                int n3 = randomAccessFile.readInt();
                int n4 = randomAccessFile.readInt();
                this.dates[n2] = n3 * 10000 + n4;
                long l2 = l + 36L;
                randomAccessFile.seek(l2);
                int n5 = randomAccessFile.readInt();
                for (int i = 0; i < n5; ++i) {
                    int n6;
                    l2 = l + 40L + (long)(i * (40 + this.num_level_blocks * 216));
                    randomAccessFile.seek(l2);
                    int n7 = randomAccessFile.readInt();
                    if (n7 == Short.MIN_VALUE) continue;
                    l2 = l2 + 40L + (long)(this.level * 216);
                    randomAccessFile.seek(l2);
                    byte[] byArray = new byte[216];
                    randomAccessFile.readFully(byArray);
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    int[] nArray2 = new int[54];
                    for (n6 = 0; n6 < 54; ++n6) {
                        nArray2[n6] = dataInputStream.readInt();
                    }
                    n6 = -1;
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            int n8 = ++n6 * 6;
                            nArray[n7][n2][0][j][k] = nArray2[n8];
                            fArray[n7][n2][0][j][k] = (float)nArray2[n8 + 1] / 1000.0f;
                            fArray2[n7][n2][0][j][k] = (float)nArray2[n8 + 2] / 1000.0f;
                            nArray[n7][n2][1][j][k] = nArray2[n8 + 3];
                            fArray[n7][n2][1][j][k] = (float)nArray2[n8 + 4] / 1000.0f;
                            fArray2[n7][n2][1][j][k] = (float)nArray2[n8 + 5] / 1000.0f;
                        }
                    }
                }
                l += (long)n;
            }
            randomAccessFile.close();
            this.calculateDateIntervals();
            this.combineDateStats(nArray, fArray, fArray2);
            this.data_available = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void calculateDateIntervals() {
        block21: {
            int n;
            int n2;
            block22: {
                block20: {
                    long l = this.globals.getCurrentStartDate();
                    long l2 = this.globals.getCurrentEndDate();
                    n2 = 0;
                    for (n = this.dates.length - 1; n > 0 && l < this.dates[n]; --n) {
                    }
                    while (n2 < this.dates.length - 1 && l2 > this.dates[n2]) {
                        ++n2;
                    }
                    int n3 = n2 - n + 1;
                    if (this.globals.getTimeWindowOption() != 0) break block20;
                    this.number_of_x_points = n3;
                    this.from_record = new int[this.number_of_x_points];
                    this.to_record = new int[this.number_of_x_points];
                    this.date_string = new String[this.number_of_x_points];
                    this.current_dates = new int[this.number_of_x_points];
                    for (int i = 0; i < this.number_of_x_points; ++i) {
                        this.from_record[i] = n + i;
                        this.to_record[i] = n + i;
                        int n4 = (int)(this.dates[n + i] / 10000L);
                        int n5 = (int)(this.dates[n + i] % 10000L / 100L);
                        int n6 = (int)(this.dates[n + i] % 100L);
                        String string = "" + n4 % 100;
                        if (n4 % 100 < 10) {
                            string = "0" + string;
                        }
                        this.date_string[i] = "" + n5 + "/" + n6 + "/" + string;
                        this.current_dates[i] = n4 * 10000 + n5 * 100 + n6;
                    }
                    break block21;
                }
                if (this.globals.getTimeWindowOption() != 1) break block22;
                Calendar calendar = Calendar.getInstance();
                int n7 = (int)(this.dates[n] / 10000L);
                int n8 = (int)(this.dates[n] % 10000L / 100L) - 1;
                int n9 = (int)(this.dates[n] % 100L);
                calendar.set(n7, n8, n9);
                while (calendar.get(7) != 1) {
                    calendar.add(5, -1);
                }
                Calendar calendar2 = Calendar.getInstance();
                n7 = (int)(this.dates[n2] / 10000L);
                n8 = (int)(this.dates[n2] % 10000L / 100L) - 1;
                n9 = (int)(this.dates[n2] % 100L);
                calendar2.set(n7, n8, n9);
                while (calendar2.get(7) != 7) {
                    calendar2.add(5, 1);
                }
                this.number_of_x_points = 0;
                Calendar calendar3 = Calendar.getInstance();
                n7 = (int)(this.dates[n] / 10000L);
                n8 = (int)(this.dates[n] % 10000L / 100L) - 1;
                n9 = (int)(this.dates[n] % 100L);
                calendar3.set(n7, n8, n9);
                while (!calendar3.after(calendar2)) {
                    ++this.number_of_x_points;
                    calendar3.add(5, 7);
                }
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.date_string = new String[this.number_of_x_points];
                this.current_dates = new int[this.number_of_x_points];
                calendar3 = (Calendar)calendar.clone();
                int n10 = 0;
                while (calendar3.before(calendar2)) {
                    int n11 = calendar3.get(1);
                    int n12 = calendar3.get(2) + 1;
                    int n13 = calendar3.get(5);
                    int n14 = n11 * 10000 + n12 * 100 + n13;
                    String string = "" + n11 % 100;
                    if (n11 % 100 < 10) {
                        string = "0" + string;
                    }
                    calendar3.add(5, 6);
                    int n15 = calendar3.get(1);
                    int n16 = calendar3.get(2) + 1;
                    int n17 = calendar3.get(5);
                    int n18 = n15 * 10000 + n16 * 100 + n17;
                    String string2 = "" + n15 % 100;
                    if (n15 % 100 < 10) {
                        string2 = "0" + string2;
                    }
                    this.date_string[n10] = "" + n12 + "/" + n13 + "/" + string;
                    this.current_dates[n10] = n11 * 10000 + n12 * 100 + n13;
                    this.from_record[n10] = Short.MIN_VALUE;
                    this.to_record[n10] = Short.MIN_VALUE;
                    for (int i = 0; i < this.dates.length; ++i) {
                        if (this.dates[i] < (long)n14 || this.dates[i] > (long)n18) continue;
                        if (this.from_record[n10] == Short.MIN_VALUE) {
                            this.from_record[n10] = i;
                        }
                        this.to_record[n10] = i;
                    }
                    ++n10;
                    calendar3.add(5, 1);
                }
                break block21;
            }
            if (this.globals.getTimeWindowOption() != 2) break block21;
            int n19 = (int)(this.dates[n] / 100L);
            int n20 = (int)(this.dates[n2] / 100L);
            if (n19 == n20) {
                this.number_of_x_points = 1;
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.from_record[0] = n;
                this.to_record[0] = n2;
                this.date_string = new String[1];
                int n21 = n19 / 100;
                int n22 = n19 % 100;
                this.date_string[0] = "" + n22 + "/" + n21;
                this.current_dates = new int[1];
                this.current_dates[0] = n21 * 10000 + n22 * 100 + 1;
            } else {
                int n23;
                int n24;
                this.number_of_x_points = 0;
                int n25 = n19;
                while (n25 <= n20) {
                    n24 = n25 / 100;
                    n23 = n25 % 100;
                    if (++n23 > 12) {
                        n23 = 1;
                        ++n24;
                    }
                    n25 = n24 * 100 + n23;
                    ++this.number_of_x_points;
                }
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.date_string = new String[this.number_of_x_points];
                this.current_dates = new int[this.number_of_x_points];
                n25 = n19;
                n24 = 0;
                while (n25 <= n20) {
                    n23 = n25 / 100;
                    int n26 = n25 % 100;
                    this.from_record[n24] = Short.MIN_VALUE;
                    this.to_record[n24] = Short.MIN_VALUE;
                    for (int i = n; i <= n2; ++i) {
                        int n27 = (int)(this.dates[i] / 100L);
                        if (n27 != n25) continue;
                        if (this.from_record[n24] == Short.MIN_VALUE) {
                            this.from_record[n24] = i;
                        }
                        this.to_record[n24] = i;
                    }
                    this.date_string[n24] = "" + n26 + "/" + n23;
                    this.current_dates[n24] = n23 * 10000 + n26 * 100 + 1;
                    ++n24;
                    if (++n26 > 12) {
                        n26 = 1;
                        ++n23;
                    }
                    n25 = n23 * 100 + n26;
                }
            }
        }
    }

    private void combineDateStats(int[][][][][] nArray, float[][][][][] fArray, float[][][][][] fArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        float[][][][][] fArray3 = new float[this.num_data_groups][this.number_of_x_points][2][3][3];
        float[][][][][] fArray4 = new float[this.num_data_groups][this.number_of_x_points][2][3][3];
        float[][][][][] fArray5 = new float[this.num_data_groups][this.number_of_x_points][2][3][3];
        for (n5 = 0; n5 < this.num_data_groups; ++n5) {
            for (n4 = 0; n4 < this.number_of_x_points; ++n4) {
                for (n3 = 0; n3 < 2; ++n3) {
                    for (n2 = 0; n2 < 3; ++n2) {
                        for (n = 0; n < 3; ++n) {
                            fArray3[n5][n4][n3][n2][n] = 0.0f;
                            fArray4[n5][n4][n3][n2][n] = 0.0f;
                            fArray5[n5][n4][n3][n2][n] = 0.0f;
                        }
                    }
                }
            }
        }
        for (n5 = 0; n5 < this.num_data_groups; ++n5) {
            for (n4 = 0; n4 < this.number_of_x_points; ++n4) {
                for (n3 = this.from_record[n4]; n3 <= this.to_record[n4]; ++n3) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        for (n = 0; n < 3; ++n) {
                            for (int i = 0; i < 3; ++i) {
                                if (nArray[n5][n3][n2][n][i] <= 0) continue;
                                fArray3[n5][n4][n2][n][i] = fArray3[n5][n4][n2][n][i] + (float)nArray[n5][n3][n2][n][i];
                                fArray4[n5][n4][n2][n][i] = fArray4[n5][n4][n2][n][i] + fArray[n5][n3][n2][n][i] * (float)nArray[n5][n3][n2][n][i];
                                fArray5[n5][n4][n2][n][i] = fArray5[n5][n4][n2][n][i] + fArray2[n5][n3][n2][n][i] * (float)nArray[n5][n3][n2][n][i];
                            }
                        }
                    }
                }
            }
        }
        for (n5 = 0; n5 < this.num_data_groups; ++n5) {
            for (n4 = 0; n4 < this.number_of_x_points; ++n4) {
                for (n3 = 0; n3 < 2; ++n3) {
                    for (n2 = 0; n2 < 3; ++n2) {
                        for (n = 0; n < 3; ++n) {
                            if (!(fArray3[n5][n4][n3][n2][n] > 0.0f)) continue;
                            fArray4[n5][n4][n3][n2][n] = fArray4[n5][n4][n3][n2][n] / fArray3[n5][n4][n3][n2][n];
                            fArray5[n5][n4][n3][n2][n] = fArray5[n5][n4][n3][n2][n] / fArray3[n5][n4][n3][n2][n];
                        }
                    }
                }
            }
        }
        this.data_profile = new NarcsDataProfile[this.num_data_groups][3][3][3][3];
        for (n5 = 0; n5 < this.num_data_groups; ++n5) {
            Color color = this.globals.getGroupColor(n5);
            for (n3 = 0; n3 < 3; ++n3) {
                for (n2 = 0; n2 < 3; ++n2) {
                    for (n = 0; n < 3; ++n) {
                        this.createDataProfiles(n5, n3, n2, n, color, fArray3, fArray4, fArray5);
                    }
                }
            }
        }
    }

    private void createDataProfiles(int n, int n2, int n3, int n4, Color color, float[][][][][] fArray, float[][][][][] fArray2, float[][][][][] fArray3) {
        boolean[] blArray = new boolean[3];
        boolean[] blArray2 = new boolean[3];
        boolean[] blArray3 = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            blArray[i] = false;
            blArray2[i] = false;
            blArray3[i] = false;
        }
        if (n2 == 0) {
            blArray[0] = true;
        } else if (n2 == 1) {
            blArray[1] = true;
        } else if (n2 == 2) {
            blArray[0] = true;
            blArray[1] = true;
        }
        if (n3 == 0) {
            blArray2[0] = true;
            blArray2[2] = true;
        } else if (n3 == 1) {
            blArray2[1] = true;
            blArray2[2] = true;
        } else if (n3 == 2) {
            blArray2[0] = true;
            blArray2[1] = true;
            blArray2[2] = true;
        }
        if (n4 == 0) {
            blArray3[0] = true;
            blArray3[2] = true;
        } else if (n4 == 1) {
            blArray3[1] = true;
            blArray3[2] = true;
        } else if (n4 == 2) {
            blArray3[0] = true;
            blArray3[1] = true;
            blArray3[2] = true;
        }
        float[] fArray4 = new float[this.number_of_x_points];
        float[] fArray5 = new float[this.number_of_x_points];
        float[] fArray6 = new float[this.number_of_x_points];
        for (int i = 0; i < this.number_of_x_points; ++i) {
            fArray4[i] = 0.0f;
            fArray5[i] = 0.0f;
            fArray6[i] = 0.0f;
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        if (!blArray[j] || !blArray2[k] || !blArray3[i2]) continue;
                        fArray4[i] = fArray4[i] + fArray[n][i][j][k][i2];
                        fArray5[i] = fArray5[i] + fArray[n][i][j][k][i2] * fArray2[n][i][j][k][i2];
                        fArray6[i] = fArray6[i] + fArray[n][i][j][k][i2] * fArray3[n][i][j][k][i2];
                    }
                }
            }
            if (fArray4[i] > 0.0f) {
                fArray5[i] = fArray5[i] / fArray4[i];
                fArray6[i] = fArray6[i] / fArray4[i];
                continue;
            }
            fArray5[i] = -32768.0f;
            fArray6[i] = -32768.0f;
        }
        this.data_profile[n][0][n2][n3][n4] = new NarcsDataProfile(fArray4, fArray5, color, n, 0, n2, n3, n4, this.group_description[n]);
        this.data_profile[n][1][n2][n3][n4] = new NarcsDataProfile(fArray4, fArray6, color, n, 1, n2, n3, n4, this.group_description[n]);
        this.data_profile[n][2][n2][n3][n4] = new NarcsDataProfile(fArray4, fArray4, color, n, 2, n2, n3, n4, this.group_description[n]);
    }

    private void decideWhichProfilesToDisplay() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        for (n7 = 0; n7 < this.num_data_groups; ++n7) {
            for (n6 = 0; n6 < 3; ++n6) {
                n5 = 1;
                if (n6 == 0 && !this.globals.getShowBias()) {
                    n5 = 0;
                } else if (n6 == 1 && !this.globals.getShowStdDev()) {
                    n5 = 0;
                } else if (n6 == 2 && !this.globals.getShowSampleSize()) {
                    n5 = 0;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    n3 = 1;
                    if (n4 == 0 && !this.globals.getShowPassedQC()) {
                        n3 = 0;
                    } else if (n4 == 1 && !this.globals.getShowFailedQC()) {
                        n3 = 0;
                    } else if (n4 == 2 && !this.globals.getShowPassedAndFailedQC()) {
                        n3 = 0;
                    }
                    for (int i = 0; i < 3; ++i) {
                        n2 = 1;
                        if (i == 0 && !this.globals.getShowSea()) {
                            n2 = 0;
                        } else if (i == 1 && !this.globals.getShowNonsea()) {
                            n2 = 0;
                        } else if (i == 2 && !this.globals.getShowSeaAndNonsea()) {
                            n2 = 0;
                        }
                        for (n = 0; n < 3; ++n) {
                            boolean bl = true;
                            if (n == 0 && !this.globals.getShowClear()) {
                                bl = false;
                            } else if (n == 1 && !this.globals.getShowCloudy()) {
                                bl = false;
                            } else if (n == 2 && !this.globals.getShowClearAndCloudy()) {
                                bl = false;
                            }
                            boolean bl2 = false;
                            if (this.show_group[n7] && n5 != 0 && n3 != 0 && n2 != 0 && bl) {
                                bl2 = true;
                            }
                            this.data_profile[n7][n6][n4][i][n].setVisible(bl2);
                        }
                    }
                }
            }
        }
        for (n7 = 0; n7 < this.num_data_groups; ++n7) {
            for (n6 = 0; n6 < 3; ++n6) {
                for (n5 = 0; n5 < 3; ++n5) {
                    for (n4 = 0; n4 < 3; ++n4) {
                        for (n3 = 0; n3 < 3; ++n3) {
                            Color color = this.globals.getLineColor(n7, n6, n5, n4, n3);
                            n2 = this.globals.getLineThickness(n7, n6, n5, n4, n3);
                            n = this.globals.getLineStyle(n7, n6, n5, n4, n3);
                            this.data_profile[n7][n6][n5][n4][n3].setLineColor(color);
                            this.data_profile[n7][n6][n5][n4][n3].setLineThickness(n2);
                            this.data_profile[n7][n6][n5][n4][n3].setLineStyle(n);
                        }
                    }
                }
            }
        }
    }

    private void findMinMax() {
        if (this.data_available) {
            if (this.globals.getSampleSizeMinMaxOption() == 2) {
                this.min_count = this.globals.getSampleSizeManualMin();
                this.max_count = this.globals.getSampleSizeManualMax();
            } else {
                this.min_count = 9999999;
                this.max_count = -9999999;
                for (int i = 0; i < this.num_data_groups; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            for (int i2 = 0; i2 < 3; ++i2) {
                                if (!this.data_profile[i][2][j][k][i2].isVisible()) continue;
                                float f = this.data_profile[i][2][j][k][i2].getMinimumValue();
                                float f2 = this.data_profile[i][2][j][k][i2].getMaximumValue();
                                this.min_count = Math.min(this.min_count, (int)f);
                                this.max_count = Math.max(this.max_count, (int)f2);
                            }
                        }
                    }
                }
                if (this.min_count == 9999999) {
                    this.min_count = 0;
                }
                if (this.max_count == -9999999) {
                    this.max_count = 100;
                }
                if (this.globals.getSampleSizeMinMaxOption() == 1) {
                    this.min_count = 0;
                }
            }
            if (this.min_max_option == 1) {
                this.min_stat = this.default_min;
                this.max_stat = this.default_max;
            } else if (this.min_max_option == 2) {
                this.min_stat = this.manual_min;
                this.max_stat = this.manual_max;
            } else {
                float f = 9999999.0f;
                float f3 = -9999999.0f;
                float f4 = 9999999.0f;
                float f5 = -9999999.0f;
                for (int i = 0; i < this.num_data_groups; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            for (int i3 = 0; i3 < 3; ++i3) {
                                float f6;
                                float f7;
                                if (this.data_profile[i][0][j][k][i3].isVisible()) {
                                    f7 = this.data_profile[i][0][j][k][i3].getMinimumValue();
                                    f6 = this.data_profile[i][0][j][k][i3].getMaximumValue();
                                    f = Math.min(f, f7);
                                    f3 = Math.max(f3, f6);
                                }
                                if (!this.data_profile[i][1][j][k][i3].isVisible()) continue;
                                f7 = this.data_profile[i][1][j][k][i3].getMinimumValue();
                                f6 = this.data_profile[i][1][j][k][i3].getMaximumValue();
                                f4 = Math.min(f4, f7);
                                f5 = Math.max(f5, f6);
                            }
                        }
                    }
                }
                if (f == 9999999.0f || f == -9999999.0f || f3 == 9999999.0f || f3 == -9999999.0f) {
                    f = -5.0f;
                    f3 = 5.0f;
                }
                if (f4 == 9999999.0f || f4 == -9999999.0f || f4 == 9999999.0f || f4 == -9999999.0f) {
                    f4 = -5.0f;
                    f4 = 5.0f;
                }
                if (this.show_bias && this.show_stddev) {
                    this.min_stat = Math.min(f, f4);
                    this.max_stat = Math.max(f3, f5);
                } else if (this.show_bias) {
                    this.min_stat = f;
                    this.max_stat = f3;
                } else if (this.show_stddev) {
                    this.min_stat = f4;
                    this.max_stat = f5;
                } else {
                    this.min_stat = -10.0f;
                    this.max_stat = 10.0f;
                }
            }
        }
    }

    private int getY(float f, float f2, float f3, int n) {
        float f4 = f3 - f2;
        float f5 = 0.0f;
        f5 = (f - f2) / f4;
        int n2 = n - (int)((float)n * f5);
        return n2;
    }

    private float oneDigit(float f) {
        return (float)((int)(f * 10.0f)) / 10.0f;
    }
}

