/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class StatPanel
extends JPanel
implements ActionListener {
    private NARCS parent;
    private StatGraph graph;
    private JRadioButton daily_button;
    private JRadioButton weekly_button;
    private JRadioButton monthly_button;
    private JCheckBox passed_and_failed_qc_box;
    private JCheckBox passed_qc_box;
    private JCheckBox failed_qc_box;
    private JCheckBox sea_box;
    private JCheckBox nonsea_box;
    private JCheckBox sea_and_nonsea_box;
    private JCheckBox clear_box;
    private JCheckBox cloudy_box;
    private JCheckBox clear_and_cloudy_box;
    private JCheckBox bias_box;
    private JCheckBox stddev_box;
    private JCheckBox samplesize_box;
    private JCheckBox[] data_group_box;
    private JButton graph_options_button;
    private boolean ignore_events;
    private int level;
    private int level_type;
    private float level_pressure;
    private String level_description;
    private int[] data_group_id;
    private String[] data_group_description;
    private NarcsGlobals globals;

    public StatPanel(NARCS nARCS, String string, int n, int n2, float f, String string2, int n3, int n4, int n5, int n6, int[] nArray, String[] stringArray) {
        this.parent = nARCS;
        this.level = n;
        this.level_type = n2;
        this.level_pressure = f;
        this.level_description = string2;
        this.data_group_id = nArray;
        this.data_group_description = stringArray;
        this.globals = new NarcsGlobals();
        this.ignore_events = false;
        this.addControls(string, n3, n4, n5, n6);
    }

    private void addControls(String string, int n, int n2, int n3, int n4) {
        this.setLayout(new BorderLayout());
        this.data_group_box = new JCheckBox[n4];
        boolean[] blArray = this.globals.getDataGroupSelections();
        for (int i = 0; i < n4; ++i) {
            this.data_group_box[i] = new JCheckBox(this.data_group_description[i]);
            this.data_group_box[i].addActionListener(this);
            this.data_group_box[i].setForeground(this.globals.getGroupColor(i));
            this.data_group_box[i].setBackground(Color.white);
            this.data_group_box[i].setSelected(blArray[i]);
        }
        ScrollingPanel scrollingPanel = new ScrollingPanel();
        scrollingPanel.setBackground(Color.white);
        scrollingPanel.setLayout(new StackLayout());
        for (int i = 0; i < this.data_group_box.length; ++i) {
            scrollingPanel.add(this.data_group_box[i]);
        }
        this.add((Component)scrollingPanel, "East");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.graph_options_button = new JButton("Graph Options");
        this.graph_options_button.addActionListener(this);
        jPanel.add(this.graph_options_button);
        jPanel.add(new JLabel("          "));
        this.daily_button = new JRadioButton("Daily");
        this.weekly_button = new JRadioButton("Weekly");
        this.monthly_button = new JRadioButton("Monthly");
        this.daily_button.addActionListener(this);
        this.weekly_button.addActionListener(this);
        this.monthly_button.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.daily_button);
        buttonGroup.add(this.weekly_button);
        buttonGroup.add(this.monthly_button);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add(this.daily_button);
        jPanel2.add(this.weekly_button);
        jPanel2.add(this.monthly_button);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel3.setLayout(new GridLayout(3, 1));
        this.bias_box = new JCheckBox("Bias");
        this.stddev_box = new JCheckBox("Std Dev");
        this.samplesize_box = new JCheckBox("Sample Size");
        this.bias_box.setSelected(this.globals.getShowBias());
        this.stddev_box.setSelected(this.globals.getShowStdDev());
        this.samplesize_box.setSelected(this.globals.getShowSampleSize());
        this.bias_box.addActionListener(this);
        this.stddev_box.addActionListener(this);
        this.samplesize_box.addActionListener(this);
        jPanel3.add(this.bias_box);
        jPanel3.add(this.stddev_box);
        jPanel3.add(this.samplesize_box);
        jPanel.add(jPanel3);
        this.passed_and_failed_qc_box = new JCheckBox("Passed / Failed QC");
        this.passed_qc_box = new JCheckBox("Passed QC");
        this.failed_qc_box = new JCheckBox("Failed QC");
        this.passed_and_failed_qc_box.setSelected(this.globals.getShowPassedAndFailedQC());
        this.passed_qc_box.setSelected(this.globals.getShowPassedQC());
        this.failed_qc_box.setSelected(this.globals.getShowFailedQC());
        this.passed_and_failed_qc_box.addActionListener(this);
        this.passed_qc_box.addActionListener(this);
        this.failed_qc_box.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel4.setLayout(new GridLayout(3, 1));
        jPanel4.add(this.passed_and_failed_qc_box);
        jPanel4.add(this.passed_qc_box);
        jPanel4.add(this.failed_qc_box);
        jPanel.add(jPanel4);
        this.sea_and_nonsea_box = new JCheckBox("Sea and Non-Sea");
        this.sea_box = new JCheckBox("Sea");
        this.nonsea_box = new JCheckBox("Non-Sea");
        this.sea_box.addActionListener(this);
        this.nonsea_box.addActionListener(this);
        this.sea_and_nonsea_box.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel5.setLayout(new GridLayout(3, 1));
        jPanel5.add(this.sea_and_nonsea_box);
        jPanel5.add(this.sea_box);
        jPanel5.add(this.nonsea_box);
        jPanel.add(jPanel5);
        this.clear_and_cloudy_box = new JCheckBox("Clear and Cloudy");
        this.clear_box = new JCheckBox("Clear");
        this.cloudy_box = new JCheckBox("Cloudy");
        this.clear_box.addActionListener(this);
        this.cloudy_box.addActionListener(this);
        this.clear_and_cloudy_box.addActionListener(this);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel6.setLayout(new GridLayout(3, 1));
        jPanel6.add(this.clear_and_cloudy_box);
        jPanel6.add(this.clear_box);
        jPanel6.add(this.cloudy_box);
        jPanel.add(jPanel6);
        this.add((Component)jPanel, "South");
        this.graph = new StatGraph(string, this.level, this.level_description, this.level_type, n, n2, n3, n4, this.data_group_description);
        this.add((Component)this.graph, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.ignore_events) {
            if (actionEvent.getSource() instanceof JButton) {
                this.changeGraphSettings();
            } else if (actionEvent.getSource() instanceof JRadioButton) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                if (jRadioButton == this.daily_button || jRadioButton == this.weekly_button || jRadioButton == this.monthly_button) {
                    this.changeTimeWindow();
                }
            } else if (actionEvent.getSource() instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox == this.bias_box) {
                    this.globals.setShowBias(this.bias_box.isSelected());
                    this.graph.updateGraph();
                } else if (jCheckBox == this.stddev_box) {
                    this.globals.setShowStdDev(this.stddev_box.isSelected());
                    this.graph.updateGraph();
                } else if (jCheckBox == this.samplesize_box) {
                    this.globals.setShowSampleSize(this.samplesize_box.isSelected());
                    this.graph.updateGraph();
                } else if (jCheckBox == this.passed_and_failed_qc_box || jCheckBox == this.passed_qc_box || jCheckBox == this.failed_qc_box) {
                    this.changeQCOptions();
                } else if (jCheckBox == this.sea_box || jCheckBox == this.nonsea_box || jCheckBox == this.sea_and_nonsea_box) {
                    this.changeTerrainOptions();
                } else if (jCheckBox == this.clear_box || jCheckBox == this.cloudy_box || jCheckBox == this.clear_and_cloudy_box) {
                    this.changeCloudOptions();
                } else {
                    int n;
                    boolean bl = false;
                    boolean bl2 = false;
                    for (n = 0; n < this.data_group_box.length; ++n) {
                        if (jCheckBox != this.data_group_box[n]) continue;
                        bl = true;
                        bl2 = this.data_group_box[n].isSelected();
                    }
                    if (bl) {
                        if ((actionEvent.getModifiers() & 2) != 0) {
                            for (n = 0; n < this.data_group_box.length; ++n) {
                                this.ignore_events = true;
                                this.data_group_box[n].setSelected(bl2);
                                this.ignore_events = false;
                            }
                        }
                        boolean[] blArray = new boolean[this.data_group_box.length];
                        for (int i = 0; i < this.data_group_box.length; ++i) {
                            blArray[i] = this.data_group_box[i].isSelected();
                        }
                        this.globals.setDataGroupSelections(blArray);
                        this.graph.updateGraph();
                    }
                }
            }
        }
    }

    public void panelSelected() {
        this.ignore_events = true;
        if (this.globals.getTimeWindowOption() == 0) {
            this.daily_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 1) {
            this.weekly_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 2) {
            this.monthly_button.setSelected(true);
        }
        this.bias_box.setSelected(this.globals.getShowBias());
        this.stddev_box.setSelected(this.globals.getShowStdDev());
        this.samplesize_box.setSelected(this.globals.getShowSampleSize());
        this.passed_and_failed_qc_box.setSelected(this.globals.getShowPassedAndFailedQC());
        this.passed_qc_box.setSelected(this.globals.getShowPassedQC());
        this.failed_qc_box.setSelected(this.globals.getShowFailedQC());
        this.sea_box.setSelected(this.globals.getShowSea());
        this.nonsea_box.setSelected(this.globals.getShowNonsea());
        this.sea_and_nonsea_box.setSelected(this.globals.getShowSeaAndNonsea());
        this.clear_box.setSelected(this.globals.getShowClear());
        this.cloudy_box.setSelected(this.globals.getShowCloudy());
        this.clear_and_cloudy_box.setSelected(this.globals.getShowClearAndCloudy());
        boolean[] blArray = this.globals.getDataGroupSelections();
        for (int i = 0; i < this.data_group_box.length; ++i) {
            this.data_group_box[i].setSelected(blArray[i]);
        }
        this.ignore_events = false;
        this.graph.newTimeWindow();
    }

    private void changeTimeWindow() {
        int n = 0;
        if (this.weekly_button.isSelected()) {
            n = 1;
        } else if (this.monthly_button.isSelected()) {
            n = 2;
        }
        this.globals.setTimeWindowOption(n);
        this.graph.newTimeWindow();
    }

    private void changeQCOptions() {
        this.globals.setShowPassedAndFailedQC(this.passed_and_failed_qc_box.isSelected());
        this.globals.setShowPassedQC(this.passed_qc_box.isSelected());
        this.globals.setShowFailedQC(this.failed_qc_box.isSelected());
        this.graph.updateGraph();
    }

    private void changeTerrainOptions() {
        this.globals.setShowSea(this.sea_box.isSelected());
        this.globals.setShowNonsea(this.nonsea_box.isSelected());
        this.globals.setShowSeaAndNonsea(this.sea_and_nonsea_box.isSelected());
        this.graph.updateGraph();
    }

    private void changeCloudOptions() {
        this.globals.setShowClear(this.clear_box.isSelected());
        this.globals.setShowCloudy(this.cloudy_box.isSelected());
        this.globals.setShowClearAndCloudy(this.clear_and_cloudy_box.isSelected());
        this.graph.updateGraph();
    }

    public void changeGraphSettings() {
        GraphOptionsDialog graphOptionsDialog;
        int n = 1;
        if (this.level_type == 1) {
            n = 2;
        }
        if ((graphOptionsDialog = new GraphOptionsDialog(this.parent, n)).okButtonPressed()) {
            this.graph.newTimeWindow();
        }
    }

    public void changeGraphLines() {
        this.graph.changeGraphLines();
    }

    public void makeImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(Color.black);
        int n5 = (int)((float)n3 * 0.15f);
        int n6 = n3 - n5;
        graphics2D.setClip(n + n6, n2, n5, n4);
        this.graph.drawLegend(graphics2D, n + n6, n2, n5, n4);
        graphics2D.setClip(null);
        graphics2D.setClip(n, n2, n6, n4);
        this.graph.drawGraph(graphics2D, n, n2, n6, n4);
        graphics2D.setClip(null);
    }
}

