#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


$nprovs_dir = "/data/data065/nprovs/data/matchup/nprovsNPP_daily_files";

$ftp_dir = "/net/www/aftp/pub/smcd/opdb/nprovs/daily_files";


printf("Copying the daily files to the ftp directory\n\n");


# Search the archive directory an remove any file was created
# more than 365 days ago

my @tempfiles = glob $ftp_dir . "/NPROVS*";

foreach $file (@tempfiles)
  {
#  if (-M $file > 364)
#    {
    unlink $file;
#    }
  }




# Get the starting (11 days ago) and ending (yesterday) dates

$today = time();
$yesterday = $today - (2 * 86400);
$data_date = $today - (12 * 86400);


# Loop through each date

while ($data_date < $yesterday)
  {
  $data_date += 86400;

  ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_date);
  $year += 1900;
  $mon++;
  $sec = 0;
  $min = 0;
  $hour = 12;
  $wday = 0;
  $yday = 0;
  $isdst = 0;

  $day_of_data = ($year * 10000) + ($mon * 100) + $mday;

  $from_file = $nprovs_dir . "/NPROVS_" . $day_of_data;
  $to_file   = $ftp_dir . "/NPROVS_" . $day_of_data;

  printf("Copying from: %s\n", $from_file);
  printf("          to: %s\n\n", $to_file);

  copy($from_file, $to_file);
  }  # while...


printf("Copying completed.\n\n");

# end of file
