#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;
use Net::FTP;

my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs_test/metopa";

chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;



# Copy all of the available netcdf files from the ftp server

my $snd_pattern = "NPR-MIRS-SND_v11r2_ma2*.nc";
my $img_pattern = "NPR-MIRS-IMG_v11r2_ma2*.nc";

my $ftp_server = "cw-okeanos.noaa.gov";
##my $user_id = '#####';
##my $password = '#####';

my $ftp = Net::FTP->new($ftp_server, Debug => 0)
  or die "Cannot connect to: " . $ftp_server . "\n";

$ftp->login()
  or die "Cannot login: ", $ftp->message;

$ftp->binary
  or die "Cannot change to binary mode: ", $ftp->message;

$ftp->cwd("pub/data1/Temp/HMS/MIRS-V11")
  or die "Cannot change directories: ", $ftp->message;


mget($ftp, $snd_pattern);
mget($ftp, $img_pattern);


$ftp->quit;





# Use the subroutine mget to transfer all of the files on the
# server that match the pattern. Before each file is transfered,
# however, check to see if it already exists. If it does then 
# do not bother transfering it again.

sub mget
  {
  my ($ftp, $fpattern) = @_;

  foreach my $file($ftp->ls($fpattern))
    {
    if (! (-e $file))
      {
      printf("Transfering:  %s\n", $file);
      $ftp->get($file) or warn $ftp->message;
      }
    }
  }

# end of file
