#!/usr/bin/perl -w
#

use Net::FTP;
use Time::Local;


# Remove older files from the incoming directory

my $incoming_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps";

my @tempfiles = glob $incoming_dir . "/NUCAPS-EDR*";

foreach $file (@tempfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }



# Transfer the NUCAPS files from the STAR FTP server


print "======================================================\n";
print "Transfering the NUCAPS granules\n\n";
system "date";
print "\n\n";


my $ftp_server = "ftp2.star.nesdis.noaa.gov";
#my $user_id = '#####';
#my $password = '#####';


# Build the file pattern based on chosen date. This date
# will be determined by the command line argument which
# indicates the number of days back (today=0, yesterday=1, etc)

my $daysback = $ARGV[0];

($sec, $min, $hour, $day, $mon, $year) = localtime(time()-($daysback*86400));

$mon = $mon + 1;
$year = 1900 + $year;

$sec++;
$min++;
$hour++;


#my $pattern = sprintf "NUCAPS-EDR_v1r0_npp_s%04d%02d%02d*", $year, $mon, $day;
my $pattern = sprintf "NUCAPS-EDR*_s%04d%02d%02d*", $year, $mon, $day;


printf("FTP transfer target date %d/%2d/%d\n\n", $mon, $day, $year);


# Switch to the incoming NUCAPS file directory

chdir $incoming_dir;


# Do the FTP

my $ftp = Net::FTP->new($ftp_server, Debug => 0)
  or die "Cannot connect to: " . $ftp_server . "\n";

$ftp->login()
  or die "Cannot login: ", $ftp->message;

$ftp->binary
  or die "Cannot change to binary mode: ", $ftp->message;

$ftp->cwd("smcd/tking/NUCAPS/EDR")
  or die "Cannot change directories: ", $ftp->message;


mget($ftp, $pattern);


$ftp->quit;

printf("\n");



# Use the subroutine mget to transfer all of the files on the
# server that match the pattern. Before each file is transfered,
# however, check to see if it already exists. If it does then 
# do not bother transfering it again.

sub mget
  {
  my ($ftp, $fpattern) = @_;

  foreach my $file($ftp->ls($fpattern))
    {
    if (! (-e $file))
      {
      printf("Transfering:  %s\n", $file);
      $ftp->get($file) or warn $ftp->message;
      }
    }
  }

# end of file
