#!/usr/bin/perl -w
#

use File::Copy;
use Time::Local;

my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs_v11";

chdir $raw_data_dir;


# ===============================================================
# Copy the multiple MIRS NPP EDR's into an MDDF

print "\n\n";
print "Processing MIRS v11 NPP EDRs";
print "\n";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_date = 20170116;


chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;


my $mddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/mirs_npp_v11_" . $data_date . ".mddf";


#unlink $mddf_file;



# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/data/data065/nprovs/source/data_transfer/mirs/initmddf/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run MirsToMDDF for each EDR

$file_location_dir = $raw_data_dir . sprintf("/nc/npp_atms/2017-01-16");


printf("file dir: %s\n", $file_location_dir);


#my @mirsfiles = glob $file_location_dir . "/NPR-MIRS-SND*";
my @mirsfiles = glob $file_location_dir . "/SND_TMS_npp*";


foreach $snd_file (@mirsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $snd_file, "\n\n";

  # Build the name of a matching IMG file

  #$string1 = "NPR-MIRS-SND";
  #$string2 = "NPR-MIRS-IMG";
  $string1 = "SND_TMS_npp";
  $string2 = "IMG_TMS_npp";

  $img_file = $snd_file;
  $img_file =~ s/$string1/$string2/g;

  if (-e $img_file)
    {

    # Link the output file

    symlink $mddf_file, "out.file" or warn "Cannot link $mddf_file to unit.12";

    # Run MIRStoMDDF

    system "/data/data065/nprovs/source/data_transfer/mirs/netcdf/MIRStoMDDF.x $snd_file $img_file $data_date";

    # Unlink the file

    unlink "out.file" or warn "Cannot unlink the unit.12 file";
    }
  else
    {
    printf("\n\n***** NO MATCH MADE *****\n\n");
    }
  }

# end of file
