#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;

#system "LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/data/starfs1/libs/netcdf-4.2/lib:/data/starfs1/libs/hdf5-1.8.7/lib";
#system "export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}";


# This script copies data from multiple NUCAPS granule files into an IDDF

print " ";
print "Processing the NUCAPS data";
print " ";
system "date";
print "\n\n";


my $in_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps_special";
my $out_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/nucaps_special";


#================================================================================
# Define the date range

#$first_date = 20150428;
#$last_date  = 20150713;
$first_date = 20150711;
$last_date  = 20150713;

$year = $first_date / 10000;
$mon  = (($first_date % 10000) / 100) - 1;
$day  = $first_date % 100;

$data_date = timelocal(12, 0, 0, $day, $mon, $year);
$data_date = $data_date - 86400;

$year = $last_date / 10000;
$mon  = (($last_date % 10000) / 100) - 1;
$day  = $last_date % 100;

$end_date = timelocal(12, 0, 0, $day, $mon, $year);


# Loop through the date range and process the files that exist and
# are within the range

while ($data_date < $end_date)
  {
  $data_date += 86400;

  ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_date);
  $year += 1900;
  $mon++;
  $sec = 0;
  $min = 0;
  $hour = 12;
  $wday = 0;
  $yday = 0;
  $isdst = 0;

  $date_to_process = ($year * 10000) + ($mon * 100) + $mday;

  $year  = $date_to_process / 10000;
  $month = ($date_to_process % 10000) / 100;
  $day   = $date_to_process % 100;

  printf("\n\n============================================================\n");
  printf("============================================================\n");
  printf("============================================================\n");
  printf("Date to be processed:  %d\n\n", $date_to_process);


  #================================================================================
  # Copy the files from SCDR to the incoming directory

  printf ("Copying the NUCAPS data to the raw data directory\n");

  chdir $in_dir;
  system "rm NUCAPS-EDR*";


  $scdr_exec = sprintf("/data/starfs1/bin/scdr-files -t NUCAPS-EDR -d %04d-%02d-%02d | xargs -L100 -P2 cp -t %s", $year, $month, $day,  $in_dir);

  system $scdr_exec;


  #================================================================================
  # Remove the previous IDDF

  my $iddf_file = $out_dir . "/nucaps_" . $date_to_process . ".iddf";

  unlink $iddf_file;


  #================================================================================
  # Run NUCAPStoIDDF for each NUCAPS file

  my @nucapsfiles = glob $in_dir . "/NUCAPS-EDR*.nc";


  foreach $file (@nucapsfiles)
    {
    print "\n-------------------------------\n";
    print "Processing file: ". $file, "\n\n";

    # Link the files

    symlink $file, "in.file" or warn "Cannot link $file to in.file";
    symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

    # Run NUCAPStoIDDF

    system "/data/data065/nprovs/source/data_transfer/nucaps/version2/NUCAPStoIDDF.x " . $date_to_process . " " . $file;

    # Unlink the files

    unlink "in.file" or warn "Cannot unlink the in.file";
    unlink "out.file" or warn "Cannot unlink the out.file";
    }

  printf("gzipping the file...\n");
  system "gzip " . $iddf_file;
  }  # while ($data_date < $last_date...


printf("\n\n\nFinished processing\n\n\n");

# end of file
