#!/usr/bin/perl -w
#

# This script copies data from multiple IASI granule files into an IDDF

print "\n";
print "Processing the IASI data";
print "\n";
system "date";
print "\n\n";


my $incoming_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/iasi/";

my $iddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/iasi.iddf";



# Remove the previous IDDF

unlink $iddf_file or warn "Cannot unlink the iddf file";



# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);

#$data_date = 20080730;



# Run IasiToIDDF for each IASI file

my @iasifiles = glob $incoming_dir . "IASI_L02_M02_*.nc";

foreach $file (@iasifiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

  # Run IasiToIDDF

  #system "/data/data065/nprovs/source/data_transfer/iasi/IASItoIDDF.x $data_date";
  system "/data/data065/nprovs/source/data_transfer/iasi/version1/IASItoIDDF.x $data_date";

  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";

  # Remove the IASI granule file

#  unlink $file or warn "Cannot remove the IASI granule file: $file";
  }



# Search the incoming directory and remove any file the was created
# more than 2 days ago

my @tempfiles = glob $incoming_dir . "/IASI*";

foreach $file (@tempfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }




# end of file
