#!/usr/bin/perl -w
#

use File::Copy;
use Time::Local;

my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs_v11";

chdir $raw_data_dir;


# Search the incoming directory and remove any file that was created
# more than 2 days ago

#my @tempfiles = glob $raw_data_dir . "/EDR*";

#foreach $file (@tempfiles)
#  {
#  if (-M $file > 1)
#    {
#    unlink $file;
#    }
#  }



# Build the directory string where the previous day's EDR's should be

$yesterday = time();
$yesterday -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($yesterday);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 12;
$wday = 0;
$yday = 0;
$isdst = 0;


$edr_dir  = "/data/aftp-smcd/mirs/archive/v11r1/edr/npp_atms";
$targz_file = sprintf("npp_atms_edr_%d-%02d-%02d_v11r1.tar.gz", $year, $mon, $mday);
$tar_file = sprintf("npp_atms_edr_%d-%02d-%02d_v11r1.tar", $year, $mon, $mday);


# Copy the tar.gz file in the directory to the incoming data directory

$from_file = $edr_dir . "/" . $targz_file;
$to_file   = $raw_data_dir . "/" . $targz_file;


# Check to see if the file exists. If it does, then continue processing. 
# Otherwise, go into a sleep loop (no more than 16 iterations - 4 hours) 
# until the file is available

my $sleep_length = 15;  # minutes
my $max_loops = 16;
my $wait_loop_count = 0;

while (! -e $from_file)
  {
  $wait_loop_count++;

  if ($wait_loop_count <= $max_loops)
    {
    printf("File not available, sleeping for %d minutes\n", $sleep_length);
    printf("Loop count:  %d out of %d\n", $wait_loop_count, $max_loops);
    system "date";
    printf("\n\n");
    sleep $sleep_length * 60;
    }
  else
    {
    printf("\n\n***** File never available. Quitting\n\n");

    system "echo 'Subject: Failure of MIRS NPP v11 transfer' > /data/data065/nprovs/scripts/data_input/mirsv11_mail.txt";
    system "echo 'The MIRS NPP v11 was not available' >> /data/data065/nprovs/scripts/data_input/mirsv11_mail.txt";
    system "date >> /data/data065/nprovs/scripts/data_input/mirsv11_mail.txt";

    system "/usr/sbin/sendmail Michael.Pettey\@noaa.gov </data/data065/nprovs/scripts/data_input/mirsv11_mail.txt";
    system "rm /data/data065/nprovs/scripts/data_input/mirsv11_mail.txt";

    system "/data/data065/nprovs/scripts/graphics/run_mirs_npp_v11_ods_capture";

    exit 1;
    }
  }


printf("\n\nThe file is available. Processing continuing.\n");

# Sleep another 15 minutes before copying the file to make sure that the 
# entire file is available
sleep 15 * 60;

system "date";

printf("\nCopying the file: %s\n", $from_file);
copy($from_file, $to_file);


# Unzip and untar the files

printf("gunzipping the file...\n");
system "gunzip " . $to_file;

printf("untarring the file...\n");
system "tar -xvf " . $raw_data_dir . "/" . $tar_file;

unlink $tar_file;


# ===============================================================
# Copy the multiple MIRS NPP EDR's into an MDDF

print "\n\n";
print "Processing MIRS v11 NPP EDRs";
print "\n";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 12;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20080730;


chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;


my $mddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/mirs_npp_v11.mddf";
##my $mddf_backup = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/mirs_test_npp.mddf.bkp";


#unlink $mddf_file;



# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/data/data065/nprovs/source/data_transfer/mirs/mddf/version05/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run MirsToMDDF for each EDR

$file_location_dir = $raw_data_dir . sprintf("/edr/npp_atms/%4d-%02d-%02d", $year, $mon, $mday);


printf("file dir: %s\n", $file_location_dir);


my @mirsfiles = glob $file_location_dir . "/EDR*";


foreach $file (@mirsfiles)
  {

  # Copy the MDDF to a backup in case an error occurs

  #copy($mddf_file, $mddf_backup);

  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "fort.11" or warn "Cannot link $file to fort.11";
  symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

  # Run MirsToMDDF

  system "/data/data065/nprovs/source/data_transfer/mirs/mddf/npp_qc_version/MirsToMDDF.x <<EOD 
    $data_date 
EOD";

  # If an error occurred in MirsToMDDF, replace the updated MDDF 
  # with the previous version

#  if ($?)
#    {
#    print "**************************\n";
#    print "An error occurred ($?)\n";
#    print "Replacing the updated MDDF with the previous version.\n";
#    print "**************************\n";

#    copy($mddf_backup, $mddf_file);
#    }

  # Unlink the files

  unlink "fort.11" or warn "Cannot unlink the unit.11 file";
  unlink "fort.12" or warn "Cannot unlink the unit.12 file";

  # Remove the EDR

  #unlink $file or warn "Cannot remove the EDR: $file";
  }


# Remove the backup MDDF

#unlink $mddf_backup;



# Remove the granules and the directory structure that was created during the 
# tar -xvf step

$file_location_dir = $raw_data_dir . sprintf("/edr/npp_atms/%4d-%02d-%02d", $year, $mon, $mday);

@tempfiles = glob $file_location_dir . "/EDR*";

foreach $file (@tempfiles)
  {
  unlink $file;
  }

system "rmdir " . $file_location_dir;

$file_location_dir = $raw_data_dir . sprintf("/edr/npp_atms");
system "rmdir " . $file_location_dir;

$file_location_dir = $raw_data_dir . sprintf("/edr");
system "rmdir " . $file_location_dir;



# Capture data from the MIRS daily data file (MDDF) and write
# the data to ODS files.

system "/data/data065/nprovs/scripts/graphics/run_mirs_npp_v11_ods_capture";

# end of file
