#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs/metopc";

chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;


# Search the incoming directory and remove any netcdf file that was 
# created more than 2 days ago

my @tempfiles = glob $raw_data_dir . "/*.nc";

foreach $file (@tempfiles)
  {
  if (-M $file > 3)
    {
    unlink $file;
    }
  }



# ==================================================================
# Copy the multiple MIRS granules into a MIRS Daily Data File (MDDF)

print "\n\n";
print "Processing MIRS MetOp-C Granules";
print "\n";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 12;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20160831;


$year = $data_date / 10000;
$mon  = ($data_date % 10000) / 100;
$mday = $data_date % 100;


# Transfer the granules from FTP

$ftp_file = sprintf("metopC_amsua_nc_%4d-%02d-%02d_v11r4dev", $year, $mon, $mday);

#printf("FTP FILE: %s\n", $ftp_file);


$from_file = "/data/aftp-smcd/mirs/archive/dev/nc/metopC_amsua/" . $ftp_file . ".tar.gz";
$to_file = $raw_data_dir . "/" . $ftp_file . ".tar.gz";

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);

system "gunzip $to_file";

system "tar -xvf " . $raw_data_dir . "/" . $ftp_file . ".tar";


$temp_dir = sprintf("%s/nc/metopC_amsua/%d-%02d-%02d", $raw_data_dir, $year, $mon, $mday);

system "mv " . $temp_dir . "/*.nc " . $raw_data_dir;

unlink $raw_data_dir . "/" . $ftp_file . ".tar";

system "rmdir $temp_dir";
system "rmdir " . $raw_data_dir . "/nc/metopC_amsua";
system "rmdir " . $raw_data_dir . "/nc";



# Set up the daily file name and remove the previous file

my $mddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/mirs_metopc.mddf";

unlink $mddf_file;


# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/data/data065/nprovs/source/data_transfer/mirs/initmddf/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run MirsToMDDF for each EDR

#my @mirsfiles = glob $raw_data_dir . "/NPR-MIRS-SND*";
#my @mirsfiles = glob $raw_data_dir . "/NPR-MIRS-SND*ma3*";
my @mirsfiles = glob $raw_data_dir . "/SND_SX.M3*";


foreach $snd_file (@mirsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $snd_file, "\n\n";

  # Build the name of a matching IMG file

  #$string1 = "NPR-MIRS-SND";
  #$string2 = "NPR-MIRS-IMG";
  $string1 = "SND_SX.M3";
  $string2 = "IMG_SX.M3";

  $img_file = $snd_file;
  $img_file =~ s/$string1/$string2/g;

  if (-e $img_file)
    {

    # Link the output file

    symlink $mddf_file, "out.file" or warn "Cannot link $mddf_file to unit.12";

    # Run MIRStoMDDF

    system "/data/data065/nprovs/source/data_transfer/mirs/netcdf/MIRStoMDDF.x $snd_file $img_file $data_date";

    # Unlink the file

    unlink "out.file" or warn "Cannot unlink the unit.12 file";
    }
  else
    {
    printf("\n\n***** NO MATCH MADE *****\n\n");
    }
  }



#===================================================================
# Copy the daily file to the orbital archive and the backup archive

$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$archive_dir  = "/data/data215/nprovs/data/orbital_archive";
$archive_dir2 = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";

printf("Copying the daily files to the archive directory\n\n");

printf("Making a copy of the daily file...\n\n");
$from_file = $mddf_file;
$to_file = $nprovs_dir . sprintf("/mirs_metopc_%d.mddf", $data_date);
copy($from_file, $to_file);

printf("Gzipping the file...\n\n");
$gzip_file = sprintf("mirs_metopc_%d.mddf", $data_date) . ".gz";
system "gzip " . $to_file;

printf("Copying to the main orbital archive...\n");
$from_file = $nprovs_dir . "/" . $gzip_file;
$to_file = $archive_dir . "/mirs_metopc/" . $gzip_file;
printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);
copy($from_file, $to_file);

printf("Copying to the backup orbital archive...\n");
$to_file = $archive_dir2 . "/mirs_metopc/" . $gzip_file;
printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);
copy($from_file, $to_file);

unlink $nprovs_dir . "/" . $gzip_file;


# Capture data from the MIRS daily data file (MDDF) and write
# the data to ODS files.

system "/data/data065/nprovs/scripts/graphics/run_mirs_metopc_ods_capture";


# end of file
