#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;
use Net::FTP;

my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs_test/ssmisf17";

chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;


# Search the incoming directory and remove any netcdf file that was 
# created more than 2 days ago

my @tempfiles = glob $raw_data_dir . "/*.nc";

foreach $file (@tempfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }


# Copy all of the available netcdf files from the ftp server

my $snd_pattern = "NPR-MIRS-SND_v11r2_f17*.nc";
my $img_pattern = "NPR-MIRS-IMG_v11r2_f17*.nc";

my $ftp_server = "cw-okeanos.noaa.gov";
##my $user_id = '#####';
##my $password = '#####';

my $ftp = Net::FTP->new($ftp_server, Debug => 0)
  or die "Cannot connect to: " . $ftp_server . "\n";

$ftp->login()
  or die "Cannot login: ", $ftp->message;

$ftp->binary
  or die "Cannot change to binary mode: ", $ftp->message;

$ftp->cwd("pub/data1/Temp/HMS/MIRS-V11")
  or die "Cannot change directories: ", $ftp->message;


mget($ftp, $snd_pattern);
mget($ftp, $img_pattern);


$ftp->quit;


# ==================================================================
# Copy the multiple MIRS granules into a MIRS Daily Data File (MDDF)

print "\n\n";
print "Processing MIRS Granules";
print "\n";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 12;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20160831;


# Set up the daily file name and remove the previous file

my $mddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/mirs_test_ssmisf17.mddf";

unlink $mddf_file;


# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/data/data065/nprovs/source/data_transfer/mirs/initmddf/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run MirsToMDDF for each EDR

my @mirsfiles = glob $raw_data_dir . "/NPR-MIRS-SND*";


foreach $snd_file (@mirsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $snd_file, "\n\n";

  # Build the name of a matching IMG file

  $string1 = "NPR-MIRS-SND";
  $string2 = "NPR-MIRS-IMG";

  $img_file = $snd_file;
  $img_file =~ s/$string1/$string2/g;

  if (-e $img_file)
    {

    # Link the output file

    symlink $mddf_file, "out.file" or warn "Cannot link $mddf_file to unit.12";

    # Run MIRStoMDDF

    system "/data/data065/nprovs/source/data_transfer/mirs/netcdf/MIRStoMDDF.x $snd_file $img_file $data_date";

    # Unlink the file

    unlink "out.file" or warn "Cannot unlink the unit.12 file";
    }
  else
    {
    printf("\n\n***** NO MATCH MADE *****\n\n");
    }
  }



#===================================================================
# Copy the daily file to the orbital archive and the backup archive

$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$archive_dir  = "/data/data215/nprovs/data/orbital_archive";
$archive_dir2 = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";


printf("Copying the daily files to the archive directory\n\n");


$from_file = $nprovs_dir . "/mirs_test_ssmisf17.mddf";
$to_file = $archive_dir . sprintf("/mirs_test_ssmis_f17/mirs_test_ssmis_f17_%d.mddf", $data_date);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);

system "gzip $to_file";


$from_file = $to_file . ".gz";
$to_file = $archive_dir2 . sprintf("/mirs_test_ssmis_f17/mirs_test_ssmis_f17_%d.mddf.gz", $data_date);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);


# Capture data from the MIRS daily data file (MDDF) and write
# the data to ODS files.

#system "/data/data065/nprovs/scripts/graphics/run_mirs_test_ssmisf17_ods_capture";





# Use the subroutine mget to transfer all of the files on the
# server that match the pattern. Before each file is transfered,
# however, check to see if it already exists. If it does then 
# do not bother transfering it again.

sub mget
  {
  my ($ftp, $fpattern) = @_;

  foreach my $file($ftp->ls($fpattern))
    {
    if (! (-e $file))
      {
      printf("Transfering:  %s\n", $file);
      $ftp->get($file) or warn $ftp->message;
      }
    }
  }

# end of file
