#!/usr/bin/perl -w
#

use File::Copy;
use Time::Local;


my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs_test_ssmisf18";

chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;



# Search the incoming directory and remove any file that was created
# more than 2 days ago

my @tempfiles = glob $raw_data_dir . "/EDR*";

foreach $file (@tempfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }



# Build the file name string where the previous day's EDR's should be

$yesterday = time();
$yesterday -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($yesterday);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 12;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);


$edr_dir  = "/data/www-smcd/mirs/data";
$targz_file = sprintf("f18_mirs_edr_dep_%04d%02d%02d.tar.gz", $year, $mon, $mday);
$tar_file = sprintf("f18_mirs_edr_dep_%04d%02d%02d.tar", $year, $mon, $mday);


# Copy the tar.gz file in the directory to the incoming data directory

$from_file = $edr_dir . "/" . $targz_file;
$to_file   = $raw_data_dir . "/" . $targz_file;



# Check to see if the file exists. If it does, then continue processing. 
# Otherwise, go into a sleep loop (no more than 16 iterations - 4 hours) 
# until the file is available

my $sleep_length = 15;  # minutes
my $max_loops = 16;
my $wait_loop_count = 0;

while (! -e $from_file)
  {
  $wait_loop_count++;

  if ($wait_loop_count <= $max_loops)
    {
    printf("File not available, sleeping for %d minutes\n", $sleep_length);
    printf("Loop count:  %d out of %d\n", $wait_loop_count, $max_loops);
    system "date";
    printf("\n\n");
    sleep $sleep_length * 60;
    }
  else
    {
    printf("\n\n***** File never available. Quitting\n\n");

    system "echo 'Subject: Failure of MIRS Test SSMIS F18 transfer' > " . $raw_data_dir . "/mirs_mail.txt";
    system "echo 'The MIRS Test SSMIS F18 was not available' >> " .$raw_data_dir . "/mirs_mail.txt";
    system "date >> " . $raw_data_dir . "/mirs_mail.txt";

    system "/usr/sbin/sendmail Michael.Pettey\@noaa.gov <" . $raw_data_dir . "/mirs_mail.txt";
    system "rm " . $raw_data_dir . "/mirs_mail.txt";

    system "/data/data065/nprovs/scripts/graphics/run_mirs_test_ssmisf18_ods_capture";

    exit 1;
    }
  }


printf("\n\nThe file is available. Processing continuing.\n");

# Sleep another 15 minutes before copying the file to make sure that the 
# entire file is available
sleep 15 * 60;

system "date";

printf("\nCopying the file: %s\n", $from_file);
copy($from_file, $to_file);


# Unzip and untar the files

printf("gunzipping the file...\n");
system "gunzip " . $to_file;

printf("untarring the file...\n");
system "tar -xvf " . $raw_data_dir . "/" . $tar_file;

unlink $tar_file;



# ===============================================================
# Copy the multiple MIRS EDR's into an MDDF

print "\n\n";
print "Processing MIRS EDRs";
print "\n";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20080730;


#chdir "/data/data065/nprovs/source/data_transfer/mirs/mddf/version03";
chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;


my $mddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/ssmis_test_f18.mddf";
my $mddf_backup = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/ssmis_test_f18.mddf.bkp";

unlink $mddf_file;



# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/data/data065/nprovs/source/data_transfer/mirs/initmddf/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run MirsToMDDF for each EDR

my @mirsfiles = glob $raw_data_dir . "/EDR*";

foreach $edr_file (@mirsfiles)
  {

  # Copy the MDDF to a backup in case an error occurs

  #copy($mddf_file, $mddf_backup);

  print "\n-------------------------------\n";
  print "Processing file: ". $edr_file, "\n\n";

  # Build the name of a matching IMG file

  $string1 = "EDR_";
  $string2 = "DEP_";

  $dep_file = $edr_file;
  $dep_file =~ s/$string1/$string2/g;

  if (-e $dep_file)
    {
    print "Matching file:   ". $dep_file, "\n\n";

    # Link the files

    symlink $edr_file, "fort.11" or warn "Cannot link $file to fort.11";
    symlink $dep_file, "fort.12" or warn "Cannot link $file to fort.12";
    symlink $mddf_file, "fort.13" or warn "Cannot link $mddf_file to fort.13";

    # Run MirsToMDDF

  system "/data/data065/nprovs/source/data_transfer/mirs/edrdep/MirsToMDDF.x <<EOD 
    $data_date 
EOD";

    # If an error occurred in MirsToMDDF, replace the updated MDDF 
    # with the previous version

    if ($?)
      {
      print "**************************\n";
      print "An error occurred ($?)\n";
      print "Replacing the updated MDDF with the previous version.\n";
      print "**************************\n";

      copy($mddf_backup, $mddf_file);
      }

    # Unlink the files

    unlink "fort.11" or warn "Cannot unlink the unit.11 file";
    unlink "fort.12" or warn "Cannot unlink the unit.12 file";
    unlink "fort.13" or warn "Cannot unlink the unit.13 file";
    }
  }


# Remove the backup MDDF

unlink $mddf_backup;




# Search the incoming directory and remove all files before 20Z. This will free up
# space and also speed the job up the next time it runs since there won't be as
# many files from the day before to look through.

@tempfiles = glob $raw_data_dir . "/EDR*S0*";

foreach $file (@tempfiles)
  {
  unlink $file;
  }

@tempfiles = glob $raw_data_dir . "/EDR*S1*";

foreach $file (@tempfiles)
  {
  unlink $file;
  }

@tempfiles = glob $raw_data_dir . "/DEP*S0*";

foreach $file (@tempfiles)
  {
  unlink $file;
  }

@tempfiles = glob $raw_data_dir . "/DEP*S1*";

foreach $file (@tempfiles)
  {
  unlink $file;
  }


#===================================================================
# Copy the daily file to the orbital archive and the backup archive

$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$archive_dir  = "/data/data215/nprovs/data/orbital_archive";
$archive_dir2 = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";


printf("Copying the daily files to the archive directory\n\n");


# Get yesterday's date
$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;


# Copy and gzip the file to the first archive
$from_file = $nprovs_dir . "/ssmis_test_f18.mddf";
$to_file = $archive_dir . sprintf("/mirs_test_ssmis_f18/mirs_test_ssmis_f18_%d%02d%02d.mddf", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);

system "gzip $to_file";


# Copy the gzipped file to the backup archive
$from_file = $to_file . ".gz";
$to_file = $archive_dir2 . sprintf("/mirs_test_ssmis_f18/mirs_test_ssmis_f18_%d%02d%02d.mddf.gz", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);




# Capture data from the MIRS daily data file (MDDF) and write
# the data to ODS files.

system "/data/data065/nprovs/scripts/graphics/run_mirs_test_ssmisf18_ods_capture";

# end of file
