#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


BEGIN
  {
  $ENV{LD_LIBRARY_PATH}="LD_LIBRARY_PATH:/data/starfs1/libs/netcdf-4.2/lib:/data/starfs1/libs/hdf5-1.8.7/lib";
  }


# This script copies data from multiple NUCAPS granule files into an IDDF

print " ";
print "Processing the NUCAPS NPP data";
print " ";
system "date";
print "\n\n";

my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps_npp";
my $incoming_template = "NUCAPS-EDR_v2r0_npp_";

chdir $raw_data_dir;

# Search the incoming directory and remove any file that was created
# more than 2 days ago

my @tempfiles = glob $raw_data_dir . "/" . $incoming_template . "*.nc";

foreach $file (@tempfiles)
  {
  if (-M $file > 1)
    {
    unlink $file;
    }
  }


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20170521;

printf("Date to be processed:  %d\n\n", $data_date);



#-------------------------------------------------------------------------
# Copy the files for the selected date from SCDR to the incoming directory

printf("\nCopying the data from SCDR...\n\n");

system "/data/starfs1/bin/scdr-files -t NUCAPS-EDR --re-file _npp_ -d yesterday | xargs -L100 -P2 cp -t " . $raw_data_dir;



my $iddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/nucaps.iddf";



# Remove the previous IDDF

#unlink $iddf_file or warn "Cannot unlink the iddf file";
unlink $iddf_file;



# Run NUCAPStoIDDF for each NUCAPS file

my @nucapsfiles = glob $raw_data_dir . "/" . $incoming_template . "*.nc";


foreach $file (@nucapsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

  # Run NUCAPStoIDDF

  system "/data/data065/nprovs/source/data_transfer/nucaps/IASItoIDDF.x " . $data_date . " " . $file;

  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";
  }



#===================================================================
# Copy the daily file to the orbital archive and the backup archive
# and gzip them

$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$archive_dir  = "/data/data599/orbital_archive";
$archive_dir2 = "/data/data215/nprovs/data/orbital_archive";
#$archive_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";

printf("Copying the daily files to the archive directory\n\n");

printf("Making a copy of the daily file...\n\n");
$from_file = $iddf_file;
$to_file = $nprovs_dir . sprintf("/nucaps_%d.iddf", $data_date);
copy($from_file, $to_file);

printf("Gzipping the file...\n\n");
$gzip_file = sprintf("/nucaps_%d.iddf", $data_date) . ".gz";
system "gzip " . $to_file;

printf("Copying to the main orbital archive...\n");
$from_file = $nprovs_dir . "/" . $gzip_file;
$to_file = $archive_dir . "/nucaps_npp/" . $gzip_file;
printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);
copy($from_file, $to_file);

printf("Copying to the backup orbital archive...\n");
$to_file = $archive_dir2 . "/nucaps/" . $gzip_file;
printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);
copy($from_file, $to_file);

unlink $nprovs_dir . "/" . $gzip_file;


# end of file
