#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;
use Net::FTP;

# This script copies data from multiple NUCAPS granule files into an IDDF

print " ";
print "Processing the NUCAPS Parallel data";
print " ";
system "date";
print "\n\n";


# $raw_data_dir is the directory where the netCDF granules are located

my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps_parallel";

chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;



#====================================================================
# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD. Or the 1 in the 1*86400 can be changed
# to go back a certain number of days (ie: 2*86400 to process the
# day before yesterday).

$data_day = time();
$data_day -= (1 * 86400);

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20080730;

printf("Date to be processed:  %d\n\n", $data_date);



#====================================================================
# Search the incoming directory and remove any netcdf file that was 
# created more than 2 days ago. This gets rid of older files and
# prevents the directory from becomming too full.

my @tempfiles = glob $raw_data_dir . "/*.nc";

foreach $file (@tempfiles)
  {
  if (-M $file > 1)
    {
    unlink $file;
    }
  }


#====================================================================
# Copy all of the available netcdf files. This has changed over time
# and may continue changing when the files are obtained from different
# location. Initially, the files were obtained from an FTP server but
# that is not currently the case so the ftp steps are commented.
# Currently, the files are copied directly from the ftp directory with
# a cp command.

##my $pattern = "NUCAPS-EDR*.nc";
#$pattern = sprintf("NUCAPS-EDR_v1r0_npp_s%d%02d%02d*", $year, $mon, $mday);

##my $ftp_server = "ftp2.star.nesdis.noaa.gov";
#my $ftp_server = "ftp.star.nesdis.noaa.gov";
###my $user_id = '#####';
###my $password = '#####';

#my $ftp = Net::FTP->new($ftp_server, Debug => 0)
#  or die "Cannot connect to: " . $ftp_server . "\n";

#$ftp->login()
#  or die "Cannot login: ", $ftp->message;

#$ftp->binary
#  or die "Cannot change to binary mode: ", $ftp->message;

##$ftp->cwd("smcd/letitias/NUCAPS/EDR")
##  or die "Cannot change directories: ", $ftp->message;
#$ftp->cwd("pub/smcd/opdb/letitias/NUCAPS/EDR")
#  or die "Cannot change directories: ", $ftp->message;


#mget($ftp, $pattern);


#$ftp->quit;


#$pattern = sprintf("/net/www/aftp/pub/smcd/opdb/letitias/NUCAPS/EDR/NUCAPS-EDR_v2r0_npp_s%d%02d%02d*", $year, $mon, $mday);

#$pattern = sprintf("/data/data311/letitias/DATA_ARCHIVE/NUCAPS-EDR/%d%02d%02d/NUCAPS-EDR*", $year, $mon, $mday);
$pattern = sprintf("/data/data311/letitias/DATA_ARCHIVE/NUCAPS-EDR/%d%02d%02d/NUCAPS-EDR_v2r0_j01*", $year, $mon, $mday);

system 'cp ' . $pattern . ' ' . $raw_data_dir;



#====================================================================
# Remove the previous daily file (IDDF)

my $iddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/nucaps_parallel.iddf";

#unlink $iddf_file or warn "Cannot unlink the iddf file";
unlink $iddf_file;



# Run IASItoIDDF for each NUCAPS granule

my @nucapsfiles = glob $raw_data_dir . "/NUCAPS-EDR*.nc";


foreach $file (@nucapsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

  # Run NUCAPStoIDDF

  system "/data/data065/nprovs/source/data_transfer/nucaps/IASItoIDDF.x " . $data_date . " " . $file;

  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";
  }



#===================================================================
# Copy the daily file to the orbital archive and the backup archive
# and gzip them

$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$archive_dir  = "/data/data215/nprovs/data/orbital_archive";
$archive_dir2 = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";


#printf("Copying the daily files to the archive directory\n\n");

# Copy and gzip the file to the first archive
$from_file = $nprovs_dir . "/nucaps_parallel.iddf";
$to_file = $archive_dir . sprintf("/nucaps/nucaps_parallel_%d%02d%02d.iddf", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);

system "gzip $to_file";


# Copy the gzipped file to the backup archive
$from_file = $to_file . ".gz";
$to_file = $archive_dir2 . sprintf("/nucaps/nucaps_parallel_%d%02d%02d.iddf.gz", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);





#===================================================================
# Use the subroutine mget to transfer all of the files on the
# server that match the pattern. Before each file is transfered,
# however, check to see if it already exists. If it does then 
# do not bother transfering it again. This subroutine is used
# when doing an FTP transfer.

sub mget
  {
  my ($ftp, $fpattern) = @_;

  foreach my $file($ftp->ls($fpattern))
    {
    if (! (-e $file))
      {
      printf("Transfering:  %s\n", $file);
      $ftp->get($file) or warn $ftp->message;
      }
    }
  }

# end of file
