#!/usr/bin/perl -w
#

# This script copies data from multiple NUCAPS granule files into an IDDF

print " ";
print "Processing the NUCAPS data";
print " ";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);

#*********************
#*********************
#*********************
$data_date = 20150112;
#*********************
#*********************
#*********************

printf("Date to be processed:  %d\n\n", $data_date);



#*********************
#*********************
#*********************
my $iddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/nucaps_20150112.iddf";
#*********************
#*********************
#*********************



# Remove the previous IDDF

#unlink $iddf_file or warn "Cannot unlink the iddf file";
unlink $iddf_file;



# Run NUCAPStoIDDF for each NUCAPS file

my @nucapsfiles = glob "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps_temp/NUCAPS-EDR*.nc";


foreach $file (@nucapsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

  # Run NUCAPStoIDDF

  system "/data/data065/nprovs/source/data_transfer/nucaps/version2/NUCAPStoIDDF.x " . $data_date . " " . $file;

  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";
  }

# end of file
