#!/usr/bin/perl -w
#

# This script copies data from multiple NUCAPS granule files into an IDDF

print " ";
print "Processing the NUCAPS data";
print " ";
system "date";
print "\n\n";


my $nddf_file = "/data/smcd/nprovs/data/matchup/DailyFiles_incoming/nucaps_swapped.nddf";



# Remove the previous NDDF

#unlink $nddf_file or warn "Cannot unlink the nddf file";
unlink $nddf_file;



# Run NucapsToNDDF for each NUCAPS file

my @nucapsfiles = glob "/data/smcd/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps/NUCAPS-EDR*.nc";


foreach $file (@nucapsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $nddf_file, "out.file" or warn "Cannot link $nddf_file to out.file";

  # Run NucapsToNDDF

  system "/data/smcd/nprovs/source/data_transfer/nucaps/NUCAPStoNDDF_swap.x";

  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";
  }

# end of file
