#!/usr/bin/perl -w
#
use Net::FTP;
use Time::Local;


# This script copies data from multiple NUCAPS granule files into an IDDF

print " ";
print "Processing the NUCAPS data";
print " ";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20080730;

printf("Date to be processed:  %d\n\n", $data_date);




# Remove older files from the incoming directory

my $incoming_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps_test";

my @tempfiles = glob $incoming_dir . "/NUCAPS*";

foreach $file (@tempfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }



# Transfer the NUCAPS files from the STAR FTP server

print "======================================================\n";
print "Transfering the NUCAPS granules\n\n";
system "date";
print "\n\n";


my $ftp_server = "ftp2.star.nesdis.noaa.gov";
#my $user_id = '#####';
#my $password = '#####';


# Build the file pattern based on chosen date. This date
# will be determined by the command line argument which
# indicates the number of days back (today=0, yesterday=1, etc)

#my $daysback = $ARGV[0];

#($sec, $min, $hour, $day, $mon, $year) = localtime(time()-($daysback*86400));

#$mon = $mon + 1;
#$year = 1900 + $year;

#$sec++;
#$min++;
#$hour++;

#my $pattern = sprintf "NUCAPS-EDR_v1r0_npp_s%04d%02d%02d*", $year, $mon, $day;
my $pattern = sprintf "NUCAPS-EDR_v1r0_npp*";

#printf("FTP transfer target date %d/%2d/%d\n\n", $mon, $day, $year);


# Switch to the incoming NUCAPS file directory

chdir $incoming_dir;


# Do the FTP

$ftp = Net::FTP->new($ftp_server, Debug => 0)
  or die "Cannot connect to: " . $ftp_server . "\n";

$ftp->login()
  or die "Cannot login: ", $ftp->message;

$ftp->binary
  or die "Cannot change to binary mode: ", $ftp->message;

$ftp->cwd("smcd/letitias/NUCAPS/EDR")
  or die "Cannot change directories: ", $ftp->message;

mget($ftp, $pattern);

$ftp->quit;

printf("\n");


#==============================================================
# Process the individual files

my $iddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/nucaps_test.iddf";

# Remove the previous IDDF

#unlink $iddf_file or warn "Cannot unlink the iddf file";
unlink $iddf_file;



# Run NUCAPStoIDDF for each NUCAPS file

my @nucapsfiles = glob $incoming_dir . "/NUCAPS-EDR*.nc";


foreach $file (@nucapsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

  # Run NUCAPStoIDDF

  system "/data/data065/nprovs/source/data_transfer/nucaps/version2/NUCAPStoIDDF.x " . $data_date . " " . $file;
  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";
  }



# Use the subroutine mget to transfer all of the files on the
# server that match the pattern. Before each file is transfered,
# however, check to see if it already exists. If it does then 
# do not bother transfering it again.

sub mget
  {
  my ($ftp, $fpattern) = @_;

  foreach my $file($ftp->ls($fpattern))
    {
    if (! (-e $file))
      {
      printf("Transfering:  %s\n", $file);
      $ftp->get($file) or warn $ftp->message;
      }
    }
  }

# end of file
