#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;
use Net::FTP;

# This script copies data from multiple NUCAPS granule files into an IDDF

print " ";
print "Processing the NUCAPS Test NPP data";
print " ";
system "date";
print "\n\n";


# $raw_data_dir is the directory where the netCDF granules are located

my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps_test/npp";

chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;



#====================================================================
# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD. Or the 1 in the 1*86400 can be changed
# to go back a certain number of days (ie: 2*86400 to process the
# day before yesterday).

$data_day = time();
$data_day -= (1 * 86400);

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20080730;

printf("Date to be processed:  %d\n\n", $data_date);



#====================================================================
# Search the incoming directory and remove any netcdf file that was 
# created more than 2 days ago. This gets rid of older files and
# prevents the directory from becomming too full.

my @tempfiles = glob $raw_data_dir . "/*.nc";

foreach $file (@tempfiles)
  {
  if (-M $file > 1)
    {
    unlink $file;
    }
  }


#====================================================================
# Copy all of the available netcdf files. This has changed over time
# and may continue changing when the files are obtained from different
# location. Initially, the files were obtained from an FTP server but
# that is not currently the case so the ftp steps are commented.
# Currently, the files are copied directly from the ftp directory with
# a cp command.

#$pattern = sprintf("/data/data311/letitias/DATA_ARCHIVE/NUCAPS-EDR/%d%02d%02d/NUCAPS-EDR_v2r0_npp*", $year, $mon, $mday);
#$pattern = sprintf("/data/data092/daniel.lefevre/HEAP/CrIS/NPP/NUCAPS-EDR/%d%02d%02d/NUCAPS-EDR_v2r0_npp*", $year, $mon, $mday);
#$pattern = sprintf("/data/data092/eric.mcwilliams/HEAP/CrIS/NPP/NUCAPS-EDR/%d%02d%02d/NUCAPS-EDR_v3r0_npp*", $year, $mon, $mday);
#$pattern = sprintf("/data/data092/morgan.hobson/HEAP/CrIS/NPP/NUCAPS-EDR/%d%02d%02d/NUCAPS-EDR_v3r0_npp*", $year, $mon, $mday);
$pattern = sprintf("/data/data255/morgan.hobson/HEAP/CrIS/NPP/NUCAPS-EDR/%d%02d%02d/NUCAPS-EDR_v3r0_npp*", $year, $mon, $mday);

system 'cp ' . $pattern . ' ' . $raw_data_dir;



#====================================================================
# Remove the previous daily file (IDDF)

my $incoming_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";

my $iddf_file = $incoming_data_dir . "/nucaps_test_npp.iddf";

#unlink $iddf_file or warn "Cannot unlink the iddf file";
unlink $iddf_file;



# Run IASItoIDDF for each NUCAPS granule

my @nucapsfiles = glob $raw_data_dir . "/NUCAPS-EDR*.nc";


foreach $file (@nucapsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

  # Run NUCAPStoIDDF

  system "/data/data065/nprovs/source/data_transfer/nucaps/IASItoIDDF.x " . $data_date . " " . $file;

  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";
  }



#===================================================================
# Copy the daily file to the orbital archive and the backup archive
# and gzip them

$archive_dir  = "/data/data599/orbital_archive/nucaps_test_npp";
$archive_dir2  = "/data/data215/nprovs/data/orbital_archive/nucaps_test_npp";
#$archive_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive/nucaps_test_npp";


$before_gzip_file = $incoming_data_dir . sprintf("/nucaps_test_npp_%d%02d%02d.iddf", $year, $mon, $mday);
$after_gzip_file  = $incoming_data_dir . sprintf("/nucaps_test_npp_%d%02d%02d.iddf.gz", $year, $mon, $mday);

printf("Copying and Gzipping the daily file\n");

copy($iddf_file, $before_gzip_file);
system "gzip $before_gzip_file";


# Copy the gzipped file to the archive directories

printf("Copying the daily files to the archive directories\n\n");

$to_file = $archive_dir . sprintf("/nucaps_test_npp_%d%02d%02d.iddf.gz", $year, $mon, $mday);

printf("Copying from: %s\n", $after_gzip_file);
printf("          to: %s\n\n", $to_file);

copy($after_gzip_file, $to_file);



system "mv $after_gzip_file $archive_dir2";

# end of file
