#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;

# This script copies data from multiple NUCAPS granule files into an IDDF

print " ";
print "Processing the NUCAPS data";
print " ";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20170521;

printf("Date to be processed:  %d\n\n", $data_date);



my $iddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/nucaps.iddf";



# Remove the previous IDDF

#unlink $iddf_file or warn "Cannot unlink the iddf file";
unlink $iddf_file;



# Run NUCAPStoIDDF for each NUCAPS file

#my @nucapsfiles = glob "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps/NUCAPS-EDR*.nc";
my @nucapsfiles = glob "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/nucaps/NUCAPS-EDR_v2r0_npp_*.nc";


foreach $file (@nucapsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

  # Run NUCAPStoIDDF

  system "/data/data065/nprovs/source/data_transfer/nucaps/IASItoIDDF.x " . $data_date . " " . $file;

  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";
  }



#===================================================================
# Copy the daily file to the orbital archive and the backup archive
# and gzip them

$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$archive_dir  = "/data/data215/nprovs/data/orbital_archive";
$archive_dir2 = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";


#printf("Copying the daily files to the archive directory\n\n");

# Copy and gzip the file to the first archive
$from_file = $nprovs_dir . "/nucaps.iddf";
$to_file = $archive_dir . sprintf("/nucaps/nucaps_%d%02d%02d.iddf", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);

system "gzip $to_file";


# Copy the gzipped file to the backup archive
$from_file = $to_file . ".gz";
$to_file = $archive_dir2 . sprintf("/nucaps/nucaps_%d%02d%02d.iddf.gz", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);



# end of file
