#!/usr/bin/perl -w
#

use File::Copy;
use Time::Local;


my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs_test_metopb/";

my $edr_dir = "/data/www-smcd/mirs/data/m1/";



# Search the incoming directory an remove any file was created
# more than 2 days ago

my @tempfiles = glob $raw_data_dir . "/EDR*";

foreach $file (@tempfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }




# Copy each file in the directory to the incoming data directory

chdir $edr_dir or warn "Could not chdir to the EDR directory: ".$edr_dir;

my @edr_files = glob "EDR*";

foreach $file (@edr_files)
  {
  my $from_file = $edr_dir.$file;
  my $to_file = $raw_data_dir.$file;

  copy($from_file, $to_file)
    or warn "Could not copy the file: ".$from_file;

  printf("Copied: %s\n", $from_file);
  }


# ===============================================================
# Copy the multiple MIRS EDR's into an MDDF

print " ";
print "Processing MIRS EDRs";
print "\n";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);

#$data_date = 20080730;


chdir "/data/data065/nprovs/source/data_transfer/mirs/mddf/version03";


my $mddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/mirs_test_metopb.mddf";
my $mddf_backup = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/mirs_test_metopb.mddf.bkp";



# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/data/data065/nprovs/source/data_transfer/mirs/mddf/version03/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run MirsToMDDF for each EDR

#my @mirsfiles = glob "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs_test_metopb/EDR*";

my @mirsfiles = glob $raw_data_dir . "EDR*";

foreach $file (@mirsfiles)
  {

  # Copy the MDDF to a backup in case an error occurs

  #copy($mddf_file, $mddf_backup);

  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "fort.11" or warn "Cannot link $file to fort.11";
  symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

  # Run MirsToMDDF

#  system "/data/data065/nprovs/source/data_transfer/mirs/mddf/version03/MirsToMDDF.x <<EOD 
#    $data_date 
#EOD";

  system "/data/data065/nprovs/source/data_transfer/mirs/mddf/ver03_hires/MirsToMDDF.x <<EOD 
    $data_date 
EOD";

  # If an error occurred in MirsToMDDF, replace the updated MDDF 
  # with the previous version

  #if ($?)
  #  {
  #  print "**************************\n";
  #  print "An error occurred ($?)\n";
  #  print "Replacing the updated MDDF with the previous version.\n";
  #  print "**************************\n";

  #  copy($mddf_backup, $mddf_file);
  #  }

  # Unlink the files

  unlink "fort.11" or warn "Cannot unlink the unit.11 file";
  unlink "fort.12" or warn "Cannot unlink the unit.12 file";

  # Remove the EDR

  #unlink $file or warn "Cannot remove the EDR: $file";
  }


# Remove the backup MDDF

#unlink $mddf_backup;


# end of file
