#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


$nprovs_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";

$archive_dir  = "/data/data599/orbital_archive";
$archive_dir2 = "/data/data215/nprovs/data/orbital_archive";
#$archive_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";


printf("Copying the daily files to the archive directory\n\n");


# Build the directory string where the current day's EDR's should be

$data_day = time();
$data_day -= 86400;


($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;



# =====================================
# Copy the Unified file sorted index

$from_file = $nprovs_dir . "/sorted.index";
$to_file = $archive_dir . sprintf("/sorted.index/sorted.index.%d%02d%02d", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);

system "gzip $to_file";



$to_file = $archive_dir2 . sprintf("/sorted.index/sorted.index.%d%02d%02d", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

#copy($from_file, $to_file);

#system "gzip $to_file";



# =====================================
# Copy the Unified radiosonde file

$from_file = $nprovs_dir . "/unified.radiosonde.reports";
$to_file = $archive_dir . sprintf("/unified.radiosonde/unified.radiosonde.reports.%d%02d%02d", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);

system "gzip $to_file";



$to_file = $archive_dir2 . sprintf("/unified.radiosonde/unified.radiosonde.reports.%d%02d%02d", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

#copy($from_file, $to_file);

#system "gzip $to_file";




printf("Copying completed.\n\n");

# end of file
