#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


$gdp_dir = "/data/data065/nprovs/data/matchup/gdpfiles/merged";

$archive_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";


printf("Copying the daily files to the archive directory\n\n");


# Build the directory string where the current day's EDR's should be

$data_day = time();
$data_day -= (7 * 86400);


($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;


# =====================================
# Copy the Unified file sorted index

$from_file = $gdp_dir . sprintf("/%d/sorted.index.gdpmean.%d%02d%02d", $year, $year, $mon, $mday);
$to_file = $archive_dir . sprintf("/sorted.index.gdpmean.%d%02d%02d", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);

system "gzip $to_file";


# =====================================
# Copy the Unified radiosonde file

$from_file = $gdp_dir . sprintf("/%d/unified.radiosonde.reports.gdpmean.%d%02d%02d", $year, $year, $mon, $mday);
$to_file = $archive_dir . sprintf("/unified.radiosonde.reports.gdpmean.%d%02d%02d", $year, $mon, $mday);

printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);

copy($from_file, $to_file);


system "gzip $to_file";



# Search the archive directory and remove any file was created
# more than 365 days ago

#my @tempfiles = glob $archive_dir . "/*.gz";

#foreach $file (@tempfiles)
#  {
#  if (-M $file > 364)
#    {
#    unlink $file;
#    }
#  }



printf("Copying completed.\n\n");

# end of file
