#!/usr/bin/perl -w
#

print "==============================================================\n";
print "Transfering COSMIC files";
print " ";
system "date";
print "\n\n";

# Determine the date of the data that will be transfered
# (default is yesterday)

my $now = time();
my $data_date = $now - (2 * 86400);

my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($data_date);

$year = 1900 + $year;
$yday = $yday + 1;

my $date_to_process = sprintf "%04d%02d%02d", $year, ($mon+1), $mday;

printf("\nDate to process: %d/%02d/%04d\n", ($mon+1), $mday, $year);



# Switch to the COSMIC raw data directory

my $cosmic_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/cosmic_older/oct15";

chdir $cosmic_dir;




# ----------------------------------------------------
# wetprf

printf("\n\nTransferring the wetPrf files...\n\n");

# Run the wget line

$wget = sprintf("wget -q --http-user=bsun --http-passwd=cosmic http://cdaac-www.cosmic.ucar.edu/cdaac/rest/tarservice/data/cosmicrt/wetPrf/%d.%03d", $year, $yday);

system $wget;

# Untar the tarball

$untar = sprintf("tar -xvf %d.%03d", $year, $yday);

system $untar;

# Move the individual files to the main directory

my $changedir = sprintf("%s/cosmicrt/wetPrf/%d.%03d", $cosmic_dir, $year, $yday);

chdir $changedir;

system "mv * " . $cosmic_dir;

# Delete the extra directories that were created during the transfer and untarring

chdir $cosmic_dir;

system "rm -r cosmicrt";

$rm_tarball = sprintf("rm %d.%03d", $year, $yday);

system $rm_tarball;



# ----------------------------------------------------
# avnprf

printf("\n\nTransferring the avnPrf files...\n\n");

# Run the wget line

$wget = sprintf("wget -q --http-user=bsun --http-passwd=cosmic http://cdaac-www.cosmic.ucar.edu/cdaac/rest/tarservice/data/cosmicrt/avnPrf/%d.%03d", $year, $yday);

system $wget;

# Untar the tarball

$untar = sprintf("tar -xvf %d.%03d", $year, $yday);

system $untar;

# Move the individual files to the main directory

$changedir = sprintf("%s/cosmicrt/avnPrf/%d.%03d", $cosmic_dir, $year, $yday);

chdir $changedir;

system "mv * " . $cosmic_dir;

# Delete the extra directories that were created during the transfer and untarring

chdir $cosmic_dir;

system "rm -r cosmicrt";

$rm_tarball = sprintf("rm %d.%03d", $year, $yday);

system $rm_tarball;



# ----------------------------------------------------
# atmprf

printf("\n\nTransferring the atmPrf files...\n\n");

# Run the wget line

$wget = sprintf("wget -q --http-user=bsun --http-passwd=cosmic http://cdaac-www.cosmic.ucar.edu/cdaac/rest/tarservice/data/cosmicrt/atmPrf/%d.%03d", $year, $yday);

system $wget;

# Untar the tarball

$untar = sprintf("tar -xvf %d.%03d", $year, $yday);

system $untar;

# Move the individual files to the main directory

$changedir = sprintf("%s/cosmicrt/atmPrf/%d.%03d", $cosmic_dir, $year, $yday);

chdir $changedir;

system "mv * " . $cosmic_dir;

# Delete the extra directories that were created during the transfer and untarring

chdir $cosmic_dir;

system "rm -r cosmicrt";

$rm_tarball = sprintf("rm %d.%03d", $year, $yday);

system $rm_tarball;




# Search the incoming directory and remove any files created
# more than 2 days ago

my @wetfiles = glob $cosmic_dir . "/wetPrf*";

foreach $file (@wetfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }



my @avnfiles = glob $cosmic_dir . "/avnPrf*";

foreach $file (@avnfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }



my @atmfiles = glob $cosmic_dir . "/atmPrf*";

foreach $file (@atmfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }


# end of file
