#!/usr/bin/perl
use Net::FTP;

#========================================================================
# This first part of this script copies the operational MIRS EDRs
# from Diamond to the incoming file directory.

my $host="diamond.nesdis.noaa.gov";

my $remote_dir="/PRD/OPS/apps/mirs/data/TestbedData/Outputs/edr";
my $local_dir="/DEV/PROD/apps/soundings/nprovs/files/incoming/mirs_oper/noaa";

chdir($local_dir);


# Remove all files in the local directory that are
# older than 2 days

my @mirsfiles = glob $local_dir . "/EDR*";

foreach $file (@mirsfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }



# Build the string that will be used to match EDR files. The string will
# contain the year and yesterday's julian date.

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
#$year += 1900;
$year -= 100;
#$mon++;
#$sec = 0;
#$min = 0;
#$hour = 0;
#$wday = 0;
$yday += 1;
#$isdst = 0;

my $match_string = sprintf "EDR_SX.NN.D%02d%03d*.MRG", $year, $yday;

printf("\nAttempting to transfer all files matching: %s\n\n", $match_string);


# Connect to the remote machine

$ftp=Net::FTP->new($host,Timeout=>240) or $newerr=1;
  push @ERRORS, "Can't ftp to $host: $!\n" if $newerr;
  myerr() if $newerr;


$ftp->login() or $newerr=1;
  push @ERRORS, "Can't login to $host: $!\n" if $newerr;
  $ftp->quit if $newerr;
  myerr() if $newerr;


$ftp->cwd($remote_dir) or $newerr=1; 
  push @ERRORS, "Can't cd  $!\n" if $newerr;
  myerr() if $newerr;
  $ftp->quit if $newerr;


# The subroutine mget will get all files in the remote directory
# the match the matching string

mget($ftp, $match_string);


# Close the ftp session

$ftp->quit;



#==============================================================
# The second part of this script runs the program that copies
# the data from each EDR into a single MIRS MDDF.

print " ";
print " ";
print "Processing Operational MIRS EDRs";
print " ";
system "date";
print "\n\n";



# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);

#$data_date = 20080730;




my $mddf_file = "/DEV/PROD/apps/soundings/nprovs/files/daily_input/mirs_oper_nn.mddf";


# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/DEV/PROD/apps/soundings/nprovs/source/mirs/mddf/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";


# Run MirsToMDDF for each EDR

my @mirsfiles = glob $local_dir . "/*";

foreach $file (@mirsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "fort.11" or warn "Cannot link $file to fort.11";
  symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

  # Run MirsToMDDF

  #system "/DEV/PROD/apps/soundings/nprovs/source/mirs/mddf/Older/OlderMirsToMDDF.x";
  #system "/DEV/PROD/apps/soundings/nprovs/source/mirs/mddf/version02/MirsToMDDF.x";

  system "/DEV/PROD/apps/soundings/nprovs/source/mirs/mddf/version03/MirsToMDDF.x <<EOD 
    $data_date 
    EOD";


  # Unlink the files

  unlink "fort.11" or warn "Cannot unlink the unit.11 file";
  unlink "fort.12" or warn "Cannot unlink the unit.12 file";

  # Remove the EDR

  #unlink $file or warn "Cannot remove the EDR: $file";
  }




#===============================================================
# Subroutines

sub myerr {
  print "Error: \n";
  print @ERRORS;
  exit 0;
}


sub mget
  {
  my ($ftp, $pattern) = @_;

  foreach my $file ($ftp->ls($pattern))
    {
    printf("Getting: %s\n", $file);

    $ftp->get($file)
      or warn $ftp->message;
    }
  }


# end of file
