#!/usr/bin/perl -w
#

use File::Copy;
use Net::FTP;


my $ftp_server = 'ftp.orbit.nesdis.noaa.gov';
my $user_id = 'anonymous';
my $password = 'Michael.Pettey@noaa.gov';

my $pattern = "EDR*";



# Transfer the MIRS Test EDRs from the STAR Anonymous FTP server

print "==============================================================\n";
print "Transfering the MIRS Test NOAA EDRs\n\n";
system "date";
print "\n\n";


# Search the incoming directory an remove any file was created
# more than 2 days ago

$noaa_dir = "/DEV/PROD/apps/soundings/nprovs/files/incoming/mirs_test/noaa";

my @tempfiles = glob $noaa_dir . "/EDR*";

foreach $file (@tempfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }


# FTP the latest files from the anonymous ftp server

chdir $noaa_dir;

my $ftp = Net::FTP->new($ftp_server, Debug => 0)
  or die "Cannot connect to: " . $ftp_server . "\n";

$ftp->login($user_id, $password)
  or die "Cannot login: ", $ftp->message;

$ftp->cwd("pub/smcd/opdb/edge/mirs/noaa")
  or die "Cannot change directories: ", $ftp->message;

$ftp->binary
  or die "Cannot change to binary mode: ", $ftp->message;

mget($ftp, $pattern);


$ftp->quit;


printf("\n\n");




# ===============================================================
# Copy the multiple MIRS EDR's into an MDDF

print " ";
print "Processing MIRS EDRs";
print " ";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);

#$data_date = 20080730;



system "cd /DEV/PROD/apps/soundings/nprovs/source/mirs/mddf";


my $mddf_file = "/DEV/PROD/apps/soundings/nprovs/files/daily_input/mirs_test_n19.mddf";
my $mddf_backup = "/DEV/PROD/apps/soundings/nprovs/files/daily_input/mirs_test_n19.mddf.bkp";



# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/DEV/PROD/apps/soundings/nprovs/source/mirs/mddf/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run MirsToMDDF for each EDR

my @mirsfiles = glob "/DEV/PROD/apps/soundings/nprovs/files/incoming/mirs_test/noaa/*";

foreach $file (@mirsfiles)
  {

  # Copy the MDDF to a backup in case an error occurs

  copy($mddf_file, $mddf_backup);

  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "fort.11" or warn "Cannot link $file to fort.11";
  symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

  # Run MirsToMDDF

  system "/DEV/PROD/apps/soundings/nprovs/source/mirs/mddf/version03/MirsToMDDF.x <<EOD 
    $data_date 
    EOD";

  # If an error occurred in MirsToMDDF, replace the updated MDDF 
  # with the previous version

  if ($?)
    {
    print "**************************\n";
    print "An error occurred ($?)\n";
    print "Replacing the updated MDDF with the previous version.\n";
    print "**************************\n";

    copy($mddf_backup, $mddf_file);
    }

  # Unlink the files

  unlink "fort.11" or warn "Cannot unlink the unit.11 file";
  unlink "fort.12" or warn "Cannot unlink the unit.12 file";

  # Remove the EDR

  #unlink $file or warn "Cannot remove the EDR: $file";
  }


# Remove the backup MDDF

unlink $mddf_backup;




# Use the subroutine mget to transfer all of the files on the
# server that match the pattern. Before each file is transfered,
# however, check to see if it already exists. If it does then 
# do not bother transfering it again.

sub mget
  {
  my ($ftp, $fpattern) = @_;

  foreach my $file($ftp->ls($fpattern))
    {
    if (! (-e $file))
      {
      printf("Transfering:  %s\n", $file);
      $ftp->get($file) or warn $ftp->message;
      }
    }
  }

# end of file
