#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


printf("\nUpdating the NARCS archive file\n\n");


# Set up the directories where everything is located

$source_dir = "/DEV/PROD/apps/soundings/nprovs/source/narcs";

$input_dir = "/DEV/PROD/apps/soundings/a4/wrk/bsun/nprovs_daily_files";

$output_dir = "/DEV/PROD/apps/soundings/nprovs/source/narcs";

$narcs_file = $output_dir . "/narcs_file_oper.dat";



# Find the date of the file to process

$data_day = time();

$data_day -= (2 * 86400);

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

my $day_of_data = ($year * 10000) + ($mon * 100) + $mday;

# ****************************************
# Temporary override of the data date
#$day_of_data = 20110616;
#$day_of_data = 20110616;
# ****************************************


printf("Day of data to process: %d\n\n", $day_of_data);



# Gunzip the NARCS file

system "gunzip " . $narcs_file;


# Move the current NARCS file to an older temporary file
  
system "mv " . $narcs_file . " " . $narcs_file . ".old";


# Remove any previous deltas.tmp file
  
unlink $source_dir . "deltas.tmp";


# Unlink the files (in case the links still exist from previous runs)

unlink "old_narcs.file";
unlink "new_narcs.file";
unlink "nprovs.file";
unlink "order.file";


# Link the files

symlink $narcs_file . ".old", "old_narcs.file" or warn "Cannot link the old NARCS file";
symlink $narcs_file, "new_narcs.file" or warn "Cannot link the NARCS file";
symlink $input_dir . "/NPROVS_" . $day_of_data, "nprovs.file" or warn "Cannot link the input NPROVS file";
symlink $source_dir . "/nprovs_file_contents.dat", "order.file" or warn "Cannot link the order.file";


# Run NarcsBuilder

$jar_exec = "/usr/java14/bin/java -jar " . $source_dir . "/NarcsBuilder.jar " . $day_of_data;
system $jar_exec;


# Unlink the files

unlink "old_narcs.file" or warn "Cannot unlink the old_narcs.file";
unlink "new_narcs.file" or warn "Cannot unlink the new_narcs.file";
unlink "nprovs.file" or warn "Cannot unlink the nprovs.file";
unlink "order.file" or warn "Cannot unlink the order.file";


# Remove the old file

unlink $narcs_file . ".old";


# Gzip the NARCS file

system "gzip " . $narcs_file;


printf("\nNARCS archive file updated.\n\n");

# end of file
