#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


$months_back = 2;

$from_dir_nn = "/DEV/PROD/apps/soundings/a4/wrk/bsun/matchup.nn_file/";
$from_dir_m2 = "/DEV/PROD/apps/soundings/a4/wrk/bsun/matchup.m2_file/";
#$to_dir = "/h/mpettey/npoess/matchfile/";
$to_dir = "/h/mpettey/scripts/";




# Get the month and year of the data to be processed

$data_day = time();

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$mday = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$mon = $mon - $months_back;


# =============================================================
# NN files

printf("Combining the NOAA-18 NPROVS daily match files into a single monthly file\n\n");


my $nn_from_file_list = $from_dir_nn . sprintf("NPROVS.nn_%04d%02d*", $year, $mon);

my @nn_files = glob $nn_from_file_list;
my $nn_unit_num = 0;

foreach $file (@nn_files)
  {
  $nn_unit_num++;
  $unit = sprintf("in.file%d", $nn_unit_num);

  print "Processing file: " . $file . "\n";

  symlink $file, $unit or warn "Cannot link $file to $unit";
  }


# Create the symbolic link to the output file

$nn_out_file = sprintf("%snprovs_nn_%04d_%02d  ", $to_dir, $year, $mon);


printf("%s\n", $nn_out_file);
symlink $nn_out_file, "out.file" or warn "Cannot link $nn_out_file to out.file";


# Run the program to combine the files

system "/h/mpettey/npoess/matchfile/CombineCollocationFiles.x $nn_unit_num";


# Remove the symbolic links

unlink "out.file" or warn "Cannot unlink the out.file file";


my @linked_files = glob "in.file*";

foreach $link (@linked_files)
  {
  unlink $link or warn "Cannot unlink the $link file";
  }




# =============================================================
# M2 files

printf("Combining the MetOp NPROVS daily match files into a single monthly file\n\n");


my $m2_from_file_list = $from_dir_m2 . sprintf("NPROVS.m2_%04d%02d*", $year, $mon);

my @m2_files = glob $m2_from_file_list;
my $m2_unit_num = 0;

foreach $file (@m2_files)
  {
  $m2_unit_num++;
  $unit = sprintf("in.file%d", $m2_unit_num);

  print "Processing file: " . $file . "\n";

  symlink $file, $unit or warn "Cannot link $file to $unit";
  }


# Create the symbolic link to the output file

$m2_out_file = sprintf("%snprovs_m2_%04d_%02d  ", $to_dir, $year, $mon);


printf("%s\n", $m2_out_file);
symlink $m2_out_file, "out.file" or warn "Cannot link $m2_out_file to out.file";


# Run the program to combine the files

system "/h/mpettey/npoess/matchfile/CombineCollocationFiles.x $m2_unit_num";


# Remove the symbolic links

unlink "out.file" or warn "Cannot unlink the out.file file";


my @linked_files = glob "in.file*";

foreach $link (@linked_files)
  {
  unlink $link or warn "Cannot unlink the $link file";
  }


printf("Copying completed.\n\n");

# end of file
