#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


$days_back = 7;

$from_dir = "/DEV/PROD/apps/soundings/a4/wrk/bsun/nprovs_daily_files/";
$to_dir = "/DEV/PROD/apps/soundings/nprovs/source/matchfile/tempdir/";


printf("Combining the last %d days of NPROVS match files into a single file\n\n", $days_back);


# Build the directory string where the current day's EDR's should be

$data_day = time();
$data_day -= 86400;


# Loop through each of the days and create symbolic links for
# each daily file

$from_date = "";
$to_date = "";

for ($i=($days_back-1); $i>=0; $i--)
  {
  ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
  $year += 1900;
  $mon++;
  $sec = 0;
  $min = 0;
  $hour = 0;
  $wday = 0;
  $yday = 0;
  $isdst = 0;

  $from_file = $from_dir . "NPROVS_";
  $from_file = $from_file . sprintf("%d%02d%02d", $year, $mon, $mday);

  $unit = sprintf("in.file%d", ($i+1));

  symlink $from_file, $unit or warn "Cannot link $from_file to $unit";

  $data_day -= 86400;

  # Save the first and last dates for use in the output file
  # symbolic link

  if ($i == 0)
    {
    $from_date = sprintf("%d%02d%02d", $year, $mon, $mday);
    }

  if ($i == ($days_back - 1))
    {
    $to_date = sprintf("%d%02d%02d", $year, $mon, $mday);
    }
  }


# Create the symbolic link to the output file

$out_file = $to_dir . "nprovs_" . $from_date . "_" . $to_date . ".pmp";

symlink $out_file, "out.file" or warn "Cannot link $out_file to out.file";




# Run the program to combine the files

system "/DEV/PROD/apps/soundings/nprovs/source/matchfile/CombineCollocationFiles.x $days_back";


# Remove the symbolic links

unlink "out.file" or warn "Cannot unlink the out.file file";

for ($i=0; $i<$days_back; $i++)
  {
  $link = sprintf("in.file%d", ($i+1));
  unlink $link or warn "Cannot unlink the $link file";
  }


printf("Copying completed.\n\n");

# end of file
