#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;


$days_back = 7;

$from_dir = "temp/";
$to_dir = "/DEV/PROD/apps/soundings/nprovs/scripts/nprovs_weekly_collocationfiles_oper/";
$run_dir = "/DEV/PROD/apps/soundings/nprovs/scripts/";


printf("Combining the previous weeks of NPROVS match files into a single file\nbeginning with Sunday to Saturday\n");


# Build the directory string where the current day's EDR's should be
# For now, assume this is run on a Tuesday, so go back 3 days to Saturday.
# Later, need to determine which day of the week we are on and then go back enuf days to Saturday.

$data_day = time();
  ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);

$data_day -= ($wday + 1)*86400;


# Loop through each of the days and create symbolic links for
# each daily file

$from_date = "";
$to_date = "";

for ($i=($days_back-1); $i>=0; $i--)
  {
  ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
  $year += 1900;
  $mon++;
  $sec = 0;
  $min = 0;
  $hour = 0;
  $wday = 0;
  $yday = 0;
  $isdst = 0;

  $from_file = $from_dir . "NPROVS_";
  $from_file = $from_file . sprintf("%d%02d%02d", $year, $mon, $mday);

  $unit = sprintf("in.file%d", ($i+1));

  symlink $from_file, $unit or warn "Cannot link $from_file to $unit";

  $data_day -= 86400;

  # Save the first and last dates for use in the output file
  # symbolic link

  if ($i == 0)
    {
    $from_date = sprintf("%d%02d%02d", $year, $mon, $mday);
    }

  if ($i == ($days_back - 1))
    {
    $to_date = sprintf("%d%02d%02d", $year, $mon, $mday);
    }
  }


# Create the symbolic link to the combine file settings XML

$file_settings = "combine_file_settings.xml";

symlink $file_settings, "file.settings" or warn "Cannot link $out_file to out.file";

# Create the symbolic link to the output file

$out_file = $from_dir . "nprovs_" . $from_date . "_" . $to_date . ".pmp";

symlink $out_file, "out.file" or warn "Cannot link $out_file to out.file";


# Run the program to combine the files

system "/usr/java14/bin/java -jar " . $run_dir . "CombineDailyFiles.jar ".$from_date." ". $to_date." ".$from_dir."NPROVS_YYYYMMDD";
printf("Beginning compression of weekly file ................\n\n");
system "gzip -f " . $out_file;

# Remove the symbolic links

unlink "out.file" or warn "Cannot unlink the out.file file";
unlink "file.settings" or warn "Cannot unlink the out.file file";

for ($i=0; $i<$days_back; $i++)
  {
  $link = sprintf("in.file%d", ($i+1));
  unlink $link or warn "Cannot unlink the $link file";
  }


printf("Copying completed.\n\n");

# end of file
