#!/usr/bin/perl -w
#

# This script copies data from multiple IASI granule files into an IDDF

print " ";
print "Processing the IASI data";
print " ";
system "date";
print "\n\n";


my $iddf_file = "/DEV/PROD/apps/soundings/nprovs/files/daily_input/iasi.iddf";



# Remove the previous IDDF

unlink $iddf_file or warn "Cannot unlink the iddf file";



# Run IasiToIDDF for each IASI file

my @iasifiles = glob "/DEV/PROD/apps/soundings/nprovs/files/incoming/iasi/IASI_L02_M02_*.nc";

foreach $file (@iasifiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "in.file" or warn "Cannot link $file to in.file";
  symlink $iddf_file, "out.file" or warn "Cannot link $iddf_file to out.file";

  # Run IasiToIDDF

  system "/DEV/PROD/apps/soundings/nprovs/source/iasi/IASItoIDDF.x";

  # Unlink the files

  unlink "in.file" or warn "Cannot unlink the in.file";
  unlink "out.file" or warn "Cannot unlink the out.file";

  # Remove the IASI granule file

  unlink $file or warn "Cannot remove the IASI granule file: $file";
  }

# end of file
