#!/usr/bin/perl -w
#

use Net::FTP;



# Transfer the SSMIS EDRs from the STAR Anonymous FTP server

print "==============================================================\n";
print "Transfering the SSMIS EDRs\n\n";
system "date";
print "\n\n";


my $ftp_server = 'ftp.orbit.nesdis.noaa.gov';
my $user_id = 'anonymous';
my $password = 'Michael.Pettey@noaa.gov';

my $pattern = "EDR*";


# Search the incoming directory an remove any file was created
# more than 2 days ago

$ssmis_dir = "/DEV/PROD/apps/soundings/nprovs/files/incoming/ssmis/f16";

my @tempfiles = glob $ssmis_dir . "/EDR*";

foreach $file (@tempfiles)
  {
  if (-M $file > 2)
    {
    unlink $file;
    }
  }


# FTP the latest files from the anonymous ftp server

chdir $ssmis_dir;

my $ftp = Net::FTP->new($ftp_server, Debug => 0)
  or die "Cannot connect to: " . $ftp_server . "\n";

$ftp->login($user_id, $password)
  or die "Cannot login: ", $ftp->message;

$ftp->cwd("pub/smcd/opdb/edge/ssmis")
  or die "Cannot change directories: ", $ftp->message;

$ftp->binary
  or die "Cannot change to binary mode: ", $ftp->message;

mget($ftp, $pattern);


$ftp->quit;


printf("\n\n");




# =============================================================
# Copies data from multiple SSMIS EDR's into an MDDF

print " ";
print "Processing all of the SSMIS EDRs";
print " ";
system "date";
print "\n\n";


# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= 86400;

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);

#$data_date = 20080730;



system "cd /DEV/PROD/apps/soundings/nprovs/source/mirs";


my $mddf_file = "/DEV/PROD/apps/soundings/nprovs/files/daily_input/ssmis.mddf";



# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/DEV/PROD/apps/soundings/nprovs/source/mirs/mddf/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run SsmisToMDDF for each EDR

my @ssmisfiles = glob "/DEV/PROD/apps/soundings/nprovs/files/incoming/ssmis/*";

foreach $file (@ssmisfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $file, "\n\n";

  # Link the files

  symlink $file, "fort.11" or warn "Cannot link $file to fort.11";
  symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

  # Run MirsToMDDF

  system "/DEV/PROD/apps/soundings/nprovs/source/mirs/mddf/version03/MirsToMDDF.x <<EOD 
    $data_date 
    EOD";

  # Unlink the files

  unlink "fort.11" or warn "Cannot unlink the unit.11 file";
  unlink "fort.12" or warn "Cannot unlink the unit.12 file";

  # Remove the EDR

  #unlink $file or warn "Cannot remove the EDR: $file";
  }




# Use the subroutine mget to transfer all of the files on the
# server that match the pattern. Before each file is transfered,
# however, check to see if it already exists. If it does then 
# do not bother transfering it again.

sub mget
  {
  my ($ftp, $fpattern) = @_;

  foreach my $file($ftp->ls($fpattern))
    {
    if (! (-e $file))
      {
      printf("Transfering:  %s\n", $file);
      $ftp->get($file) or warn $ftp->message;
      }
    }
  }

# end of file
