#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;

BEGIN
  {
  $ENV{LD_LIBRARY_PATH}="LD_LIBRARY_PATH:/data/starfs1/libs/netcdf-4.2/lib:/data/starfs1/libs/hdf5-1.8.7/lib";
  }


# This script copies data from multiple AIRS files into an ADDF

print "\n";
print "Processing the AIRS data\n";
print "\n";
system "date";
print "\n\n";

$source_dir   = "/data/data065/nprovs/source/data_transfer/airs/version6";
$raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/airs";
$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";

chdir $raw_data_dir;



# Remove any existing files in the raw data directory

@files = glob "$raw_data_dir/*";

foreach $file (@files)
  {
  unlink $file;
  }



# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= (1 * 86400);

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
#$yday = 0;
$isdst = 0;

$date_to_process = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$date_to_process = 20080730;

printf("Date to be processed:  %d\n\n", $date_to_process);



#-------------------------------------------------------------------------
# Use wget to transfer the data from the NASA server to the incoming directory

printf("\nCopying the data from NASA...\n\n");

$wget = sprintf("wget --load-cookies ~/.urs_cookies --save-cookies ~/.urs_cookies --auth-no-challenge=on --keep-session-cookies --level=1 -r -nH -nd -np -A hdf https://discnrt1.gesdisc.eosdis.nasa.gov/data/Aqua_AIRS_NRT/AIRS2SUP_NRT.006/%d/%03d/", $year, $yday);

printf("%s\n", $wget);

system $wget;



# Set up a new ADDF file

$addf_file_name = "airs_version6.addf";

my $output_file_name = "$raw_data_dir/" . $addf_file_name;


# Remove the previous ADDF (if it exists)

#unlink $output_file_name;


# Process the files

@airsfiles = glob "$raw_data_dir/AIRS*.hdf";

foreach $file (@airsfiles)
  {
  printf("Processing file:  %s\n", $file);

  symlink $output_file_name, "out.file" or warn "Cannot link $addf_file to out.file";

  system "$source_dir/AIRStoADDF.x " . $file;

  unlink "out.file" or warn "Cannot unlink the out.file";
  }


# Move the file to the incoming daily directory

system ("mv $output_file_name $nprovs_dir/$addf_file_name");


# Remove all files in the raw data directory

@files = glob "$raw_data_dir/*.hdf";

foreach $file (@files)
  {
  unlink $file;
  }




#===================================================================
# Copy the daily file to the orbital archive and the backup archive

#$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
#$archive_dir  = "/data/data599/orbital_archive";
#$archive_dir2 = "/data/data215/nprovs/data/orbital_archive";
##$archive_dir2 = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";

#printf("Copying the daily files to the archive directory\n\n");

#printf("Making a copy of the daily file...\n\n");
#$from_file = $iddf_file;
#$to_file = $nprovs_dir . sprintf("/nucaps_metopc_%d.iddf", $data_date);
#copy($from_file, $to_file);

#printf("Gzipping the file...\n\n");
#$gzip_file = sprintf("nucaps_metopc_%d.iddf", $data_date) . ".gz";
#system "gzip " . $to_file;

#printf("Copying to the main orbital archive...\n");
#$from_file = $nprovs_dir . "/" . $gzip_file;
#$to_file = $archive_dir . "/nucaps_metopc/" . $gzip_file;
#printf("Copying from: %s\n", $from_file);
#printf("          to: %s\n\n", $to_file);
#copy($from_file, $to_file);

#printf("Copying to the backup orbital archive...\n");
#$to_file = $archive_dir2 . "/nucaps_metopc/" . $gzip_file;
#printf("Copying from: %s\n", $from_file);
#printf("          to: %s\n\n", $to_file);
##copy($from_file, $to_file);

#unlink $nprovs_dir . "/" . $gzip_file;


# end of file
