#!/usr/bin/perl -w
#
use File::Copy;
use Time::Local;

BEGIN
  {
  $ENV{LD_LIBRARY_PATH}="LD_LIBRARY_PATH:/data/starfs1/libs/netcdf-4.2/lib:/data/starfs1/libs/hdf5-1.8.7/lib";
  }


# This script copies data from multiple EUMETSAT files into an EIDF

print "\n";
print "Processing the EUMETSAT IASI MetOp-B data\n";
print "\n";
system "date";
print "\n\n";

$source_dir   = "/data/data065/nprovs/source/data_transfer/eu_iasi";
$raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/euiasi_metopb";
$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";

chdir $raw_data_dir;



# Calculate the date of the data to be processed. By default, this
# is usually yesterday. To override, replace $data_date with the
# date in the form YYYYMMDD

$data_day = time();
$data_day -= (1 * 86400);

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($data_day);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 0;
$wday = 0;
$yday = 0;
$isdst = 0;

$date_to_process = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$date_to_process = 20080730;

printf("Date to be processed:  %d\n\n", $date_to_process);



#-------------------------------------------------------------------------
# Copy the files for the selected date from SCDR to the incoming directory

printf("\nCopying the data from SCDR...\n\n");

system "/data/starfs1/bin/scdr-files -t IASI_EUL2 -satid m01 -d " . $year . "-" . $mon . "-" . $mday . " | xargs -L100 -P2 cp -t " . $raw_data_dir;


# Set up a new EDIF file

$eidf_file_name = "euiasi_metopb.eidf";

my $output_file_name = "$raw_data_dir/" . $eidf_file_name;


# Remove the previous EIDF (if it exists)

#unlink $output_file_name or warn "Cannot unlink the eidf file";
unlink $output_file_name;


# Process the granules

#my @iasifiles = glob "$raw_data_dir/IASI_SND_02_M01_$date_to_process*";
my @iasifiles = glob "$raw_data_dir/IASI_SND_02_M01*";

foreach $file (@iasifiles)
  {
  #print "\n-------------------------------\n";
  #print "Processing file: ". $file, "\n\n";

  # Run the program that reads the EUMETSAT IASI data and copies the
  # data to an EIDF file

  symlink $output_file_name, "out.file" or warn "Cannot link $eidf_file1 to out.file";

  system "$source_dir/EUIASItoEIDF.x $file";

  unlink "out.file" or warn "Cannot unlink the out.file";
  }


# Move the file to the incoming daily directory

system ("mv $output_file_name $nprovs_dir/$eidf_file_name");


# Remove all of the granule files in the raw data directory

@files = glob "$raw_data_dir/IASI_SND*";

foreach $file (@files)
  {
  unlink $file;
  }




#===================================================================
# Copy the daily file to the orbital archive and the backup archive

#$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
#$archive_dir  = "/data/data599/orbital_archive";
#$archive_dir2 = "/data/data215/nprovs/data/orbital_archive";
##$archive_dir2 = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";

#printf("Copying the daily files to the archive directory\n\n");

#printf("Making a copy of the daily file...\n\n");
#$from_file = $iddf_file;
#$to_file = $nprovs_dir . sprintf("/nucaps_metopc_%d.iddf", $data_date);
#copy($from_file, $to_file);

#printf("Gzipping the file...\n\n");
#$gzip_file = sprintf("nucaps_metopc_%d.iddf", $data_date) . ".gz";
#system "gzip " . $to_file;

#printf("Copying to the main orbital archive...\n");
#$from_file = $nprovs_dir . "/" . $gzip_file;
#$to_file = $archive_dir . "/nucaps_metopc/" . $gzip_file;
#printf("Copying from: %s\n", $from_file);
#printf("          to: %s\n\n", $to_file);
#copy($from_file, $to_file);

#printf("Copying to the backup orbital archive...\n");
#$to_file = $archive_dir2 . "/nucaps_metopc/" . $gzip_file;
#printf("Copying from: %s\n", $from_file);
#printf("          to: %s\n\n", $to_file);
##copy($from_file, $to_file);

#unlink $nprovs_dir . "/" . $gzip_file;


# end of file
