#!/usr/bin/perl -w
#

use File::Copy;
use Time::Local;


BEGIN
  {
  $ENV{LD_LIBRARY_PATH}="LD_LIBRARY_PATH:/data/starfs1/libs/netcdf-4.2/lib:/data/starfs1/libs/hdf5-1.8.7/lib";
  }


my $raw_data_dir = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/raw_data/mirs/noaa20";

chdir $raw_data_dir;


# Search the incoming directory and remove any file that was created
# more than 2 days ago

my @tempfiles = glob $raw_data_dir . "/NPR*.nc";

foreach $file (@tempfiles)
  {
  if (-M $file > 1)
    {
    unlink $file;
    }
  }



# Determine which date to process. This will normally be yesterday, but that
# can be overridden.

$yesterday = time();
$yesterday -= (1 * 86400);

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($yesterday);
$year += 1900;
$mon++;
$sec = 0;
$min = 0;
$hour = 12;
$wday = 0;
$yday = 0;
$isdst = 0;

$data_date = sprintf("%4d%02d%02d", $year, $mon, $mday);
#$data_date = 20080730;



# Transfer the granules from SCDR

system "/data/starfs1/bin/scdr-files -t NPR_MIRS_IMG --re-file _n20_ -d " . $year . "-" . $mon . "-" . $mday . " | xargs -L100 -P2 cp -t " . $raw_data_dir;

system "/data/starfs1/bin/scdr-files -t NPR_MIRS_SND --re-file _n20_ -d " . $year . "-" . $mon . "-" . $mday . " | xargs -L100 -P2 cp -t " . $raw_data_dir;



# ===============================================================
# Copy the multiple MIRS NOAA-12 EDR's into an MDDF

print "\n\n";
print "Processing MIRS NOAA-20 EDRs";
print "\n";
system "date";
print "\n\n";


chdir $raw_data_dir or warn "Could not chdir to the raw data directory: ".$raw_data_dir;


my $mddf_file = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/mirs_noaa20.mddf";


#unlink $mddf_file;



# Initialize the MDDF

symlink $mddf_file, "fort.12" or warn "Cannot link $mddf_file to fort.12";

system "/data/data065/nprovs/source/data_transfer/mirs/initmddf/initMDDF.x";

unlink "fort.12" or warn "Cannot unlink the unit.12 file";



# Run MirsToMDDF for each netCDF granule

my @mirsfiles = glob $raw_data_dir . "/NPR-MIRS-SND*";

foreach $snd_file (@mirsfiles)
  {
  print "\n-------------------------------\n";
  print "Processing file: ". $snd_file, "\n\n";

  # Build the name of a matching IMG file

  $string1 = "NPR-MIRS-SND";
  $string2 = "NPR-MIRS-IMG";
  #$string1 = "SND_TMS_npp";
  #$string2 = "IMG_TMS_npp";

  $img_file = $snd_file;
  $img_file =~ s/$string1/$string2/g;

  if (-e $img_file)
    {

    # Link the output file

    symlink $mddf_file, "out.file" or warn "Cannot link $mddf_file to unit.12";

    # Run MIRStoMDDF

    system "/data/data065/nprovs/source/data_transfer/mirs/netcdf/MIRStoMDDF.x $snd_file $img_file $data_date";

    # Unlink the file

    unlink "out.file" or warn "Cannot unlink the unit.12 file";
    }
  else
    {
    printf("\n\n***** NO MATCH MADE *****\n\n");
    }
  }



# Remove the granules and the directory structure that was created during the 
# tar -xvf step

#$file_location_dir = $raw_data_dir . sprintf("/nc/n20_atms/%4d-%02d-%02d", $year, $mon, $mday);

#@tempfiles = glob $file_location_dir . "/NPR-MIRS*";

#foreach $file (@tempfiles)
#  {
#  unlink $file;
#  }


#system "rmdir " . $file_location_dir;

#$file_location_dir = $raw_data_dir . sprintf("/nc/n20_atms");
#system "rmdir " . $file_location_dir;

#$file_location_dir = $raw_data_dir . sprintf("/nc");
#system "rmdir " . $file_location_dir;



#===================================================================
# Copy the daily file to the orbital archive and the backup archive

$nprovs_dir   = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$archive_dir  = "/data/data599/orbital_archive";
$archive_dir2 = "/data/data215/nprovs/data/orbital_archive";
#$archive_dir2 = "/data/data065/nprovs/data/matchup/DailyFiles_incoming/archive";

printf("Copying the daily files to the archive directory\n\n");

printf("Making a copy of the daily file...\n\n");
$from_file = $mddf_file;
$to_file = $nprovs_dir . sprintf("/mirs_noaa20_%d.mddf", $data_date);
copy($from_file, $to_file);

printf("Gzipping the file...\n\n");
$gzip_file = sprintf("mirs_noaa20_%d.mddf", $data_date) . ".gz";
system "gzip " . $to_file;

printf("Copying to the main orbital archive...\n");
$from_file = $nprovs_dir . "/" . $gzip_file;
$to_file = $archive_dir . "/mirs_noaa20/" . $gzip_file;
printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);
copy($from_file, $to_file);

printf("Copying to the backup orbital archive...\n");
$to_file = $archive_dir2 . "/mirs_noaa20/" . $gzip_file;
printf("Copying from: %s\n", $from_file);
printf("          to: %s\n\n", $to_file);
#copy($from_file, $to_file);

unlink $nprovs_dir . "/" . $gzip_file;


# Capture data from the MIRS daily data file (MDDF) and write
# the data to ODS files.

system "/data/data065/nprovs/scripts/graphics/run_mirs_noaa20_ods_capture";

# end of file
