SUBROUTINE PRWATER (WVMR,PR,LPW,TOP,BOTTOM,TPW)
   IMPLICIT NONE
!
!***********************************************************************
!
!   NAME- PRWATER
!
!   LANGUAGE- FORTRAN 90                TYPE- SUBROUTINE
!
!   VERSION- 1.0    DATE-  9/01/95   PROGRAMMER- BRUCE WHISTLER
!   VERSION- 2.0    DATE-  6/13/01   PROGRAMMER- FRANK TILLEY (RAYTHEON)
!     ** MULTIPLIED EACH PRECIPITABLE WATER VALUE BY 10.0 TO CONVERT
!        IT FROM CENTIMETERS TO MILLIMETERS UNDER PR #39 **
!   VERSION- 3.0    DATE-  6/17/04   PROGRAMMER- FRANK TILLEY (RAYTHEON)
!     ** RE-HOSTED FROM CEMSCS MVS MAINFRAME TO IBM SP UNIX PLATFORM.
!   VERSION- 4.0    DATE-  4/08/13   PROGRAMMER- FRANK TILLEY (IMSG)
!     ** RENAMED TO PRWATER AND CHANGED NUMBER OF PRESSURES TO 137 FOR ECMWF.
!   VERSION- 4.1    DATE-  3/05/15   PROGRAMMER- FRANK TILLEY (IMSG)
!     ** CONVERTED FROM FORTRAN 77 TO FORTRAN 90
!
!   FUNCTION- COMPUTES PRECIPITABLE WATER FROM A WATER VAPOR
!             MIXING RATIO PROFILE. THE RESULT IS EXPRESSED IN
!             MILLIMETERS.
!
!   CALLING PARAMETERS-
!     VARIABLE             TYPE   I/O  DESCRIPTION
!     --------             ----   ---  -----------
!     WVMR                 REAL    I   MIXING RATIO PROFILE
!
!     PR                   REAL    I   PRESSURE PROFILE
!
!     LPW                  REAL    O   PRECIP WATER PROFILE
!
!     TOP                   INT    I   PRESSURE LEVEL AT THE TOP OF THE
!                                      MIXING RATIO PROFILE
!     BOTTOM                INT    I   PRESSURE LEVEL AT THE BOTTOM OF
!                                      THE MIXING RATIO PROFILE
!     TPW                   INT    O   TOTAL PRECIPITABLE WATER
!                                      FROM THE MIXING RATIO PROFILE
!
!   LOCAL VARIABLES-
!     NAME                 TYPE       DESCRIPTION
!     ----                 ----       -----------
!     I                     INT       LOOP INDEX
!
!     W1                   REAL       MIXING RATIO AT THE UPPER LEVEL
!                                     BOUNDING THE LAYER
!
!     W2                   REAL       MIXING RATIO AT THE LOWER LEVEL
!                                     BOUNDING THE LAYER
!
!     P1                   REAL       PRESSURE AT THE UPPER BOUNDARY
!                                     OF THE LAYER
!
!     P2                   REAL       PRESSURE AT THE LOWER BOUNDARY
!                                     OF THE LAYER
!
!     DP                   REAL       PRESSURE DIFFERENCE BETWEEN THE
!                                     UPPER AND LOWER LAYER BOUNDARIES
!
!     F                    REAL       FIXED VALUE USED TO COMPUTE
!                                     LAYER PRECIPITABLE WATER.
!
!***********************************************************************
!
! ARGUMENTS
   
   REAL, DIMENSION(137), INTENT(IN) :: WVMR, PR
   REAL, DIMENSION(137), INTENT(OUT) :: LPW
   REAL, INTENT(OUT) :: TPW

   INTEGER, INTENT(IN) :: TOP, BOTTOM

! LOCAL

   REAL, PARAMETER :: F = 1961.33
   REAL :: W1, P1, W2, P2, DP

   INTEGER :: I

   TPW = 0.0
   DO I = TOP, BOTTOM-1
      W1   = WVMR(I)
      W2   = WVMR(I+1)
      P1   = PR(I)
      P2   = PR(I+1)
      DP   = ABS(P2-P1)
      LPW(I) = 10.0 * ((W1+W2) * DP/F)
      TPW = TPW + LPW(I) 
   END DO

END SUBROUTINE PRWATER
