/*
   Name- captureAirsGDDF.c

   Language- C     Type- MAIN

   Version- 1.0    Date-  2/18/2007   Programmer- Mike Pettey (IMSG)

   Function- This program extracts selected data from an RRODF
             and writes the data to an EDGE file.  The selected
             data is defined in the run script.  Also in the run
             script are the starting date (YYYYMMDD) and hour and
             the ending date and hour.
*/


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define  MYTRUE      0
#define  MYFALSE     1

#define  SWAP_IN   MYTRUE
#define  SWAP_OUT  MYFALSE

#define  EIDF_RECORD_LENGTH  1200
#define  EIDF_HEADER_VALUES  EIDF_RECORD_LENGTH / 4
#define  EIDF_DATA_VALUES    EIDF_RECORD_LENGTH / 2

int    scanline, output_record;
int    num_temp_levels, num_moisture_levels, num_ozone_levels;
int    num_emiss_wavelengths;
int    data_frame_record, data_frame_line_number, data_frame_count, data_frame_number;
int    data_frame_lats[4], data_frame_lons[4];
float  temp_pressures[90], moisture_pressures[90], ozone_pressures[10][2];


main(int argc, char *argv[])
  {
  int    record_class, instr_group, rec_subclass, subclass_ver, record_length;
  int    start_date, start_time, end_date, end_time;
  int    i, n, i4val;
  int    input_file_number;
  int    output_header[EIDF_DATA_VALUES];
  short  i2val;
  char   c;
  char   input_file_name[500];
  long   offset; 
  FILE   *in, *out;

	time_t 		date_time;
	struct		tm *ts;
	int     	year0,month0,day0,yyyymmdd0;


  /* Print an initial message */

/*  printf("\nCopying the IASI files to an EIDF\n\n"); */


  /* Initialize some of the variables */

  input_file_number = 1;
  output_record = 2;
  scanline = 0;
	data_frame_number = 0;

      printf("scanline: %d\n", scanline);

  /* Open the output file */

  if ((out=fopen("out.file", "w+")) == NULL)
    {
    printf("\n\nThe output file could not be opened for output.\n");
    printf("Execution ending.\n\n");
    exit(1);
    }


  /* Initialize the header of the output file */

	/* obtain the current time */
        time(&date_time);
        ts = localtime(&date_time);
        month0 = ts->tm_mon + 1;
        day0 = ts->tm_mday;
        year0 = ts->tm_year + 1900;
        yyyymmdd0 = year0 * 10000 + month0 * 100 +day0;

  for (i=0; i<EIDF_HEADER_VALUES; i++)
    output_header[i] = -32768;

  output_header[0] = 73686870;
  output_header[1] = 10;
  output_header[3] = EIDF_RECORD_LENGTH;
  output_header[4] = EIDF_RECORD_LENGTH;
  output_header[5] = yyyymmdd0;


  /* Loop through the input files */

  sprintf(input_file_name, "in.file%d", input_file_number);
  if ((in=fopen(input_file_name, "r")) == NULL)
    {
    printf("\n\nThe input file could not be opened .\n");
    printf("Execution ending.\n\n");
    exit(1);
    }


  while ((in=fopen(input_file_name, "r")) != NULL) 

    {
/*    printf("Processing Input File:  %s\n", input_file_name); */

   /* data_frame_number      = 0; */
    data_frame_number      = data_frame_number; 
    data_frame_record      = output_record;
    data_frame_line_number = 0;
    data_frame_count       = 0;

    for (i=0; i<4; i++)
      {
      data_frame_lats[i] = -32768;
      data_frame_lons[i] = -32768;
      }


    /* Loop through each of the record types in the file */

    offset = 0;

    while (! feof(in))
      {
      fseek(in, offset, SEEK_SET);

      fread(&c, 1, 1, in);
      record_class = c;
	printf("record_class= %d\n",record_class); 

      fread(&c, 1, 1, in);
      instr_group = n;

      fread(&c, 1, 1, in);
      rec_subclass = n;

      fread(&c, 1, 1, in);
      subclass_ver = n;

      fread(&i4val, 4, 1, in);
      if (SWAP_IN == MYTRUE)
        record_length = ntohl(i4val);

	printf ("record_length= %d\n",record_length);
      printf("scanline: %d\n", scanline);


      fread(&i2val, 2, 1, in);
      fread(&i4val, 4, 1, in);

      if (SWAP_IN == MYTRUE)
        {
        i2val = ntohs(i2val);
        i4val = ntohl(i4val);
        }

      start_date = i2val;
      start_time = i4val;

      fread(&i2val, 2, 1, in);
      fread(&i4val, 4, 1, in);

      if (SWAP_IN == MYTRUE)
        {
        i2val = ntohs(i2val);
        i4val = ntohl(i4val);
        }

      end_date = i2val;
      end_time = i4val;

      if (record_class == 1)
	{
        readMainProductHeaderRecord(in,offset);
      printf("scanline: %d\n", scanline);
	printf("1repeat\n"); 
	}

      else if (record_class == 5)
	{
      printf("scanline: %d\n", scanline);
        readGlobalInternalAuxiliaryDataRecord(in,offset);
      printf("scanline: %d\n", scanline);
	printf("5repeat\n"); 
	}
	

      else if (record_class == 8)
	{
/*
      printf("scanline: %d\n", scanline);
        readMeasurementDataRecord(in,out,offset);
	printf("8repeat\n");
      printf("scanline: %d\n", scanline);
*/
	}


      offset = offset + record_length;
	/*printf("offset= %d\n",offset); */
	printf("offset= %d\n\n",offset); 
      }


    /* Process the last data frame header */

    if (data_frame_count != 0)
      addDataFrameHeader(out);

    /*output_record--;*/

    fclose(in);

    /* Build the next input file name */

    input_file_number++;
    sprintf(input_file_name, "in.file%d", input_file_number);

    }


  /* Update the output file header */

  output_header[2] = output_record - 1;

  if (SWAP_OUT == MYTRUE)
    {
    for (i=0; i<EIDF_HEADER_VALUES; i++)
      output_header[i] = htonl(output_header[i]);
    }

  fseek(out, 0, SEEK_SET);
  fwrite(&output_header, EIDF_RECORD_LENGTH, 1, out);

  fclose(out);

/*  printf("\nThe file has been read\n\n");*/
  }



/* ===============================================================================*/
readMainProductHeaderRecord(FILE *in, long offset)
  {
  int    record_class, instr_group, rec_subclass, subclass_ver, record_length;
  int    i, n, i4val;
  short  i2val;
  char   c;

  fseek(in, offset, SEEK_SET);

  fread(&c, 1, 1, in);
  record_class = n;

  fread(&c, 1, 1, in);
  instr_group = n;

  fread(&c, 1, 1, in);
  rec_subclass = n;

  fread(&c, 1, 1, in);
  subclass_ver = n;

  fread(&i4val, 4, 1, in);
  if (SWAP_IN == MYTRUE)
    record_length = ntohl(i4val);

  fread(&i2val, 2, 1, in);
  fread(&i4val, 4, 1, in);

  fread(&i2val, 2, 1, in);
  fread(&i4val, 4, 1, in);

  /*printf("Main Product Header Record\n\n");*/

  for (i=offset; i<(record_length-20); i++)
    {
    fread(&c, 1, 1, in);
    /*printf("%c", c);*/
    }

/*  printf("\n\n");*/
  }



/* ===============================================================================*/
readGlobalInternalAuxiliaryDataRecord(FILE *in, long offset)
  {
  int    record_class, instr_group, rec_subclass, subclass_ver, record_length;
  int    i, n, i4val;
  short  i2val;
  unsigned char c;
  unsigned long int ipressure;


  fseek(in, offset, SEEK_SET);

  fread(&c, 1, 1, in);
  record_class = n;

  fread(&c, 1, 1, in);
  instr_group = n;

  fread(&c, 1, 1, in);
  rec_subclass = n;

  fread(&c, 1, 1, in);
  subclass_ver = n;

  fread(&i4val, 4, 1, in);
  if (SWAP_IN == MYTRUE)
    record_length = ntohl(i4val);

  fread(&i2val, 2, 1, in);
  fread(&i4val, 4, 1, in);

  fread(&i2val, 2, 1, in);
  fread(&i4val, 4, 1, in);

/*  printf("Global Internal Auxiliary Data Record\n\n");*/


  /* Read the temperature pressures */

  fread(&c, 1, 1, in);
  num_temp_levels = c;

  printf("Number of temp pressure levels:  %d\n", num_temp_levels);

  for (i=0; i<num_temp_levels; i++)
    {
    fread(&ipressure, 4, 1, in);

    if (SWAP_IN == MYTRUE)
      ipressure = ntohl(ipressure);

    temp_pressures[i] = ipressure / 10000.0;

    if (i >= num_temp_levels)
      temp_pressures[i] = -32768.0;
/*
    printf("temp pressures:   %d   %d    %f\n", i, ipressure, temp_pressures[i]);	
*/
    }


  /* Read the moisture pressures */

  fread(&c, 1, 1, in);
  num_moisture_levels = c;

/*  printf("Number of moisture pressure levels:  %d\n", num_moisture_levels);*/

  for (i=0; i<num_moisture_levels; i++)
    {
    fread(&ipressure, 4, 1, in);

    if (SWAP_IN == MYTRUE)
      ipressure = ntohl(ipressure);

    moisture_pressures[i] = ipressure / 10000.0;

    if (i >= num_moisture_levels)
      moisture_pressures[i] = -32768.0;

    /*printf("wvap pressures:   %d   %d    %f\n", i, ipressure, moisture_pressures[i]);*/
    }


  /* Read the ozone pressures */

  fread(&c, 1, 1, in);
  num_ozone_levels = c;

/*  printf("Number of ozone pressure levels:  %d\n", num_ozone_levels);*/

  for (i=0; i<num_ozone_levels; i++)
    {
    for (n=0; n<2; n++)
      {
      fread(&ipressure, 4, 1, in);

      if (SWAP_IN == MYTRUE)
        ipressure = ntohl(ipressure);

      ozone_pressures[i][n] = ipressure / 10000.0;

      if (i >= num_ozone_levels)
        ozone_pressures[i][n] = -32768.0;
      }

    /*printf("ozone pressures:   %d   %d    %f   %f\n", i, ipressure, 
             ozone_pressures[i][0], ozone_pressures[i][1]);*/
    }


  /* Read the ozone pressures */

  fread(&c, 1, 1, in);
  num_emiss_wavelengths = c;

  printf("Number of emissivity wavelengths:  %d\n", num_emiss_wavelengths);

/*  printf("\n\n");*/
  }



/* ===============================================================================*/
readMeasurementDataRecord(FILE *in, FILE *out, long rec_offset)
  {
  int    i, n, i4val, fov, level;
  int    year[120], mmdd[120], hour[120], mmss[120];
  int    start_date, start_time, end_date, end_time;
  float  time_interval, ftime;
  int    fov_date, fov_time, yyyymmdd, hhmmss;
  long   offset, time1, time2;
  short  i2val;
  short  buffer[EIDF_DATA_VALUES];

  int    num_surf_temps[120], num_clouds[120], cloud_phase[120][3];
  int    instr_mode, time_attitude, nav_status;
  int    altitude, instrument_flag, processing_flag;
  int    atovs_cloud[120], atovs_completeness[120], atovs_to_iasi[120];
  int    avhrr_completeness[120], avhrr_validation[120], channel_selection[120];
  int    num_avhrr_clouds[120], num_cloud_and_height[120], cloud_phase_flag[120];
  int    cloud_summary[120], cloud_tests[120], day_night[120], fg_to_iterative[120];
  int    final_retrieval_choice[120], cloud_fraction_selection[120];
  int    level_1_validation[120], cloud_test_result[120], iasi_tarm_path[120];
  int    retrieval_initialisation[120], convergence[120], state_vector_validation[120];
  int    surface_type[120], retrieval_iterations[120], forecast_validation[120];
  int    retrieval_quality[120], retrieval_acceptance[120];
  int    iasi_choice[120], sat_manouevre[120], background_state[120];
  int    avhrr_surf_temp_ind[120], surface_type_flag[120], sun_glint[120];
  int    superadiabatic[120], supersaturation[120], thin_cirrus_test[120];
  int    thin_cirrus_correction[120], cloud_clearing[120];
  float  temps[120][90], wvapor[120][90], surface_pressure[120];
  float  ozone[120][10], i_ozone[120], surface_temps[120][2];
  float  n2o[120], co[120], ch4[120], co2[120];
  float  emissivity[120][20], roll, pitch, yaw;
  float  cloud_fraction[120][3], ctt[120][3], ctp[120][3];
  float  sol_zenith[120], sol_azimuth[120], sat_zenith[120], sat_azimuth[120];
  float  lat[120], lon[120];

  unsigned char ch;
  unsigned short int uint2;
  unsigned long int uint4;


  /* If enough scan lines have been read to fill a data frame, then
     create and write a data frame record */
      printf("scanline: %d\n", scanline);

  if (data_frame_line_number > 34)
    addDataFrameHeader(out);
  else
    data_frame_line_number++;


  /* Increment the scan line */

  scanline++;
      printf("scanline: %d\n", scanline);


  /* Read the scan line start and end dates/times */

  offset = rec_offset + 8;
    printf("rec_offset:    %d\n", rec_offset);	
  fseek(in, offset, SEEK_SET);

  fread(&uint2, 2, 1, in);
  fread(&uint4, 4, 1, in);

  if (SWAP_IN == MYTRUE)
    {
    uint2 = ntohs(uint2);
    uint4 = ntohl(uint4);
    }

  start_date = uint2;
  start_time = uint4;

  fread(&uint2, 2, 1, in);
  fread(&uint4, 4, 1, in);

  if (SWAP_IN == MYTRUE)
    {
    uint2 = ntohs(uint2);
    uint4 = ntohl(uint4);
    }

  end_date = uint2;
  end_time = uint4;


  /* Calculate the date/time of each FOV */

  time1 = start_time;

  if (end_date == start_date)
    time2 = end_time;
  else
    time2 = 86400000 + end_time;

  time_interval = (time2 - time1) / 120.0;

  fov_date = start_date;
  ftime = start_time;


  for (fov=0; fov<120; fov++)
    {
    fov_time = ftime;

    yyyymmdd = convertEpochToYYYYMMDD(fov_date);
    hhmmss = convertMillisToHHMMSS(fov_time);

    year[fov] = yyyymmdd / 10000;
    mmdd[fov] = yyyymmdd % 10000;
    hour[fov] = hhmmss / 10000;
    mmss[fov] = hhmmss % 10000;

    ftime = ftime + time_interval;

    if (ftime > 86400000.0)
      {
      fov_date++;
      ftime = ftime - 86400000.0;
      }
    }


  /* Read in the IASI data */


  /* Instrument and processing flags */

  offset = rec_offset + 20;
    printf("rec_offset:    %d\n", rec_offset);	
  fseek(in, offset, SEEK_SET);

  fread(&ch, 1, 1, in);
  instrument_flag = ch;

  fread(&ch, 1, 1, in);
  processing_flag = ch;

/*      printf("flags:   %d    %c     %c\n", scanline, instrument_flag, processing_flag);*/

  /* Atmospheric temperatures */

/*  for (fov=0; fov<120; fov++) */
  for (fov=0; fov<1; fov++) 
    {
    for (level=0; level<num_temp_levels; level++)
      {
      fread(&uint2, 2, 1, in);
      
      if (SWAP_IN == MYTRUE)
        uint2 = ntohs(uint2);

      if ((uint2 != 65535) && (uint2 != 0))
        temps[fov][level] = uint2 / 100.0;
      else
        temps[fov][level] = -32768.0;

/*      printf("temps:   %d    %d    %d   %d\n", scanline, fov, level, uint2);*/
      }
    }
      printf("temps:  %f\n", temps[1][30]);


  /* Atmospheric water vapor */

  for (fov=0; fov<120; fov++)
    {
    for (level=0; level<num_moisture_levels; level++)
      {
      fread(&uint4, 4, 1, in);
      
      if (SWAP_IN == MYTRUE)
        uint4 = ntohl(uint4);

      if (uint4 != -1)
        wvapor[fov][level] = uint4 / 1000.0;
      else
        wvapor[fov][level] = -32768.0;

      /*printf("wvapor:  %d   %d   %d   %d\n", scanline, fov, level, uint4);*/
      }
    }


  /* Atmospheric ozone */

  for (fov=0; fov<120; fov++)
    {
    for (level=0; level<num_ozone_levels; level++)
      {
      fread(&uint2, 2, 1, in);
      
      if (SWAP_IN == MYTRUE)
        uint2 = ntohs(uint2);

      if (uint2 != 65535)
        ozone[fov][level] = uint2 / 100.0;
      else
        ozone[fov][level] = -32768.0;

      /*printf("ozone:   %d    %d    %d   %d\n", scanline, fov, level, uint2);*/
      }
    }


  /* Integrated ozone */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
      
    if (SWAP_IN == MYTRUE)
      uint2 = ntohs(uint2);

    if (uint2 != 65535)
      i_ozone[fov] = uint2 / 100.0;
    else
      i_ozone[fov] = -32768.0;

    /*printf("i_ozone:   %d    %d    %d   %d\n", scanline, fov, level, uint2);*/
    }


  /* Number of surface temps */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    num_surf_temps[fov] = ch;

    /*printf("num surf temps:  %d   %d   %d\n", scanline, fov, num_surf_temps[fov]);*/
    }


  /* Surface temps */

  for (fov=0; fov<120; fov++)
    {
    for (level=0; level<2; level++)
      {
      fread(&uint2, 2, 1, in);
      
      if (SWAP_IN == MYTRUE)
        uint2 = ntohs(uint2);

      if ((uint2 != 65535) && (uint2 != 0))
        surface_temps[fov][level] = uint2 / 100.0;
      else
        surface_temps[fov][level] = -32768.0;

      /*printf("surf temps:   %d    %d    %d   %d\n", scanline, fov, level, uint2);*/
      }
    }


  /* N2O */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
      
    if (SWAP_IN == MYTRUE)
      uint2 = ntohs(uint2);

    if (uint2 != 65535)
      n2o[fov] = uint2 / 100.0;
    else
      n2o[fov] = -32768.0;

    /*printf("N2O:   %d    %d    %d   %d\n", scanline, fov, level, uint2);*/
    }


  /* CO */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
      
    if (SWAP_IN == MYTRUE)
      uint2 = ntohs(uint2);

    if (uint2 != 65535)
      co[fov] = uint2 / 100.0;
    else
      co[fov] = -32768.0;

    /*printf("CO:   %d    %d    %d   %d\n", scanline, fov, level, uint2);*/
    }


  /* CH4 */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
      
    if (SWAP_IN == MYTRUE)
      uint2 = ntohs(uint2);

    if (uint2 != 65535)
      ch4[fov] = uint2 / 100.0;
    else
      ch4[fov] = -32768.0;

    /*printf("CH4:   %d    %d    %d   %d\n", scanline, fov, level, uint2);*/
    }


  /* CO2 */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
      
    if (SWAP_IN == MYTRUE)
      uint2 = ntohs(uint2);

    if (uint2 != 65535)
      co2[fov] = uint2 / 100.0;
    else
      co2[fov] = -32768.0;

    /*printf("CO2:   %d    %d    %d\n", scanline, fov, uint2);*/
    }


  /* Surface emissivity */

  for (fov=0; fov<120; fov++)
    {
    for (level=0; level<num_emiss_wavelengths; level++)
      {
      fread(&uint2, 2, 1, in);
      
      if (SWAP_IN == MYTRUE)
        uint2 = ntohs(uint2);

      if (uint2 != 65535)
        emissivity[fov][level] = uint2 / 100.0;
      else
        emissivity[fov][level] = -32768.0;

      /*printf("emissivity:   %d    %d    %d   %d\n", scanline, fov, level, uint2);*/
      }
    }


  /* Number of cloud formations */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    num_clouds[fov] = ch;

    /*printf("num clouds:  %d   %d   %d\n", scanline, fov, num_clouds[fov]);*/
    }


  /* Cloud fraction */

  for (fov=0; fov<120; fov++)
    {
    for (level=0; level<3; level++)
      {
      fread(&uint2, 2, 1, in);
      
      if (SWAP_IN == MYTRUE)
        uint2 = ntohs(uint2);

      if (uint2 != 65535)
        cloud_fraction[fov][level] = uint2 / 100.0;
      else
        cloud_fraction[fov][level] = -32768.0;
      }

    /*printf("Cloud Fraction:  %d   %d    %f   %f   %f\n", scanline, fov,
           cloud_fraction[fov][0], cloud_fraction[fov][1], cloud_fraction[fov][2]);*/
    }


  /* Cloud top temperature */

  for (fov=0; fov<120; fov++)
    {
    for (level=0; level<3; level++)
      {
      fread(&uint2, 2, 1, in);
      
      if (SWAP_IN == MYTRUE)
        uint2 = ntohs(uint2);

      if (uint2 != 65535)
        ctt[fov][level] = uint2 / 100.0;
      else
        ctt[fov][level] = -32768.0;
      }

    /*printf("ctt:  %d  %d   %f   %f   %f\n", scanline, fov, ctt[fov][0], ctt[fov][1], ctt[fov][2]);*/
    }


  /* Cloud top pressure */

  for (fov=0; fov<120; fov++)
    {
    for (level=0; level<3; level++)
      {
      fread(&uint4, 4, 1, in);
      
      if (SWAP_IN == MYTRUE)
        uint4 = ntohl(uint4);

      if (uint4 != -1)
        ctp[fov][level] = uint4 / 1000.0;
      else
        ctp[fov][level] = -32768.0;
      }

    /*printf("Cloud Top Pressure:  %d   %d    %f   %f   %f\n", scanline, fov,
           ctp[fov][0], ctp[fov][1], ctp[fov][2]);*/
    }


  /* Cloud phase */

  for (fov=0; fov<120; fov++)
    {
    for (level=0; level<3; level++)
      {
      fread(&ch, 1, 1, in);
      cloud_phase[fov][level] = ch;
      }

    /*printf("Cloud Phase:  %d   %d    %d   %d   %d\n", scanline, fov,
           cloud_phase[fov][0], cloud_phase[fov][1], cloud_phase[fov][2]);*/
    }


  /* Surface pressure */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint4, 4, 1, in);

    if (SWAP_IN == MYTRUE)
      uint4 = ntohl(uint4);

    if (uint4 != -1)
      surface_pressure[fov] = uint4 / 100.0;
    else
      surface_pressure[fov] = -32768.0;

    /*printf("surf press:  %d   %d   %d   %f\n", scanline, fov, uint4, surface_pressure[fov]);*/
    }


  /* Instrument mode */

  fread(&ch, 1, 1, in);
  instr_mode = ch;


  /* Time attitude */

  fread(&uint4, 4, 1, in);

  if (SWAP_IN == MYTRUE)
    uint4 = ntohl(uint4);

  time_attitude = uint4;

  /*printf("Time Attitude:  %d\n", time_attitude);*/


  /* Roll, pitch and yaw */

  fread(&i2val, 2, 1, in);

  if (SWAP_IN == MYTRUE)
    i2val = ntohs(i2val);

  roll = i2val / 100.0;

  fread(&i2val, 2, 1, in);

  if (SWAP_IN == MYTRUE)
    i2val = ntohs(i2val);

  pitch = i2val / 100.0;

  fread(&i2val, 2, 1, in);

  if (SWAP_IN == MYTRUE)
    i2val = ntohs(i2val);

  yaw = i2val / 100.0;

  /*printf("Roll/Pitch/Yaw:   %f   %f   %f\n", roll, pitch, yaw);*/


  /* Navigation status */

  fread(&uint4, 4, 1, in);


  /* Altitude */

  fread(&uint4, 4, 1, in);

  if (SWAP_IN == MYTRUE)
    uint4 = ntohl(uint4);

  altitude = uint4;

  /*printf("Altitude:  %d\n", altitude);*/


  /* Zenith and azimuth angles */

  for (fov=0; fov<120; fov++)
    {
    fread(&i2val, 2, 1, in);

    if (SWAP_IN == MYTRUE)
      i2val = ntohs(i2val);

    sol_zenith[fov] = i2val / 100.0;

    fread(&i2val, 2, 1, in);

    if (SWAP_IN == MYTRUE)
      i2val = ntohs(i2val);

    sat_zenith[fov] = i2val / 100.0;

    fread(&i2val, 2, 1, in);

    if (SWAP_IN == MYTRUE)
      i2val = ntohs(i2val);

    sol_azimuth[fov] = i2val / 100.0;

    fread(&i2val, 2, 1, in);

    if (SWAP_IN == MYTRUE)
      i2val = ntohs(i2val);

    sat_azimuth[fov] = i2val / 100.0;

    /*printf("Zenith/Azimuth:  %d  %d   %f   %f   %f   %f\n", scanline, fov,
           sol_zenith[fov], sat_zenith[fov], sol_azimuth[fov], sat_azimuth[fov]);*/
    }


  /* Latitudes and longitudes */

  for (fov=0; fov<120; fov++)
    {
    fread(&i4val, 4, 1, in);

    if (SWAP_IN == MYTRUE)
      i4val = ntohl(i4val);

    lat[fov] = i4val / 10000.0;


    fread(&i4val, 4, 1, in);

    if (SWAP_IN == MYTRUE)
      i4val = ntohl(i4val);

    lon[fov] = i4val / 10000.0;

    /*printf("Lat/Lon:  %d   %d     %f   %f\n", scanline, fov, lat[fov], lon[fov]);*/
    }

  /* Store the lat/lon of the endpoints for use in the data frame */

  if (data_frame_line_number == 1)
    {
    data_frame_lats[0] = lat[0] * 128+0.5;
    data_frame_lons[0] = lon[0] * 128+0.5;
    data_frame_lats[1] = lat[119] * 128+0.5;
    data_frame_lons[1] = lon[119] * 128+0.5;
    }

  data_frame_lats[2] = lat[119] * 128+0.5;
  data_frame_lons[2] = lon[119] * 128+0.5;
  data_frame_lats[3] = lat[0] * 128+0.5;
  data_frame_lons[3] = lon[0] * 128+0.5;


  /* ATOVS cloud flag */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    atovs_cloud[fov] = ch;

    /*printf("ATOVS Cloud:  %d   %d    %d\n", scanline, fov, atovs_cloud[fov]);*/
    }


  /* ATOVS completeness */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    atovs_completeness[fov] = ch;

    /*printf("ATOVS Completeness:  %d   %d    %d\n", scanline, fov, atovs_completeness[fov]);*/
    }


  /* ATOVS to IASI */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    fread(&ch, 1, 1, in);
    fread(&ch, 1, 1, in);
    atovs_to_iasi[fov] = -32768;
    }


  /* AVHRR completeness */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    avhrr_completeness[fov] = ch;

    /*printf("AVHRR completeness:  %d   %d    %d\n", scanline, fov, avhrr_completeness[fov]);*/
    }



  /* AVHRR validation */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    avhrr_validation[fov] = ch;

    /*printf("AVHRR validation:  %d   %d    %d\n", scanline, fov, avhrr_validation[fov]);*/
    }


  /* Channel selection */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    channel_selection[fov] = ch;

    /*printf("Channel selection:  %d   %d    %d\n", scanline, fov, channel_selection[fov]);*/
    }


  /* Num AVHRR clouds */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    num_avhrr_clouds[fov] = ch;

    /*printf("Num AVHRR Clouds:  %d   %d    %d\n", scanline, fov, num_avhrr_clouds[fov]);*/
    }


  /* Num cloud and height */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
    num_cloud_and_height[fov] = uint2;

    /*printf("Num cloud and height:  %d   %d    %d\n", scanline, fov, num_cloud_and_height[fov]);*/
    }


  /* Cloud phase flag */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    cloud_phase_flag[fov] = ch;

    /*printf("Cloud phase flag:  %d   %d    %d\n", scanline, fov, cloud_phase_flag[fov]);*/
    }


  /* Cloud summary */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
    cloud_summary[fov] = uint2;

    /*printf("Cloud summary:  %d   %d    %d\n", scanline, fov, cloud_summary[fov]);*/
    }


  /* Cloud tests */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    cloud_tests[fov] = ch;

    /*printf("Cloud tests:  %d   %d    %d\n", scanline, fov, cloud_tests[fov]);*/
    }


  /* Day/night flag */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    day_night[fov] = ch;

    /*printf("Day/Night:  %d   %d    %d\n", scanline, fov, day_night[fov]);*/
    }


  /* 1st guess to iterative */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
    fg_to_iterative[fov] = uint2;

    /*printf("1st guess to iterative:  %d   %d    %d\n", scanline, fov, fg_to_iterative[fov]);*/
    }


  /* Final retrieval choice */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint4, 4, 1, in);
    final_retrieval_choice[fov] = uint4;

    /*printf("Final retrieval choice:  %d   %d    %d\n", scanline, fov, final_retrieval_choice[fov]);*/
    }


  /* Cloud fraction selection */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    cloud_fraction_selection[fov] = ch;

    /*printf("Cloud fraction selection:  %d   %d    %d\n", scanline, fov, cloud_fraction_selection[fov]);*/
    }


  /* Level 1 validation */

  for (fov=0; fov<120; fov++)
    {
    fread(&uint2, 2, 1, in);
    level_1_validation[fov] = uint2;

    /*printf("Level 1 validation:  %d   %d    %d\n", scanline, fov, level_1_validation[fov]);*/
    }


  /* Cloud test result */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    cloud_test_result[fov] = ch;

    /*printf("Cloud test result:  %d   %d    %d\n", scanline, fov, cloud_test_result[fov]);*/
    }


  /* IASI tarm path */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    iasi_tarm_path[fov] = ch;

    /*printf("IASI tarm path:  %d   %d    %d\n", scanline, fov, iasi_tarm_path[fov]);*/
    }


  /* Retrieval initalisation */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    retrieval_initialisation[fov] = ch;

    /*printf("Retrieval initialisation:  %d   %d    %d\n", scanline, fov, retrieval_initialisation[fov]);*/
    }


  /* Convergence */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    convergence[fov] = ch;

    /*printf("Convergence:  %d   %d    %d\n", scanline, fov, convergence[fov]);*/
    }


  /* State vector validation */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    state_vector_validation[fov] = ch;

    /*printf("State vector validation:  %d   %d    %d\n", scanline, fov, state_vector_validation[fov]);*/
    }


  /* Surface type */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    surface_type[fov] = ch;

    /*printf("Surface type:  %d   %d    %d\n", scanline, fov, surface_type[fov]);*/
    }


  /* Retrieval iterations */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    retrieval_iterations[fov] = ch;

    /*printf("Retrieval iterations:  %d   %d    %d\n", scanline, fov, retrieval_iterations[fov]);*/
    }


  /* Forecast validation */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    forecast_validation[fov] = ch;

    /*printf("Forecast validation:  %d   %d    %d\n", scanline, fov, forecast_validation[fov]);*/
    }


  /* Retrieval quality */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    retrieval_quality[fov] = ch;

    /*printf("Retrieval quality:  %d   %d    %d\n", scanline, fov, retrieval_quality[fov]);*/
    }


  /* Retrieval acceptance */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    retrieval_acceptance[fov] = ch;

    /*printf("Retrieval acceptance:  %d   %d    %d\n", scanline, fov, retrieval_acceptance[fov]);*/
    }


  /* Out of bounds */

  for (fov=0; fov<120; fov++)
    {
    for (i=0; i<32; i++)
      fread(&ch, 1, 1, in);
    }


  /* IASI choice */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    iasi_choice[fov] = ch;

    /*printf("IASI choice:  %d   %d    %d\n", scanline, fov, iasi_choice[fov]);*/
    }


  /* Sat manouevre */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    sat_manouevre[fov] = ch;

    /*printf("Sat manouevre:  %d   %d    %d\n", scanline, fov, sat_manouevre[fov]);*/
    }


  /* Background state */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    background_state[fov] = ch;

    /*printf("Background state:  %d   %d    %d\n", scanline, fov, background_state[fov]);*/
    }


  /* AVHRR surf temp indicator */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    avhrr_surf_temp_ind[fov] = ch;

    /*printf("AVHRR surf temp ind:  %d   %d    %d\n", scanline, fov, avhrr_surf_temp_ind[fov]);*/
    }


  /* Surface type flag */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    surface_type_flag[fov] = ch;

    /*printf("Surface type flag:  %d   %d    %d\n", scanline, fov, surface_type_flag[fov]);*/
    }


  /* Sun glint */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    sun_glint[fov] = ch;

    /*printf("Sun glint:  %d   %d    %d\n", scanline, fov, sun_glint[fov]);*/
    }


  /* Superadiabatic */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    superadiabatic[fov] = ch;

    /*printf("Superadiabatic:  %d   %d    %d\n", scanline, fov, superadiabatic[fov]);*/
    }


  /* Supersaturation */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    supersaturation[fov] = ch;

    /*printf("Supersaturation:  %d   %d    %d\n", scanline, fov, supersaturation[fov]);*/
    }


  /* Thin cirrus test */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    thin_cirrus_test[fov] = ch;

    /*printf("Thin cirrus test:  %d   %d    %d\n", scanline, fov, thin_cirrus_test[fov]);*/
    }


  /* Thin cirrus correction */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    thin_cirrus_correction[fov] = ch;

    /*printf("Thin cirrus correction:  %d   %d    %d\n", scanline, fov, thin_cirrus_correction[fov]);*/
    }


  /* Cloud clearing */

  for (fov=0; fov<120; fov++)
    {
    fread(&ch, 1, 1, in);
    cloud_clearing[fov] = ch;

    /*printf("Cloud clearing:  %d   %d    %d\n", scanline, fov, cloud_clearing[fov]);*/
    }


  /* Copy the data to the output buffer for each FOV */

/*  for (fov=1; fov<120; fov++) */
  for (fov=0; fov<120; fov++) 
    {
    for (i=0; i<EIDF_DATA_VALUES; i++)
      buffer[i] = -32768;


    /* Fill the output buffer with the IASI values that have been read in */

    buffer[0] = 0;

    buffer[3] = lat[fov] * 128+0.5;
    buffer[4] = lon[fov] * 128+0.5;

    buffer[5] = year[fov];
    buffer[6] = mmdd[fov];
    buffer[7] = hour[fov];
    buffer[8] = mmss[fov];

    buffer[12] = scanline;
/*    buffer[13] = fov; */
    buffer[13] = fov+1; 

    buffer[15] = altitude+0.5;
    buffer[16] = sol_zenith[fov]+0.5;
    buffer[17] = sat_zenith[fov]+0.5;
    buffer[18] = sol_azimuth[fov]+0.5;
    buffer[19] = sat_azimuth[fov]+0.5;

    buffer[29] = atovs_cloud[fov];
    buffer[30] = atovs_completeness[fov];
    buffer[31] = atovs_to_iasi[fov];
    buffer[32] = avhrr_completeness[fov];
    buffer[33] = avhrr_validation[fov];
    buffer[34] = channel_selection[fov];
    buffer[35] = num_avhrr_clouds[fov];
    buffer[36] = num_cloud_and_height[fov];
    buffer[37] = cloud_phase_flag[fov];
    buffer[38] = cloud_summary[fov];
    buffer[39] = cloud_tests[fov];
    buffer[40] = day_night[fov];
    buffer[41] = fg_to_iterative[fov];
    buffer[42] = final_retrieval_choice[fov];
    buffer[43] = cloud_fraction_selection[fov];
    buffer[44] = level_1_validation[fov];
    buffer[45] = cloud_test_result[fov];
    buffer[46] = iasi_tarm_path[fov];
    buffer[47] = retrieval_initialisation[fov];
    buffer[48] = convergence[fov];
    buffer[49] = state_vector_validation[fov];
    buffer[50] = surface_type[fov];
    buffer[51] = retrieval_iterations[fov];
    buffer[52] = forecast_validation[fov];
    buffer[53] = retrieval_quality[fov];
    buffer[54] = retrieval_acceptance[fov];

    buffer[56] = iasi_choice[fov];
    buffer[57] = sat_manouevre[fov];
    buffer[58] = background_state[fov];
    buffer[59] = avhrr_surf_temp_ind[fov];
    buffer[60] = surface_type_flag[fov];
    buffer[61] = sun_glint[fov];
    buffer[62] = superadiabatic[fov];
    buffer[63] = supersaturation[fov];
    buffer[64] = thin_cirrus_test[fov];
    buffer[65] = thin_cirrus_correction[fov];
    buffer[66] = cloud_clearing[fov];

    buffer[69] = instrument_flag;
    buffer[70] = processing_flag;


    for (level=0; level<num_temp_levels; level++)
      {
      if (level < 30)
        buffer[99+level] = temp_pressures[level] * 1000+0.5;
      else
        buffer[99+level] = temp_pressures[level] * 10+0.5;

      if (temps[fov][level] != -32768)
        buffer[299+level] = temps[fov][level] * 64+0.5;
      }

    for (level=0; level<num_moisture_levels; level++)
      {
      if (level < 30)
        buffer[189+level] = moisture_pressures[level] * 1000+0.5;
      else
        buffer[189+level] = moisture_pressures[level] * 10+0.5;

      if (wvapor[fov][level] != -32768)
        buffer[389+level] = log(wvapor[fov][level]) * 1024+0.5;
      }

    for (level=0; level<num_ozone_levels; level++)
      {
      buffer[279+level] = ozone_pressures[level][0] * 10+0.5;

      if (temps[fov][level] != -32768)
        buffer[479+level] = ozone[fov][level] * 32+0.5;
      }

    if (i_ozone[fov] != -32768)
      buffer[499] = i_ozone[fov] * 32+0.5;

    buffer[500] = num_surf_temps[fov];

    if (surface_temps[fov][0] != -32768)
      buffer[501] = surface_temps[fov][0] * 64+0.5;

    if (surface_temps[fov][0] != -32768)
      buffer[502] = surface_temps[fov][1] * 64+0.5;

    if (n2o[fov] != -32768)
      buffer[503] = n2o[fov] * 100+0.5;

    if (co[fov] != -32768)
      buffer[504] = co[fov] * 32+0.5;

    if (ch4[fov] != -32768)
      buffer[505] = ch4[fov] * 100+0.5;

    if (co2[fov] != -32768)
      buffer[506] = co2[fov] * 100+0.5;

    for (level=0; level<num_emiss_wavelengths; level++)
      {
      if (emissivity[fov][level] != -32768)
        buffer[509+level] = emissivity[fov][level] * 100+0.5;
      }

    buffer[529] = num_clouds[fov];

    for (level=0; level<3; level++)
      {
      if (cloud_fraction[fov][level] != -32768)
        buffer[530+level] = cloud_fraction[fov][level] * 100+0.5;

      if (ctt[fov][level] != -32768)
        buffer[533+level] = ctt[fov][level] * 64+0.5;

      if (ctp[fov][level] != -32768)
        buffer[536+level] = ctp[fov][level] * 10+0.5;

      buffer[539+level] = cloud_phase[fov][level];
      }

    if (surface_pressure[fov] != -32768)
      buffer[542] = surface_pressure[fov] * 10+0.5;


    /* Swap the bytes if necessary */

    if (SWAP_OUT == MYTRUE)
      {
      for (i=0; i<EIDF_DATA_VALUES; i++)
        buffer[i] = ntohs(buffer[i]);
      }


    /* Write the output buffer to the output file */

    output_record++;

    offset = (output_record - 1) * EIDF_RECORD_LENGTH;
    fseek(out, offset, SEEK_SET);
    fwrite(&buffer, EIDF_RECORD_LENGTH, 1, out);

    data_frame_count++;
    }

  }



addDataFrameHeader(FILE *out)
  {
  long  offset;
  short buffer[EIDF_DATA_VALUES];
  int   i;

  data_frame_number++;

  /* Fill the buffer */

  for (i=0; i<EIDF_DATA_VALUES; i++)
    buffer[i] = -32768;

  buffer[0] = 3;
  buffer[1] = data_frame_number;
  buffer[2] = data_frame_count;

  for (i=0; i<4; i++)
    {
    buffer[i+4] = data_frame_lats[i];
    buffer[i+8] = data_frame_lons[i];
    }

  /* Write the buffer to the output file */

  if (SWAP_OUT == MYTRUE)
    {
    for (i=0; i<EIDF_DATA_VALUES; i++)
      buffer[i] = ntohs(buffer[i]);
    }
  
  offset = (data_frame_record - 1) * EIDF_RECORD_LENGTH;
  fseek(out, offset, SEEK_SET);
  fwrite(&buffer, EIDF_RECORD_LENGTH, 1, out);

  /* Prepare for the next data frame */

  output_record++;
  data_frame_record = output_record;

  data_frame_line_number = 0;
  data_frame_count = 0;

  data_frame_number = data_frame_number;

  for (i=0; i<4; i++)
    {
    data_frame_lats[i] = -32768;
    data_frame_lons[i] = -32768;
    }
  }



int convertEpochToYYYYMMDD(fov_date)
  {
  int yyyymmdd;
  int epoch_day, year, month, day, julday;
  int days_in_year;

  epoch_day = fov_date + 1;

  year = 2000;
  days_in_year = 366;

  while (epoch_day > days_in_year)
    {
    epoch_day = epoch_day - days_in_year;
    year++;

    if (isLeapYear(year) == MYFALSE)
      days_in_year = 365;
    else
      days_in_year = 366;
    }

  julianToDate(epoch_day, year, &month, &day);

  yyyymmdd = (year * 10000) + (month * 100) + day;

  return yyyymmdd;
  }



int convertMillisToHHMMSS(int millis)
  {
  int hhmmss, hours, minutes, seconds;

  seconds = millis / 1000;

  hours = seconds / 3600;
  seconds = seconds - (hours * 3600);

  minutes = seconds / 60;
  seconds = seconds - (minutes * 60);

  hhmmss = (hours * 10000) + (minutes * 100) + seconds;

  return hhmmss;
  }



int isLeapYear(int year)
  {
  int leap_year = MYFALSE;

  if ((year % 4) == 0)
    {
    if ((year % 100) == 0)
      {
      if ((year % 400) == 0)
        leap_year = MYTRUE;
      }
    else
      {
      leap_year = MYTRUE;
      }
    }

  return leap_year;
  }



julianToDate(int julday, int year, int* month, int* day)
  {
  int imonth, iday;

  int  days_in_month[13] = {0,31,28,31,30,31,30,31,31,30,31,30,31};

  if (isLeapYear(year) == MYTRUE)
    days_in_month[2] = 29;

  imonth = 0;
  iday   = julday;

  while ((imonth < 12) && (iday > days_in_month[imonth+1]))
    {
    imonth++;
    iday = iday - days_in_month[imonth];
    }

  imonth++;

  *month = imonth;
  *day   = iday;
  }

/* end of file */
