#!/usr/bin/perl 
# this script includes jobs of ftp iasi l2 files (480) and convert them
# from native eps to direct access format
#

# define dir
$OUT_DIR = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$LOC_DIR = "/data/data065/nprovs/data/matchup/DailyGranules_incoming/eidf";
$DATA_DIR = "/data/data065/nprovs/data/matchup/DailyGranules_incoming/EUiasi_incoming_M03";

$EXE_DIR = "/data/data065/nprovs/source/matchup/eu_iasiNEW_processing/code";
$LOG_DIR = "/data/data065/nprovs/source/matchup/eu_iasiNEW_processing/logs";
$TMP_DIR = "/data/data065/nprovs/source/matchup/eu_iasiNEW_processing";

# Goto exec directory
chdir ("$EXE_DIR") or die "Cannot cd to $EXE_DIR:$!\n";

#$LOG_FILE = "LOG_DAILY.M01";
$LOG_FILE = "LOG_DAILY.manydays.M03";
open (LOGFILE, ">>$LOG_DIR/$LOG_FILE");
print LOGFILE "\n++++++ Begin to start the main script++++\n";
print LOGFILE `date`;
print LOGFILE "  \n";


for ($year =2024; $year<=2024; $year++)
 {
        $mon1=1;
        $mon2=12;

        #
                if( $year == 2024 ) {$mon1=11};
                if( $year == 2024 ) {$mon2=11};

	for ($mon =$mon1; $mon<=$mon2; $mon++)
    {
        $day1=1;
        $day2=31;
        if ( ($mon ==1) || ($mon ==3) || ($mon ==5) || ($mon==7) || ($mon==8) || ($mon==10) || ($mon==12) ) {$day2=31};
        if ( ($mon ==4) || ($mon ==6) || ($mon ==9) || ($mon==11) ) {$day2=30};
        if ( ($mon ==2) & ($year % 4 ==0) ) {$day2=29};
        if ( ($mon ==2) & ($year % 4 !=0) ) {$day2=28};


	 ###
        if( $year == 2024 & $mon==11) {$day1=4};
        if( $year == 2024 & $mon==11) {$day2=4};
        #if( $year == 2024 & $mon==7) {$day2=30};
                #print "$year $mon $day2\n";
                #
           for ($day =$day1; $day<=$day2; $day++)
 {
	 #$yearmonday =sprintf("%04d%02d%02d", $year, $mon, $day);
                $year=$year;
                $mon=$mon;
                $mday=$day;
	 	$BASEDAY =sprintf("%04d%02d%02d", $year, $mon, $day);

		$year=sprintf("%04d",$year);
 		$mon=sprintf("%02d",$mon);
 		$mday=sprintf("%02d",$mday);

                print "$BASEDAY\n";
                print "$year $mon $mday\n";

print LOGFILE "\n+++ $BASEDAY +++\n";

#$BASEDAY =20240318;

#remove all files that are currently in the local directory
@files = glob "$DATA_DIR/IASI_SND*";
foreach $file (@files)
  {
  unlink $file;
  }
#
#
# Goto exec directory
chdir ("$EXE_DIR") or die "Cannot cd to $EXE_DIR:$!\n";
 system ("$EXE_DIR/get_data.euiasiV06_M03.manual.x $year $mon $mday");



# Goto exec directory
chdir ("$EXE_DIR") or die "Cannot cd to $EXE_DIR:$!\n";

# Run iasiToIDDF 
my $eidf_file1 = "$LOC_DIR/eu_iasiV06.M03.eidf1";
my $eidf_file2 = "$LOC_DIR/eu_iasiV06.M03.eidf2";
my $eidf_file = "eu_iasiV06.metopC.eidf";
$eidf_out_file = "eu_iasiC_$BASEDAY.eidf";


# Remove the previous 2 eidf files
unlink $eidf_file1 or warn "Cannot unlink the eidf1 file";
unlink $eidf_file2 or warn "Cannot unlink the eidf2 file";


# find teh total number of granule files
my @iasifiles = glob "$DATA_DIR/IASI_SND_02_M03_$BASEDAY*";

$tot = @iasifiles;
        printf("tot= %d\n", $tot);
$mod = $tot%2;
        printf("residual mod= %d\n", $mod);

#split the total number into two halfs
$num_half01 = ($tot -$mod)/2;
$num_half02 = ($tot -$mod)/2 + $mod;
        printf("num_half01= %d\n", $num_half01);
        printf("num_half02= %d\n", $num_half02);


my @iasifiles_01;
my @iasifiles_02;
$num=0;
foreach $file (@iasifiles)
{
        $num=$num+1;

        if($num <= $num_half01) {
        push @iasifiles_01, $file;
                }

        if($num >$num_half01) {
        push @iasifiles_02, $file;
		}
}


$half_01 = @iasifiles_01;
        printf("half_01= %d\n", $half_01);
$half_02 = @iasifiles_02;
        printf("half_02= %d\n", $half_02);



$num=0;
foreach $file (@iasifiles_01)
  {
#  print "\n-------------------------------\n";
#  print "Processing file: ". $file, "\n\n";

  # Link the files

	$num=$num+1;
		
#	printf("number= %d\n", $num);
	print LOGFILE "number= ". $num,$file,"\n";

  symlink $eidf_file1, "out.file" or warn "Cannot link $eidf_file1 to out.file";
  system "$EXE_DIR/EUIASItoEUIDDFnew.x $file >> $LOG_DIR/$LOG_FILE";
#  system "$EXE_DIR/EUIASItoEUIDDFnew.x $file";

  unlink "out.file" or warn "Cannot unlink the out.file";
	if($num >350) {
		last;
		}
  }

#system ("rm in.file*");
#system ("rm out.file");

$num=0;
foreach $file (@iasifiles_02)
  {
#  print "\n-------------------------------\n";
#  print "Processing file: ". $file, "\n\n";

  # Link the files

	$num=$num+1;
		
#	printf("number= %d\n", $num);
	print LOGFILE "number= ". $num,$file,"\n";

  symlink $eidf_file2, "out.file" or warn "Cannot link $eidf_file2 to out.file";
  system "$EXE_DIR/EUIASItoEUIDDFnew.x $file >> $LOG_DIR/$LOG_FILE";

  unlink "out.file" or warn "Cannot unlink the out.file";
	if($num >350) {
		last;
		}
  }

#system ("rm in.file*");
#system ("rm out.file");

  system "$EXE_DIR/iasiv06_m03_combine.exe >> $LOG_DIR/$LOG_FILE";

#move teh file to incoming daily dir
#  system ("mv $LOC_DIR/$eidf_file  $TMP_DIR");
  system ("mv $LOC_DIR/$eidf_file  $OUT_DIR/$eidf_out_file");

#remove all files that are currently in the local directory
#@files = glob "$DATA_DIR/IASI_SND*";
#foreach $file (@files)
#  {
#  unlink $file;
#  }

	print LOGFILE "The execution is successfully completed !!!\n";
close(LOGFILE);

                }
        }
    }


#remove all old files that are currently in the local directory
@files = glob "$DATA_DIR/IASI_SND*";
foreach $file (@files)
	{
  		if (-M $file > 4)
      		{
          		unlink $file;
         	}
         }



# end of file
