#!/usr/bin/perl 
# this script includes jobs of ftp iasi l2 files (480) and convert them
# from native eps to direct access format
#

# define dir
#$OUT_DIR = "/data/data065/nprovs/data/matchup/DailyFiles_incoming";
$LOC_DIR = "/data/data065/nprovs/data/matchup/DailyGranules_incoming/eidf_t";

$DATA_DIR = "/data/data065/nprovs/data/matchup/DailyGranules_incoming/EUiasi_incoming_t";

#$EXE_DIR = "/data/data065/nprovs/source/matchup/eu_iasiNEW_processing/code";
$EXE_DIR = "/data/data065/nprovs/source/matchup/eu_iasiNEW_processing/man_run";
$LOG_DIR = "/data/data065/nprovs/source/matchup/eu_iasiNEW_processing/man_run/logs";
$TMP_DIR = $LOC_DIR;
#$TMP_DIR = "/data/data065/nprovs/source/matchup/eu_iasiNEW_processing/eidf_t";
$EXE_getdata = "get_data.euiasiV06_M02.manual.x";
$EXE_combine = "iasiv06_m02_combine_t.exe";
$EXE_decode = "EUIASItoEUIDDFnew.x";

# define file name
$LOG_FILE = "LOG_DAILY.M02";
open (LOGFILE, ">>$LOG_DIR/$LOG_FILE");
print LOGFILE "\n++++++ Begin to start the main script++++\n";
print LOGFILE `date`;
print LOGFILE "  \n";


#baseday is the day preceding to the exe_date
$data_date = time();
$data_date -= 86400*1;
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime ($data_date);
$year += 1900;
$mon++;
$BASEDAY = sprintf("%d%02d%02d",$year,$mon,$mday);
print LOGFILE "\n+++ $BASEDAY +++\n";


for ($year =2019; $year<=2019; $year++)
 {

	if( $year == 2019 ) {$mon1=12};
        if( $year == 2019 ) {$mon2=12};

    for ($mon =$mon1; $mon<=$mon2; $mon++)
    {
        $day1=1;
        $day2=31;
        if ( ($mon ==1) || ($mon ==3) || ($mon ==5) || ($mon==7) || ($mon==8) || ($mon==10) || ($mon==12) ) {$day2=31};
        if ( ($mon ==4) || ($mon ==6) || ($mon ==9) || ($mon==11) ) {$day2=30};
        if ( ($mon ==2) & ($year % 4 ==0) ) {$day2=29};
        if ( ($mon ==2) & ($year % 4 !=0) ) {$day2=28};

        if( $year == 2019 & $mon==12) {$day1=17};
        if( $year == 2019 & $mon==12) {$day2=17};

	for ($day =$day1; $day<=$day2; $day++)
                {
                 $yearmonday =sprintf("%04d%02d%02d", $year, $mon, $day);

		$BASEDAY=$yearmonday;
#$BASEDAY =20191211;
#
#
#remove all files that are currently in the local directory
@files = glob "$DATA_DIR/IASI_SND*";
foreach $file (@files)
  {
  unlink $file;
  }


# pull the files from scdr
#system ("$EXE_DIR/get_data.euiasiV06_M02.manual.x $BASEDAY >> $LOG_DIR/$LOG_FILE");
system ("$EXE_DIR/$EXE_getdata $BASEDAY >> $LOG_DIR/$LOG_FILE");

# Goto exec directory
chdir ("$EXE_DIR") or die "Cannot cd to $EXE_DIR:$!\n";

# Run iasiToIDDF 
my $eidf_file1 = "$LOC_DIR/eu_iasiV06.M02.eidf1";
my $eidf_file2 = "$LOC_DIR/eu_iasiV06.M02.eidf2";
my $eidf_file = "eu_iasiV06.metopA.eidf";
my $eidf_outfile = "eu_iasiA_$BASEDAY.eidf";


# Remove the previous 2 eidf files
unlink $eidf_file1 or warn "Cannot unlink the eidf1 file";
unlink $eidf_file2 or warn "Cannot unlink the eidf2 file";


# find teh total number of granule files
my @iasifiles = glob "$DATA_DIR/IASI_SND_02_M02_$BASEDAY*";

$tot = @iasifiles;
        printf("tot= %d\n", $tot);
$mod = $tot%2;
        printf("residual mod= %d\n", $mod);

#split the total number into two halfs
$num_half01 = ($tot -$mod)/2;
$num_half02 = ($tot -$mod)/2 + $mod;
        printf("num_half01= %d\n", $num_half01);
        printf("num_half02= %d\n", $num_half02);


my @iasifiles_01;
my @iasifiles_02;
$num=0;
foreach $file (@iasifiles)
{
        $num=$num+1;

        if($num <= $num_half01) {
        push @iasifiles_01, $file;
                }

        if($num >$num_half01) {
        push @iasifiles_02, $file;
		}
}


$half_01 = @iasifiles_01;
        printf("half_01= %d\n", $half_01);
$half_02 = @iasifiles_02;
        printf("half_02= %d\n", $half_02);



$num=0;
foreach $file (@iasifiles_01)
  {
#  print "\n-------------------------------\n";
#  print "Processing file: ". $file, "\n\n";

  # Link the files

	$num=$num+1;
		
#	printf("number= %d\n", $num);
	print LOGFILE "number= ". $num,$file,"\n";

  symlink $eidf_file1, "out.file" or warn "Cannot link $eidf_file1 to out.file";
  system "$EXE_DIR/$EXE_decode $file >> $LOG_DIR/$LOG_FILE";

  unlink "out.file" or warn "Cannot unlink the out.file";
	if($num >350) {
		last;
		}
  }

#system ("rm in.file*");
#system ("rm out.file");

$num=0;
foreach $file (@iasifiles_02)
  {
#  print "\n-------------------------------\n";
#  print "Processing file: ". $file, "\n\n";

  # Link the files

	$num=$num+1;
		
#	printf("number= %d\n", $num);
	print LOGFILE "number= ". $num,$file,"\n";

  symlink $eidf_file2, "out.file" or warn "Cannot link $eidf_file2 to out.file";
  system "$EXE_DIR/$EXE_decode $file >> $LOG_DIR/$LOG_FILE";

  unlink "out.file" or warn "Cannot unlink the out.file";
	if($num >350) {
		last;
		}
  }

#system ("rm in.file*");
#system ("rm out.file");

  system "$EXE_DIR/$EXE_combine >> $LOG_DIR/$LOG_FILE";

#move teh file to incoming daily dir
#  system ("mv $LOC_DIR/$eidf_file  $TMP_DIR");
  system ("mv $LOC_DIR/$eidf_file  $TMP_DIR/$eidf_outfile");




	}
    }
 }
#remove all files that are currently in the local directory
#@files = glob "$DATA_DIR/IASI_SND*";
#foreach $file (@files)
#  {
#  unlink $file;
#  }

#remove all old files that are currently in the local directory
#@files = glob "$DATA_DIR/IASI_SND*";
#foreach $file (@files)
#	{
#  		if (-M $file > 2)
#      		{
#          		unlink $file;
#         	}
#         }



# end of file
