      function getlon(point)
      implicit none
      
C  The value of point is expected to be between 1 and 
C  1038240. There are 1440 longitide points for each of
C  721 latitude points. Longitudes start at 0.0 degrees.

      real*4 getlon
      integer point, lonpoint

      real*4 startlon
      startlon = 0.0
      
      if (point.le.1440) then
         lonpoint = point - 1
      else
         lonpoint = (mod(point,1440)) -1
      end if

      getlon = startlon + (float(lonpoint) * 0.25)

      if (getlon.gt.180.0) getlon = getlon - 360.0

      return

      end


