      program gfsBinaryToDailyFile
      implicit none
C ***************************************************************
C
C   Date: 1 August 2019
C
C   Programmer: V. Krishna Kumar (RTi)
C
C  Platform: Linux server
C  Function: This program reads in records from GFS binary files for four
C  synoptic times and creates a GFS Analysis Data File (GADF).
C  The data are broken down into 2592 5 X 5-degree data frames.
C  (360*180)/(5*5) = 2,592 data frames
C  Each data frame contains data from all four synoptic times.
C  GFS Analysis Data File (801) formatted file describes a RODF-type
C  file format that contains GFS Analysis pressure, temperature and 
C  moisture profiles at 0.25 degree grids. Each data frame contains
C  profiles for four synoptic times. The data record
C
C ***************************************************************

      integer*4 reclength, outfile, infile00, infile06, infile12
      integer*4 infile18, numframes, framenum

      parameter(reclength=424,numframes=2592)

      real*4 startlat(numframes), endlat(numframes), startlon(numframes), endlon(numframes)
      real*4 lonstart

      logical isinfile, isfile00, isfile06, isfile12, isfile18

      integer*4 fileheader(reclength / 4), ioerr, YYYY, MMDD, word
      integer*4 outrec, startrec, inrec, latline, recstart(numframes)
      integer*2 frameheader(reclength / 2), datarecord(reclength / 2)

      character*100 erchar

      outfile = 11
      infile00 = 20
      infile06 = 21
      infile12 = 22
      infile18 = 23

      isinfile = .false.

C-- Open the 00Z GFS binary file
     
      open(infile00,access="DIRECT",form="UNFORMATTED",recl=reclength,
     +     status="OLD",iomsg=erchar,iostat=ioerr)

      if (ioerr.eq.0) then
         isinfile = .true.
         isfile00 = .true.
      else
         isfile00 = .false.
         print *,'Error ',ioerr,' opening infile00 '
         print *,'Iomsg ',erchar
      end if

C-- Open the 06Z GFS binary file
     
      open(infile06,access="DIRECT",form="UNFORMATTED",recl=reclength,
     +     status="OLD",iomsg=erchar,iostat=ioerr)
      if (ioerr.eq.0) then
         isinfile = .true.
         isfile06 = .true.
      else
         isfile06 = .false.
         print *,'Error ',ioerr,' opening infile06 '
         print *,'Iomsg ',erchar
      end if

C-- Open the 12Z GFS binary file
     
      open(infile12,access="DIRECT",form="UNFORMATTED",recl=reclength,
     +     status="OLD",iomsg=erchar,iostat=ioerr)
      if (ioerr.eq.0) then
         isinfile = .true.
         isfile12 = .true.
      else
         isfile12 = .false.
         print *,'Error ',ioerr,' opening infile12 '
         print *,'Iomsg ',erchar
      end if

C-- Open the 18Z GFS binary file
     
      open(infile18,access="DIRECT",form="UNFORMATTED",recl=reclength,
     +     status="OLD",iomsg=erchar,iostat=ioerr)
      if (ioerr.eq.0) then
         isinfile = .true.
         isfile18 = .true.
      else
         isfile18 = .false.
         print *,'Error ',ioerr,' opening infile18 '
         print *,'Iomsg ',erchar
      end if

      if (.not.(isinfile)) then
         print *,'No synoptic data files found.'
         go to 1000
      end if

C-- Populate the data frame vertices arrays

      lonstart = 0.0
      do framenum = 1, 72
         startlat(framenum) = 90.0
         endlat(framenum) = 85.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 73, 144
         startlat(framenum) = 84.75
         endlat(framenum) = 80.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 145, 216
         startlat(framenum) = 79.75
         endlat(framenum) = 75.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 217, 288
         startlat(framenum) = 74.75
         endlat(framenum) = 70.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 289, 360
         startlat(framenum) = 69.75
         endlat(framenum) = 65.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 361, 432
         startlat(framenum) = 64.75
         endlat(framenum) = 60.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 433, 504
         startlat(framenum) = 59.75
         endlat(framenum) = 55.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 505, 576
         startlat(framenum) = 54.75
         endlat(framenum) = 50.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 577, 648
         startlat(framenum) = 49.75
         endlat(framenum) = 45.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 649, 720
         startlat(framenum) = 44.75
         endlat(framenum) = 40.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 721, 792
         startlat(framenum) = 39.75
         endlat(framenum) = 35.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 793, 864
         startlat(framenum) = 34.75
         endlat(framenum) = 30.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 865, 936
         startlat(framenum) = 29.75
         endlat(framenum) = 25.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 937, 1008
         startlat(framenum) = 24.75
         endlat(framenum) = 20.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1009, 1080
         startlat(framenum) = 19.75
         endlat(framenum) = 15.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1081, 1152
         startlat(framenum) = 14.75
         endlat(framenum) = 10.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1153, 1224
         startlat(framenum) = 9.75
         endlat(framenum) = 5.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1225, 1296
         startlat(framenum) = 4.75
         endlat(framenum) = 0.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1297, 1368
         startlat(framenum) = -0.25
         endlat(framenum) = -5.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1369, 1440
         startlat(framenum) = -5.25
         endlat(framenum) = -10.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1441, 1512
         startlat(framenum) = -10.25
         endlat(framenum) = -15.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1513, 1584
         startlat(framenum) = -15.25
         endlat(framenum) = -20.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1585, 1656
         startlat(framenum) = -20.25
         endlat(framenum) = -25.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1657, 1728
         startlat(framenum) = -25.25
         endlat(framenum) = -30.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1729, 1800
         startlat(framenum) = -30.25
         endlat(framenum) = -35.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1801, 1872
         startlat(framenum) = -35.25
         endlat(framenum) = -40.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1873, 1944
         startlat(framenum) = -40.25
         endlat(framenum) = -45.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 1945, 2016
         startlat(framenum) = -45.25
         endlat(framenum) = -50.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 2017, 2088
         startlat(framenum) = -50.25
         endlat(framenum) = -55.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 2089, 2160
         startlat(framenum) = -55.25
         endlat(framenum) = -60.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 2161, 2232
         startlat(framenum) = -60.25
         endlat(framenum) = -65.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 2233, 2304
         startlat(framenum) = -65.25
         endlat(framenum) = -70.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 2305, 2376
         startlat(framenum) = -70.25
         endlat(framenum) = -75.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 2377, 2448
         startlat(framenum) = -75.25
         endlat(framenum) = -80.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 2449, 2520
         startlat(framenum) = -80.25
         endlat(framenum) = -85.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do
      lonstart = 0.0
      do framenum = 2521, 2592
         startlat(framenum) = -85.25
         endlat(framenum) = -90.0
         startlon(framenum) = lonstart
         if (startlon(framenum).gt.180.0) startlon(framenum) = startlon(framenum) - 360.0
         endlon(framenum) = lonstart + 4.75
         if (endlon(framenum).gt.180.0) endlon(framenum) = endlon(framenum) - 360.0
         lonstart = lonstart + 5.0
      end do

C  Calculate the starting record for each data frame

      startrec = 0
      do framenum = 1, 72
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 21 * 1440
      do framenum = 73, 144
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 41 * 1440
      do framenum = 145, 216
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 61 * 1440
      do framenum = 217, 288
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 81 * 1440
      do framenum = 289, 360
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 101 * 1440
      do framenum = 361, 432
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 121 * 1440
      do framenum = 433, 504
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 141 * 1440
      do framenum = 505, 576
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 161 * 1440
      do framenum = 577, 648
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 181 * 1440
      do framenum = 649, 720
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 201 * 1440
      do framenum = 721, 792
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 221 * 1440
      do framenum = 793, 864
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 241 * 1440
      do framenum = 865, 936
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 261 * 1440
      do framenum = 937, 1008
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 281 * 1440
      do framenum = 1009, 1080
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 301 * 1440
      do framenum = 1081, 1152
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 321 * 1440
      do framenum = 1153, 1224
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 341 * 1440
      do framenum = 1225, 1296
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 361 * 1440
      do framenum = 1297, 1368
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 381 * 1440
      do framenum = 1369, 1440
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 401 * 1440
      do framenum = 1441, 1512
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 421 * 1440
      do framenum = 1513, 1584
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 441 * 1440
      do framenum = 1585, 1656
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 461 * 1440
      do framenum = 1657, 1728
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 481 * 1440
      do framenum = 1729, 1800
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 501 * 1440
      do framenum = 1801, 1872
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 521 * 1440
      do framenum = 1873, 1944
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 541 * 1440
      do framenum = 1945, 2016
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 561 * 1440
      do framenum = 2017, 2088
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 581 * 1440
      do framenum = 2089, 2160
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 601 * 1440
      do framenum = 2161, 2232
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 621 * 1440
      do framenum = 2233, 2304
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 641 * 1440
      do framenum = 2305, 2376
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 661 * 1440
      do framenum = 2377, 2448
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 681 * 1440
      do framenum = 2449, 2520
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      startrec = 701 * 1440
      do framenum = 2521, 2592
         recstart(framenum) = startrec
         startrec = startrec + 20
      end do
      

C  Read in the Year (YYYY) and Month/Day (MMDD) from user input.

      read(5,*) YYYY
      read(5,*) MMDD 


C  Open the output file for direct access write

      open(outfile,access="DIRECT",form="UNFORMATTED",recl=reclength,
     +     iomsg=erchar,iostat=ioerr)

      if (ioerr.ne.0) then
         print *,'Error ',ioerr,' opening output file '
         print *,'Iomsg ',erchar
         go to 1000
      end if

C  Initialize the file header

      do word = 1, (reclength / 4)
         fileheader(word) = 0
      end do

C-- Fill in header values

C   File type ("GADF")
      fileheader(1) = 71656870
C   File version
      fileheader(2) = 10
C   Number of records will be updated at the end of processing
C
C   Length of header record (bytes)
      fileheader(4) = reclength
C   Length of data record (bytes)
      fileheader(5) = reclength
C   Date of file update (YYYYMMDD)
      fileheader(6) = (YYYY*10000) + MMDD

C-- Write the header record to the output file

      outrec = 1
      write(outfile,rec=outrec,iostat=ioerr) fileheader


C ----------------------------------------------------------------------

C-- Process data frames 1-72. Each frame contains 21 X 20 points for each of
C   four synoptic times (21 X 20 X 4 = 1680 points)

      do framenum = 1, 72

C-- Initialize the first data frame header

         do word = 1, (reclength / 2)
            frameheader(word) = 0
         end do

C-- Fill in the data frame header values

C   Record type   
         frameheader(1) = 3
C   Data frame number
         frameheader(2) = framenum
C   Number of records in the frame
         frameheader(3) = 1680
C   Latitudes of frame vertices
         frameheader(5) = NINT(startlat(framenum) * 128.0)
         frameheader(6) = NINT(startlat(framenum) * 128.0)
         frameheader(7) = NINT(endlat(framenum) * 128.0)
         frameheader(8) = NINT(endlat(framenum) * 128.0)
C   Longitudes of frame vertices
         frameheader(9) = NINT(startlon(framenum) * 128.0)
         frameheader(10) = NINT(endlon(framenum) * 128.0)
         frameheader(11) = NINT(endlon(framenum) * 128.0)
         frameheader(12) = NINT(startlon(framenum) * 128.0)

C-- Write the data frame header to the output file

         outrec = outrec + 1
         write(outfile,rec=outrec,iostat=ioerr) frameheader

C-- Copy records for the data frame from the 00Z GFS binary file and write them to
C   the output file

         if (isfile00) then
            startrec = recstart(framenum)
            do latline = 1, 21
               do inrec = startrec+1, startrec+20
                  read(infile00,rec=inrec,iostat=ioerr) datarecord
                  outrec = outrec + 1
                  write(outfile,rec=outrec,iostat=ioerr) datarecord
               end do
               startrec = startrec + 1440
            end do
         end if

C-- Copy records for the data frame from the 06Z GFS binary file and write them to
C   the output file

         if (isfile06) then
            startrec = recstart(framenum)
            do latline = 1, 21
               do inrec = startrec+1, startrec+20
                  read(infile06,rec=inrec,iostat=ioerr) datarecord
                  outrec = outrec + 1
                  write(outfile,rec=outrec,iostat=ioerr) datarecord
               end do
               startrec = startrec + 1440
            end do
         end if

C-- Copy records for the data from the 12Z GFS binary file and write them to
C   the output file

         if (isfile12) then
            startrec = recstart(framenum)
            do latline = 1, 21
               do inrec = startrec+1, startrec+20
                  read(infile12,rec=inrec,iostat=ioerr) datarecord
                  outrec = outrec + 1
                  write(outfile,rec=outrec,iostat=ioerr) datarecord
               end do
               startrec = startrec + 1440
            end do
         end if

C-- Copy records for the data frame from the 18Z GFS binary file and write them to
C   the output file

         if (isfile18) then
            startrec = recstart(framenum)
            do latline = 1, 21
               do inrec = startrec+1, startrec+20
                  read(infile18,rec=inrec,iostat=ioerr) datarecord
                  outrec = outrec + 1
                  write(outfile,rec=outrec,iostat=ioerr) datarecord
               end do
               startrec = startrec + 1440
            end do
         end if
      end do

C-- Process data frames 73-2592. Each frame contains 20 X 20 points for each of
C   four synoptic times (20 X 20 X 4 = 1600 points)

      do framenum = 73, 2592

C-- Initialize the first data frame header

         do word = 1, (reclength / 2)
            frameheader(word) = 0
         end do

C-- Fill in the data frame header values

C   Record type   
         frameheader(1) = 3
C   Data frame number
         frameheader(2) = framenum
C   Number of records in the frame
         frameheader(3) = 1600
C   Latitudes of frame vertices
         frameheader(5) = NINT(startlat(framenum) * 128.0)
         frameheader(6) = NINT(startlat(framenum) * 128.0)
         frameheader(7) = NINT(endlat(framenum) * 128.0)
         frameheader(8) = NINT(endlat(framenum) * 128.0)
C   Longitudes of frame vertices
         frameheader(9) = NINT(startlon(framenum) * 128.0)
         frameheader(10) = NINT(endlon(framenum) * 128.0)
         frameheader(11) = NINT(endlon(framenum) * 128.0)
         frameheader(12) = NINT(startlon(framenum) * 128.0)


C-- Write the data frame header to the output file

         outrec = outrec + 1
         write(outfile,rec=outrec,iostat=ioerr) frameheader

C-- Copy records for the data frame from the 00Z GFS binary file and write them to
C   the output file

         if (isfile00) then
            startrec = recstart(framenum)
            do latline = 1, 20
               do inrec = startrec+1, startrec+20
                  read(infile00,rec=inrec,iostat=ioerr) datarecord
                  outrec = outrec + 1
                  write(outfile,rec=outrec,iostat=ioerr) datarecord
               end do
               startrec = startrec + 1440
            end do
         end if

C-- Copy records for the data frame from the 06Z GFS binary file and write them to
C   the output file

         if (isfile06) then
            startrec = recstart(framenum)
            do latline = 1, 20
               do inrec = startrec+1, startrec+20
                  read(infile06,rec=inrec,iostat=ioerr) datarecord
                  outrec = outrec + 1
                  write(outfile,rec=outrec,iostat=ioerr) datarecord
               end do
               startrec = startrec + 1440
            end do
         end if

C-- Copy records for the data from the 12Z GFS binary file and write them to
C   the output file

         if (isfile12) then
            startrec = recstart(framenum)
            do latline = 1, 20
               do inrec = startrec+1, startrec+20
                  read(infile12,rec=inrec,iostat=ioerr) datarecord
                  outrec = outrec + 1
                  write(outfile,rec=outrec,iostat=ioerr) datarecord
               end do
               startrec = startrec + 1440
            end do
         end if

C-- Copy records for the data frame from the 18Z GFS binary file and write them to
C   the output file

         if (isfile18) then
            startrec = recstart(framenum)
            do latline = 1, 20
               do inrec = startrec+1, startrec+20
                  read(infile18,rec=inrec,iostat=ioerr) datarecord
                  outrec = outrec + 1
                  write(outfile,rec=outrec,iostat=ioerr) datarecord
               end do
               startrec = startrec + 1440
            end do
         end if

      end do

      fileheader(3) = outrec
      write(outfile,rec=1,iostat=ioerr) fileheader

      print *,'Last record = ',outrec

C-- Close the files

      close(outfile)
      if (isfile00) close(infile00)
      if (isfile06) close(infile06)
      if (isfile12) close(infile12)
      if (isfile18) close(infile18)

 1000 continue

      stop
      end

C ----------------------------------------------------------------------
