      program gfsToBinary
      implicit none
C*******************************************************************
C
C   Date: 1 November 2018
C
C   Programmer: V. Krishna Kumar (RTi)
C
C   Platform: Linux server
C
C   Function: This program reads data extracted from GFS GRIB2
C             files and writes out a record for each 0.25-degree grid
C             (1440 x 721 = 1038240) 
C             ydef 721 linear -90.000 0.25
C             xdef 1440 linear 0.0000 0.25000          
C             intersection to a file that can be read and displayed
C             by the Orbital Display System. The output file is also
C             intended to be used in NPROVS matchups.
C             This program is based on Frank Tilley's gfs2bin.f for the
C             0.5 degree grid
C
C*****************************************************************

      integer*4 n, level
      integer*4 numpoints, inreclength, infile, outfile, numwords, I
      integer*4 outreclength, inrec
      parameter(numpoints=1038240,inreclength=(numpoints*4),infile=11,
     +          outfile=20,numwords=212,outreclength=numwords*2)

      integer*4 point, ioerr, word, outrec, lev, top, bottom
      
      integer*4 YYYY, MMDD, HH, lastrec
      integer*2 databuff(numwords), missing
      parameter (missing = -32768)

      real*4 TOT

      real*4 lats(numpoints), lons(numpoints), surpress(numpoints)
      real*4 surtemp(numpoints), surrh(numpoints), surwvmr
      real*4 presstro(numpoints), temptro(numpoints), pressures(47)

      real*4 in_buffer(numpoints)
      real*4 temperatures(47,numpoints)
      real*4 relhums(47,numpoints)
      real*4 water_vapor

      real*4 gfstpw(numpoints)

      real*4 lpw(47), water_vapors(48)

      real*4 getlat, getlon, rh2wvmr, tpw

      character*200 erchar

      data pressures/   1.0,   2.0,   3.0,   5.0,    7.0,  10.0,  20.0,
     +                30.0,  50.0,  70.0, 100.0,  125.0, 150.0, 175.0,
     +               200.0, 225.0, 250.0, 275.0,  300.0, 325.0, 350.0,
     +               375.0, 400.0, 425.0, 450.0,  475.0, 500.0, 525.0,
     +               550.0, 575.0, 600.0, 625.0,  650.0, 675.0, 700.0,
     +               725.0, 750.0, 775.0, 800.0,  825.0, 850.0, 875.0,
     +               900.0, 925.0, 950.0, 975.0, 1000.0/


C-- Get the latitudes and longitudes for the grid points

      do point = 1, numpoints
         lats(point) = getlat(point)
         lons(point) = getlon(point)
      end do

C-- Read in the date and time of the forecast

      read(5,*) YYYY
      read(5,*) MMDD
      read(5,*) HH

C-- Open the binary GFS file for direct access read
     
      open(infile,access="DIRECT",form="UNFORMATTED",status="OLD",
     +     recl=inreclength,iomsg=erchar,iostat=ioerr)

      if (ioerr.ne.0) then
         print *,'Error ',ioerr,' opening input file '
         print *,'Iomsg ',erchar
         go to 1000
      end if

C-- Open the output binary file for direct access write

      open(outfile,access="DIRECT",form="UNFORMATTED",status="UNKNOWN",
     +     recl=outreclength,iomsg=erchar,iostat=ioerr)

      if (ioerr.ne.0) then
         print *,'Error ',ioerr,' opening output file '
         print *,'Iomsg ',erchar
         close(infile)
         go to 1000
      end if

C-- Read the surface pressures from the first record of the file.

      inrec = 1
      read(infile,rec=inrec,iostat=ioerr) surpress

C-- Read the surface temperatures 

      inrec = inrec + 1
      read(infile,rec=inrec,iostat=ioerr) surtemp

C-- Read the surface relative humidities

      inrec = inrec + 1
      read(infile,rec=inrec,iostat=ioerr) surrh

C-- Read the tropopause pressures

      inrec = inrec + 1
      read(infile,rec=inrec,iostat=ioerr) presstro

C-- Read the tropopause temperatures

      inrec = inrec + 1
      read(infile,rec=inrec,iostat=ioerr) temptro

C-- Read the temperatures at 47 levels

      do level = 1, 47
         inrec = inrec + 1
         read(infile, rec=inrec, iostat=ioerr) in_buffer

         do n = 1, numpoints
            temperatures(level,n) = in_buffer(n)
         end do
      end do


C-- Read the relative humidity at 47 levels

      do level = 1, 47
         inrec = inrec + 1
         read(infile, rec=inrec, iostat=ioerr) in_buffer

         do n = 1, numpoints
            relhums(level,n) = in_buffer(n)
         end do
      end do

C-- Read the GFS TPW

      inrec = inrec + 1
      read(infile,rec=inrec,iomsg=erchar,iostat=ioerr) gfstpw

      if (ioerr.ne.0) then
         print *,'Error ',ioerr,' reading gfstpw'
         print *,'Iomsg ',erchar
      end if


C-- Fill the data buffer

      do point = 1, numpoints
         do word = 1, numwords
            databuff(word) = missing
         end do

         databuff(1) = 0
         databuff(2) = 0
         databuff(3) = 0
         databuff(4) = NINT(lats(point) * 128.0)
         databuff(5) = NINT(lons(point) * 128.0)
         databuff(6) = YYYY
         databuff(7) = MMDD
         databuff(8) = HH
         databuff(9) = 0000

C-- Word from 10 to 56 

         do lev = 1, 47
            databuff(9+lev) = NINT(pressures(lev) * 10.0)
         end do

C-- Convert the surface pressure to hPa

         surpress(point) = surpress(point) * 0.01

C-- Calculate the surface WVMR for this point

         surwvmr = rh2wvmr(surrh(point),surtemp(point),surpress(point))

C-- Store the surface data for this point

         databuff(57) = NINT(surpress(point) * 10.0)
         databuff(58) = NINT(surtemp(point) * 64.0)
         databuff(59) = NINT(surrh(point) * 100.0)
         databuff(60) = NINT(surwvmr * 1000.0)

          
C-- Store the analysis temperature profile for this point

         do level = 1, 47
            if (pressures(level) .le. surpress(point)) then
               databuff(60+level) = NINT(temperatures(level,point)*64.0)

               databuff(107+level) = NINT(relhums(level,point)*100.0)

               water_vapors(level) = rh2wvmr(relhums(level,point),
     +                                       temperatures(level,point),
     +                                       pressures(level))

               databuff(154+level) = NINT(water_vapors(level) * 1000.0)
            end if
         end do

         
         bottom = 0
         do lev = 47, 1, -1
            if (bottom.eq.0) then
               if (pressures(lev).le.surpress(point)) then
                  bottom = lev
               end if
            end if
         end do

         top = 0
         if (bottom.ne.0) then
            do lev = 1, bottom
               if (top.eq.0) then
                  if (pressures(lev).ge.200.0) then
                     top = lev
                  end if
               end if
            end do
         end if

         DO I = TOP, BOTTOM
            TOT = TOT + water_vapors(I) 
         END DO
      
         TOT = 0

         if (top.ne.0) then
            call prwater(water_vapors, pressures, lpw, top, bottom,
     +                   surpress(point), surwvmr, tpw)

            databuff(202) = NINT(tpw * 100.0)
         end if

C-- Store the tropopause data for this point

         presstro(point) = presstro(point) * 0.01
         databuff(203) = NINT(presstro(point) * 10.0)
         databuff(204) = NINT(temptro(point) * 64.0)
        
C-- Write the record out to the output file

         outrec = point
         write(outfile,rec=outrec,iomsg=erchar,iostat=ioerr) databuff

         if (ioerr.ne.0) then
            print *,'Error ',ioerr,' writing record ',outrec
            print *,'Iomsg ',erchar
            go to 900
         end if

      end do

  900 continue

      close(infile)
      close(outfile)

 1000 continue

      stop
      end
