      SUBROUTINE PRWATER (WVMR,PR,LPW,TOP,BOTTOM,SFCPRS,SFCWVMR,TPW)
      IMPLICIT NONE
C
C***********************************************************************
C
C   NAME- PRWATER
C
C   LANGUAGE- FORTRAN                   TYPE- SUBROUTINE
C
C   VERSION- 1.0    DATE-  9/01/95   PROGRAMMER- BRUCE WHISTLER
C   VERSION- 2.0    DATE-  6/13/01   PROGRAMMER- FRANK TILLEY (RAYTHEON)
C     ** MULTIPLIED EACH PRECIPITABLE WATER VALUE BY 10.0 TO CONVERT
C        IT FROM CENTIMETERS TO MILLIMETERS UNDER PR #39 **
C   VERSION- 3.0    DATE-  6/17/04   PROGRAMMER- FRANK TILLEY (RAYTHEON)
C     ** RE-HOSTED FROM CEMSCS MVS MAINFRAME TO IBM SP UNIX PLATFORM.
C   VERSION- 4.0    DATE-  4/08/13   PROGRAMMER- FRANK TILLEY (IMSG)
C     ** RENAMED TO PRWATER AND CHANGED NUMBER OF PRESSURES TO 91 FOR ECMWF.
C
C   FUNCTION- COMPUTES PRECIPITABLE WATER FROM A WATER VAPOR
C             MIXING RATIO PROFILE. THE RESULT IS EXPRESSED IN
C             MILLIMETERS.
C
C   CALLING PARAMETERS-
C     VARIABLE             TYPE   I/O  DESCRIPTION
C     --------             ----   ---  -----------
C     WVMR                 REAL    I   MIXING RATIO PROFILE
C
C     PR                   REAL    I   PRESSURE PROFILE
C
C     LPW                  REAL    O   PRECIP WATER PROFILE
C
C     TOP                   INT    I   PRESSURE LEVEL AT THE TOP OF THE
C                                      MIXING RATIO PROFILE
C     BOTTOM                INT    I   PRESSURE LEVEL AT THE BOTTOM OF
C                                      THE MIXING RATIO PROFILE
C     SFCPRS               REAL    I   SURFACE PRESSURE
C     SFCWVMR              REAL    I   SURFACE MIXING RATIO
C     TPW                   INT    O   TOTAL PRECIPITABLE WATER
C                                      FROM THE MIXING RATIO PROFILE
C
C   LOCAL VARIABLES-
C     NAME                 TYPE       DESCRIPTION
C     ----                 ----       -----------
C     I                     INT       LOOP INDEX
C
C     W1                   REAL       MIXING RATIO AT THE UPPER LEVEL
C                                     BOUNDING THE LAYER
C
C     W2                   REAL       MIXING RATIO AT THE LOWER LEVEL
C                                     BOUNDING THE LAYER
C
C     P1                   REAL       PRESSURE AT THE UPPER BOUNDARY
C                                     OF THE LAYER
C
C     P2                   REAL       PRESSURE AT THE LOWER BOUNDARY
C                                     OF THE LAYER
C
C     DP                   REAL       PRESSURE DIFFERENCE BETWEEN THE
C                                     UPPER AND LOWER LAYER BOUNDARIES
C
C     F                    REAL       FIXED VALUE USED TO COMPUTE
C                                     LAYER PRECIPITABLE WATER.
C
C***********************************************************************
C
      REAL       WVMR(47), LPW(47), PR(47),  F, W1, P1, W2, P2, DP, TPW
      REAL       SFCPRS, SFCWVMR, TOT

      INTEGER    TOP, BOTTOM, I

      DATA       F/1961.33/

      TOT = 0.0
      TPW = 0.0
      DO I = TOP, BOTTOM-1
         W1   = WVMR(I)
         W2   = WVMR(I+1)
         P1   = PR(I)
         P2   = PR(I+1)
         DP   = ABS(P2-P1)
         LPW(I) = (W1+W2) * DP/F
         LPW(I) = LPW(I) * 10.0
         TPW = TPW + LPW(I) 
         TOT = TOT + W1
      END DO



      IF (SFCPRS.GT.PR(BOTTOM).AND.SFCWVMR.GT.0.0) THEN
         W1 = WVMR(BOTTOM)
         W2 = SFCWVMR
         P1 = PR(BOTTOM)
         P2 = SFCPRS
         DP = ABS(P2-P1)
         LPW(BOTTOM) = (W1+W2) * DP/F
         LPW(BOTTOM) = LPW(BOTTOM) * 10.0
         TPW = TPW + LPW(BOTTOM)
         TOT = TOT + W1 + W2
      END IF

!      PRINT *,"TOTAL LPW: ",TPW
!      PRINT *,"TPW: ",TPW
!      PRINT *,"TOTAL WVMR: ",TOT
!      PRINT *,"START/STOP: ",PR(TOP),',',PR(BOTTOM)
!      PRINT *,"SURF PRESS: ",SFCPRS

      RETURN
      END
