      REAL FUNCTION RH2WVMR(RelHum,TempK,Pressure)
      IMPLICIT NONE
C------------------------------------------------------------------------
C
C  FUNCTION:  RH2TDEW RETURNS THE WATER VAPOR MIXING RATIO (g/kg) GIVEN
C             THE RELATIVE HUMIDITY (%), AIR TEMPERATURE IN DEGREES
C             Kelvin, AND THE ATMOSPHERIC PRESSURE (hPa).
C
C------------------------------------------------------------------------

      REAL RelHum, TempK, Pressure

      REAL TDEW2MR, satmix, Kelvin, TempC

      PARAMETER(Kelvin=273.15)

      RH2WVMR = 0.0
  
      TempC = TempK - Kelvin

C-- Get the saturation mixing ratio for the given pressure and temperature.

      satmix = TDEW2MR(Pressure,TempC)

C-- Multiply the saturation mixing ratio by the relative humidity percentage
C   to derive the water vapor mixing ratio.

      RH2WVMR = satmix * (RelHum * 0.01)

      RETURN
      END
