      REAL FUNCTION TDEW2MR(PRESSURE,TDEW)
      IMPLICIT NONE
C
C**********************************************************************
C
C   NAME- TDEW2MR
C
C   LANGUAGE- FORTRAN        TYPE- FUNCTION        COMPUTER- IBM SP
C
C   VERSION- 1.0    DATE- 10/13/06   PROGRAMMER- FRANK TILLEY (IMSG)
C 
C   FUNCTION- THIS FUNCTION RETURNS THE WATER VAPOR MIXING RATIO
C             FOR A GIVEN PRESSURE AND DEW POINT TEMPERATURE.
C             THE FUNCTION WAS ORIGINALLY WRITTEN BY
C             MIKE PETTEY (RAYTHEON) IN JAVA FOR THE PDISP PROGRAM.
C
C  CALLING SEQUENCE PARAMETERS-
C     ARGUMENT         TYPE  I/O  FUNCTION
C     --------         ----  ---  --------
C     PRESSURE         REAL   I   ATMOSPHERIC PRESSURE IN MILLIBARS
C     TDEW             REAL   I   DEWPOINT TEMPERATURE IN DEGREES
C                                 CELSIUS
C
C  LOCAL VARIABLES-
C     NAME             TYPE    DESCRIPTION
C     ----             ----    -----------
C     PS               REAL    SATURATION VAPOR PRESSURE
C
C  SUBPROGRAMS CALLED- NONE
C
C  FUNCTIONS USED- VPSAT
C
C******************************************************************
C
      REAL PRESSURE, TDEW
C
      REAL PS, VPSAT

C
C Get the saturation vapor pressure for the temperature.
C
      PS = VPSAT(TDEW)
C
C Calculate the mixing ratio.
C
      TDEW2MR = (622.0 * PS) / (PRESSURE - PS)
C
      RETURN
      END
